/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;

public class TopicIdPartition {
    private final Uuid topicId;
    private final TopicPartition topicPartition;

    public TopicIdPartition(Uuid topicId, TopicPartition topicPartition) {
        this.topicId = Objects.requireNonNull(topicId, "topicId can not be null");
        this.topicPartition = Objects.requireNonNull(topicPartition, "topicPartition can not be null");
    }

    public TopicIdPartition(Uuid topicId, int partition, String topic) {
        this.topicId = Objects.requireNonNull(topicId, "topicId can not be null");
        this.topicPartition = new TopicPartition(topic, partition);
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicIdPartition that = (TopicIdPartition)o;
        return this.topicId.equals(that.topicId) && this.topicPartition.equals(that.topicPartition);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.topicId.hashCode();
        result = 31 * result + this.topicPartition.hashCode();
        return result;
    }

    public String toString() {
        return this.topicId + ":" + this.topic() + "-" + this.partition();
    }
}

