(function() {
    'use strict';

    const inbox = {
        templateUrl: '/static/dataiku/inbox/components/inbox.component.html',
        controller: function($rootScope, $scope, $state, Notification, RequestCenterService){
            this.numberOfPendingDiscussions = 0;
            this.numberOfPendingRequests = 0;
            this.$state = $state;

            this.updateRequestCount = function updateRequestCount() {
                RequestCenterService.getAllRequests().then(result => {
                    this.numberOfPendingRequests = RequestCenterService.numberOfPendingRequests(result);
                }, setErrorInScope.bind($scope));
            }

            const updatePendingRequestsNotificationUnsubscribe = Notification.registerEvent("update-pending-requests", () => {
                this.updateRequestCount();
            });
            $scope.$on('$destroy', updatePendingRequestsNotificationUnsubscribe);

            const discussionsUnreadFullIdsChangedNotificationUnsubscribe = Notification.registerEvent("discussions-unread-full-ids-changed", (_, message) => {
                this.numberOfPendingDiscussions = (message.unreadFullIds || []).length;
            });
            $scope.$on('$destroy', discussionsUnreadFullIdsChangedNotificationUnsubscribe);

            this.$onInit = () => {
                this.updateRequestCount();
                this.numberOfPendingDiscussions = ($rootScope.discussionsUnreadStatus.unreadFullIds || []).length;
            }
        }
    };

    angular.module('dataiku.inbox')
        .component('inbox', inbox);
})();
