(function(){
    'use strict';

    const requestObject = {
        bindings: {
            request: '<',
            requester: '<',
            closer: '<',
            objectProjectName: '<',
            targetProjectName: '<',
            onChange: '&'
        },
        templateUrl: 'static/dataiku/inbox/components/request-center/request/request-object/request-object.component.html',
        controller: function(RequestCenterService) {
            this.$onInit = () => {
                this.onChange({response: {type: 'SharingObjectResponse'}}); // keep type in sync with backend
            }
            this.$onChanges = changes => {
                if (changes.request) {
                    this.objectLink = RequestCenterService.getObjectLink(this.request.objectProjectKey, this.request.objectType, this.request.objectId);
                }
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestObject', requestObject);
})();
