(function () {
    "use strict";
    angular.module("dataiku.opals").factory("ProjectContextService", ProjectContextService);

    function ProjectContextService() {
        function context(stateInfo) {
            return new Promise((resolve, reject) => {
                if (stateInfo.toState.name === "projects.project.security") {
                    resolve({ ...stateInfo, ...{ context: [...stateInfo.context, stateInfo.toParams.selectedTab] } });
                } else {
                    reject(`ProjectContextService: Nominal route (${stateInfo.toState.name}) not matched`);
                }
            });
        }

        return { context };
    }
})();
