###############################################################
# Create code env commands
###############################################################

def import_code_env_in_cache(cmdargs, apiclient):
    print ("Importing code env from %s" % cmdargs.file_dir)
    apiclient.import_code_env_in_cache(cmdargs.file_dir, cmdargs.language)
    print ("OK")


def declare_code_env_import_in_cache(subparsers, apiclient):
    p = subparsers.add_parser("__import-code-env-in-cache", help="Imports a code env in global cache")
    p.add_argument("file_dir")
    p.add_argument("language")
    p.set_defaults(func=import_code_env_in_cache, apiclient=apiclient)


def register_code_env_in_cache(cmdargs, apiclient):
    print ("Registering %s code env exported in %s and built in %s" % (cmdargs.language, cmdargs.exported_env_dir, cmdargs.built_env_dir))
    apiclient.register_code_env_in_cache(cmdargs.exported_env_dir, cmdargs.built_env_dir, cmdargs.language)
    print ("OK")


def declare_code_env_register_in_cache(subparsers, apiclient):
    p = subparsers.add_parser("__register-code-env-in-cache", help="Registers an already built code env in global cache")
    p.add_argument("exported_env_dir")
    p.add_argument("built_env_dir")
    p.add_argument("language")
    p.set_defaults(func=register_code_env_in_cache, apiclient=apiclient)
