from dataiku.doctor.deephub.deephub_scoring import DeepHubScoringEngine
from dataiku.doctor.deephub.image_classification_model import DummyImageClassificationDeepHubModel
from dataiku.doctor.deephub.image_classification_model import ImageClassificationDeepHubModel
from dataiku.doctor.deephub.image_classification_scoring import DummyImageClassificationScoringEngine
from dataiku.doctor.deephub.image_classification_scoring import ImageClassificationScoringEngine
from dataiku.doctor.deephub.image_classification_training import ImageClassificationDeepHubTrainingEngine
from dataiku.doctor.deephub.image_classification_training import DummyImageClassificationDeepHubTrainingEngine
from dataiku.doctor.deephub.object_detection_scoring import ObjectDetectionScoringEngine
from dataiku.doctor.deephub.object_detection_scoring import DummyObjectDetectionScoringEngine
from dataiku.doctor.deephub.deephub_training import DeepHubTrainingEngine
from dataiku.doctor.deephub.object_detection_training import DummyObjectDetectionDeepHubTrainingEngine
from dataiku.doctor.deephub.object_detection_model import DummyObjectDetectionDeepHubModel
from dataiku.doctor.deephub.object_detection_model import ObjectDetectionDeepHubModel
from dataiku.doctor.deephub.deephub_model import DeepHubModel
from dataiku.doctor.deephub.object_detection_training import ObjectDetectionDeepHubTrainingEngine


def load():
    """
    This function should be called prior to using any deephub handler (training, scoring).

    Each Deephub use case (represented as its prediction type, for now "DEEP_HUB_IMAGE_OBJECT_DETECTION") needs to
    implement:
    * a training engine (`dataiku.doctor.deephub.deephub_training.DeepHubTrainingEngine`)
    * a model (`dataiku.doctor.deephub.deephub_model.DeepHubModel`)
    * a scoring engine (`dataiku.doctor.deephub.deephub_scoring.DeepHubScoringEngine`)

    This method is responsible for registering available engines. This means adding a new use case should update this
    function.

    This allows to avoid circular imports (and was greatly inspired from EDA registries).
    """
    # Object detection
    DeepHubTrainingEngine.define(ObjectDetectionDeepHubTrainingEngine)
    DeepHubTrainingEngine.define(DummyObjectDetectionDeepHubTrainingEngine)
    DeepHubModel.define(ObjectDetectionDeepHubModel)
    DeepHubModel.define(DummyObjectDetectionDeepHubModel)
    DeepHubScoringEngine.define(ObjectDetectionScoringEngine)
    DeepHubScoringEngine.define(DummyObjectDetectionScoringEngine)
    
    # Image classification
    DeepHubTrainingEngine.define(ImageClassificationDeepHubTrainingEngine)
    DeepHubTrainingEngine.define(DummyImageClassificationDeepHubTrainingEngine)
    DeepHubModel.define(ImageClassificationDeepHubModel)
    DeepHubModel.define(DummyImageClassificationDeepHubModel)
    DeepHubScoringEngine.define(ImageClassificationScoringEngine)
    DeepHubScoringEngine.define(DummyImageClassificationScoringEngine)
