# coding: utf-8
from enum import Enum

class WorkerStatus(Enum):
    """
    Status of the kernel, corresponding to the Java-side 'WorkerStatus' enum
    It has nothing to do with Python-side 'WorkerState' enum
    """
    # Container is starting
    PENDING = 0
    # Container is ready and is waiting for the master to connect
    READY = 1
    # Container is dead: failed or stopped
    DEAD = 2