import logging
import sklearn

from dataiku.base.utils import package_is_at_least
from sklearn.neighbors import KNeighborsClassifier


class UnpickableKNeighborsClassifier(KNeighborsClassifier, object):

    def __setstate__(self, d):
        if(d.get('_sklearn_version', '999') < '0.24') and package_is_at_least(sklearn, "0.24"):
            d["n_samples_fit_"] = d["_fit_X"].data.shape[0]
        super(KNeighborsClassifier, self).__setstate__(d)
