from dataiku.eda.types import Literal

from dataiku.eda.computations.computation import MultivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.filtering.and_filter import AndFilter
from dataiku.eda.filtering.missing_filter import MissingFilter
from dataiku.eda.filtering.not_filter import NotFilter
from dataiku.eda.types import FetchValuesModel, FetchValuesResultModel


class FetchValues(MultivariateComputation):
    @staticmethod
    def get_type() -> Literal["fetch_values"]:
        return "fetch_values"

    def describe(self) -> str:
        return "FetchValues(%s)" % ','.join(self.columns)

    @staticmethod
    def build(params: FetchValuesModel) -> 'FetchValues':
        return FetchValues(params['columns'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> FetchValuesResultModel:
        output: FetchValuesResultModel = {"type": self.get_type(), "series": []}

        # Reject the whole row when at least one value is missing
        filtered_idf = AndFilter([NotFilter(MissingFilter(column)) for column in self.columns]).apply(idf)

        for column in self.columns:
            series = filtered_idf.float_col(column)
            output["series"].append(list(series))

        return output
