import streamlit as st
import gc

def get_headers() -> dict:
    """
    Return captured http headers for use in dataiku.api_client().get_auth_info_from_browser_headers

    :return: a dict containing http headers
    """
    if hasattr(st, "context"):
        # this works since 1.37.0
        return dict(st.context.headers)
    else:
        return _try_get_streamlit_headers_old_version()


def _try_get_streamlit_headers_old_version():
    """
    :return: http headers
    :exception: if streamlit version is not supported
    """
    try:
        # This is only available from 1.13 and deprecated in 1.36.1 (with visible warning)
        from streamlit.web.server.websocket_headers import _get_websocket_headers
        return _get_websocket_headers()
    except:
        try:
            # this works pre 1.12.2, and has try/excepts for stuff that
            # moved in 1.12.0
            try:
                from streamlit.server.server import Server
                server = Server.get_current()
            except:
                # 1.12.0 removes the easy access to the singleton :(
                server = get_streamlit_server()
            try:
                from streamlit.scriptrunner.script_run_context import get_script_run_ctx
            except:
                from streamlit.runtime.scriptrunner.script_run_context import get_script_run_ctx
            session_id = get_script_run_ctx().session_id  # type: ignore
            session_info = server._get_session_info(session_id)
            try:
                h = dict(session_info.ws.request.headers)
            except:
                h = dict(session_info.client.request.headers)
            return h
        except:
            try:
                # one last try, for 1.12.2
                runtime = get_streamlit_runtime()
                from streamlit.runtime.scriptrunner.script_run_context import get_script_run_ctx
                session_id = get_script_run_ctx().session_id  # type: ignore
                session_info = runtime._get_session_info(session_id)
                return dict(session_info.client.request.headers)
            except:
                raise # not a streamlit version we can use - don't try this again


# very very very ugly hacks to grab the streamlit singletons: forage in the GC....
_streamlit_runtime = None
_streamlit_server = None
def get_singleton_from_gc(lookup):
    for obj in gc.get_objects():
        if type(obj) is lookup:
            return obj
    return None

def get_streamlit_runtime():
    global _streamlit_runtime
    if _streamlit_runtime == False:
        return None
    if _streamlit_runtime is not None:
        return _streamlit_runtime
    try:
        from streamlit.runtime.runtime import Runtime
        _streamlit_runtime = get_singleton_from_gc(Runtime)
        return _streamlit_runtime
    except:
        # don't expect streamlit at all
        _streamlit_runtime = False
    return None

def get_streamlit_server():
    global _streamlit_server
    if _streamlit_server == False:
        return None
    if _streamlit_server is not None:
        return _streamlit_server
    try:
        from streamlit.web.server import Server
        _streamlit_server = get_singleton_from_gc(Server)
        return _streamlit_server
    except:
        # don't expect streamlit at all
        _streamlit_server = False
    return None

