import copy

class ActionHandler:
    def __init__(self, auth_ctx_identifier, params, client):
        """
        Instantiate a new action script handler.

        :param str auth_ctx_identifier: the auth context identifier that triggered the action
        :param dict params: a Python dict of the parameters to pass along with the triggered action
        :param :class:`~dataikuapi.govern_client.GovernClient` client: An instance of :class:`~dataikuapi.govern_client.GovernClient` to access the Govern API
        """
        self.params = params
        self.authCtxIdentifier = auth_ctx_identifier
        self.client = client
        self.message = ''
        self.status = 'SUCCESS'

instance = None

def get_action_handler():
    """
    Return the current handler of :class:`govern.core.ActionHandler`,
    previously set using :meth:`set_action_handler`

    :return: the instance of :class:`govern.core.ActionHandler` that was previously set with :meth:`set_action_handler`
    """
    if instance is not None:
        return instance
    raise Exception("Handler not set")

def set_action_handler(handler):
    """
    Set the current instance of :class:`govern.core.ActionHandler`

    :return: None
    """
    global instance
    instance = handler
