from govern.models import BlueprintVersion, EnrichedArtifact, Artifact
import copy

class MigrationHandler:
    def __init__(self, source_enriched_artifact, target_enriched_blueprint_version, client):
        """
        Instantiate a new Govern migration handler.

        :param dict source_enriched_artifact: a Python dict of the existing enriched artifact to migrate
        :param dict target_enriched_blueprint_version: a Python dict of the enriched target blueprint version
        :param :class:`~dataikuapi.govern_client.GovernClient` client: An instance of :class:`~dataikuapi.govern_client.GovernClient` to access the Govern API
        """

        self.source_enriched_artifact = EnrichedArtifact(source_enriched_artifact) if source_enriched_artifact is not None else None
        self.target_artifact = Artifact(copy.deepcopy(source_enriched_artifact["artifact"])) if source_enriched_artifact is not None else None
        self.target_blueprint_version = BlueprintVersion(target_enriched_blueprint_version["blueprintVersion"]) if target_enriched_blueprint_version is not None else None
        self.client = client
        self.status = 'SUCCESS'
        self.message = ''


instance = None


def get_migration_handler():
    """
    Return the current instance of :class:`govern.core.MigrationHandler`,
    previously set using :meth:`set_migration_handler`

    :return: the instance of :class:`govern.core.MigrationHandler ` that was previously set with :meth:`set_migration_handler`
    """
    if instance is not None:
        return instance
    raise Exception("Handler not set")


def set_migration_handler(handler):
    """
    Set the current instance of :class:`govern.core.MigrationHandler`

    :return: None
    """
    global instance
    instance = handler
