from dataiku.code_env_resources import clear_all_env_vars
from dataiku.code_env_resources import set_env_path
from dataiku.code_env_resources import set_env_var
from dataiku.code_env_resources import grant_permissions

# Clears all environment variables defined by previously run script
clear_all_env_vars()

# Set image classification version environment variable
set_env_var("DKU_DEEP_HUB_IMAGE_CLASSIFICATION_VERSION", "1")

# Set PyTorch cache directory
set_env_path("TORCH_HOME", "pytorch")

# Import PyTorch
import torchvision

# Download pretrained model
torchvision.models.efficientnet_b0(pretrained=True)
torchvision.models.efficientnet_b4(pretrained=True)
torchvision.models.efficientnet_b7(pretrained=True)

# Grant filesystem permissions to pytorch pretrained models
grant_permissions("pytorch")
