SET CONSTRAINTS ALL DEFERRED;

UPDATE blueprint_versions
SET blueprint_version_json = blueprint_version_json || '{"id": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_blueprint_id = 'bp.system.dataiku_saved_model_version' AND blueprint_version_version_id = 'bv.system.default';

UPDATE blueprint_versions_history
SET blueprint_version_json = blueprint_version_json || '{"id": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_blueprint_id = 'bp.system.dataiku_saved_model_version' AND blueprint_version_version_id = 'bv.system.default';

UPDATE blueprint_version_traces
SET blueprint_version_trace_json = blueprint_version_trace_json || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_trace_blueprint_id = 'bp.system.dataiku_saved_model_version' AND blueprint_version_trace_version_id = 'bv.system.default';

UPDATE blueprint_version_traces_history
SET blueprint_version_trace_json = blueprint_version_trace_json || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_trace_blueprint_id = 'bp.system.dataiku_saved_model_version' AND blueprint_version_trace_version_id = 'bv.system.default';

UPDATE signoff_configurations
SET signoff_configuration_json = signoff_configuration_json || JSONB_BUILD_OBJECT('id', signoff_configuration_json -> 'id' || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB)
WHERE signoff_configuration_blueprint_id = 'bp.system.dataiku_saved_model_version' AND signoff_configuration_version_id = 'bv.system.default';

UPDATE signoff_configurations_history
SET signoff_configuration_json = signoff_configuration_json || JSONB_BUILD_OBJECT('id', signoff_configuration_json -> 'id' || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB)
WHERE signoff_configuration_blueprint_id = 'bp.system.dataiku_saved_model_version' AND signoff_configuration_version_id = 'bv.system.default';

UPDATE artifacts
SET artifact_json = artifact_json || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE artifact_blueprint_id = 'bp.system.dataiku_saved_model_version' AND artifact_version_id = 'bv.system.default';

UPDATE artifacts_history
SET artifact_json = artifact_json || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE artifact_blueprint_id = 'bp.system.dataiku_saved_model_version' AND artifact_version_id = 'bv.system.default';

UPDATE signoffs
SET signoff_json = signoff_json || JSONB_BUILD_OBJECT('configuration', signoff_json -> 'configuration' || JSONB_BUILD_OBJECT('id', signoff_json -> 'configuration' -> 'id' || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB))
WHERE signoff_blueprint_id = 'bp.system.dataiku_saved_model_version' AND signoff_version_id = 'bv.system.default';

UPDATE signoffs_history
SET signoff_json = signoff_json || JSONB_BUILD_OBJECT('configuration', signoff_json -> 'configuration' || JSONB_BUILD_OBJECT('id', signoff_json -> 'configuration' -> 'id' || '{"blueprintVersionId": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB))
WHERE signoff_blueprint_id = 'bp.system.dataiku_saved_model_version' AND signoff_version_id = 'bv.system.default';

UPDATE blueprint_role_assignments
SET blueprint_role_assignments_json = (
    CASE WHEN blueprint_role_assignments_json -> 'roleAssignmentsRules' IS NOT NULL AND blueprint_role_assignments_json -> 'roleAssignmentsRules' != 'null'::JSONB AND blueprint_role_assignments_json -> 'roleAssignmentsRules' != '{}'::JSONB
    THEN
        blueprint_role_assignments_json || JSONB_BUILD_OBJECT('roleAssignmentsRules',
            (
                SELECT JSONB_OBJECT_AGG(
                    rar.key,
                    CASE WHEN rar.value IS NOT NULL AND rar.value != 'null'::JSONB AND rar.value != '[]'::JSONB
                    THEN
                        (
                            SELECT JSONB_AGG(
                                CASE WHEN rule -> 'criteria' IS NOT NULL AND rule -> 'criteria' != 'null'::JSONB AND rule -> 'criteria' != '[]'::JSONB
                                THEN
                                    rule || JSONB_BUILD_OBJECT(
                                        'criteria',
                                        (
                                            SELECT JSONB_AGG(
                                                CASE WHEN criterion ->> 'type' = 'blueprint-version-id' AND criterion ->> 'versionId' = 'bv.system.default' THEN (criterion || '{"versionId": "bv.system.prediction"}'::JSONB) ELSE criterion END
                                            ) AS criteria
                                            FROM JSONB_ARRAY_ELEMENTS(rule -> 'criteria') AS criterion -- rule -> 'criteria' should be an array of at least 1 element
                                        )
                                    )
                                ELSE rule
                                END
                            ) FROM JSONB_ARRAY_ELEMENTS(rar.value) AS rule -- rar.value should be an array of at least 1 element
                        )
                    ELSE rar.value
                    END
                ) FROM JSONB_EACH(blueprint_role_assignments_json -> 'roleAssignmentsRules') AS rar -- blueprint_role_assignments_json -> 'roleAssignmentsRules' should be an object of at least 1 element
            )
        )
    ELSE blueprint_role_assignments_json
    END
)
WHERE blueprint_role_assignments_blueprint_id = 'bp.system.dataiku_saved_model_version';

UPDATE blueprint_role_assignments_history
SET blueprint_role_assignments_json = (
    CASE WHEN blueprint_role_assignments_json -> 'roleAssignmentsRules' IS NOT NULL AND blueprint_role_assignments_json -> 'roleAssignmentsRules' != 'null'::JSONB AND blueprint_role_assignments_json -> 'roleAssignmentsRules' != '{}'::JSONB
    THEN
        blueprint_role_assignments_json || JSONB_BUILD_OBJECT('roleAssignmentsRules',
            (
                SELECT JSONB_OBJECT_AGG(
                    rar.key,
                    CASE WHEN rar.value IS NOT NULL AND rar.value != 'null'::JSONB AND rar.value != '[]'::JSONB
                    THEN
                        (
                            SELECT JSONB_AGG(
                                CASE WHEN rule -> 'criteria' IS NOT NULL AND rule -> 'criteria' != 'null'::JSONB AND rule -> 'criteria' != '[]'::JSONB
                                THEN
                                    rule || JSONB_BUILD_OBJECT(
                                        'criteria',
                                        (
                                            SELECT JSONB_AGG(
                                                CASE WHEN criterion ->> 'type' = 'blueprint-version-id' AND criterion ->> 'versionId' = 'bv.system.default' THEN (criterion || '{"versionId": "bv.system.prediction"}'::JSONB) ELSE criterion END
                                            ) AS criteria
                                            FROM JSONB_ARRAY_ELEMENTS(rule -> 'criteria') AS criterion -- rule -> 'criteria' should be an array of at least 1 element
                                        )
                                    )
                                ELSE rule
                                END
                            ) FROM JSONB_ARRAY_ELEMENTS(rar.value) AS rule -- rar.value should be an array of at least 1 element
                        )
                    ELSE rar.value
                    END
                ) FROM JSONB_EACH(blueprint_role_assignments_json -> 'roleAssignmentsRules') AS rar -- blueprint_role_assignments_json -> 'roleAssignmentsRules' should be an object of at least 1 element
            )
        )
    ELSE blueprint_role_assignments_json
    END
)
WHERE blueprint_role_assignments_blueprint_id = 'bp.system.dataiku_saved_model_version';

UPDATE artifact_role_assignments
SET artifact_role_assignments_json = (
    CASE WHEN artifact_role_assignments_json -> 'roleAssignmentsRules' IS NOT NULL AND artifact_role_assignments_json -> 'roleAssignmentsRules' != 'null'::JSONB AND artifact_role_assignments_json -> 'roleAssignmentsRules' != '{}'::JSONB
    THEN
        artifact_role_assignments_json || JSONB_BUILD_OBJECT('roleAssignmentsRules',
            (
                SELECT JSONB_OBJECT_AGG(
                    rar.key,
                    CASE WHEN rar.value IS NOT NULL AND rar.value != 'null'::JSONB AND rar.value != '[]'::JSONB
                    THEN
                        (
                            SELECT JSONB_AGG(
                                CASE WHEN rule -> 'criteria' IS NOT NULL AND rule -> 'criteria' != 'null'::JSONB AND rule -> 'criteria' != '[]'::JSONB
                                THEN
                                    rule || JSONB_BUILD_OBJECT(
                                        'criteria',
                                        (
                                            SELECT JSONB_AGG(
                                                CASE WHEN criterion ->> 'type' = 'blueprint-version-id' AND criterion ->> 'versionId' = 'bv.system.default' THEN (criterion || '{"versionId": "bv.system.prediction"}'::JSONB) ELSE criterion END
                                            ) AS criteria
                                            FROM JSONB_ARRAY_ELEMENTS(rule -> 'criteria') AS criterion -- rule -> 'criteria' should be an array of at least 1 element
                                        )
                                    )
                                ELSE rule
                                END
                            ) FROM JSONB_ARRAY_ELEMENTS(rar.value) AS rule -- rar.value should be an array of at least 1 element
                        )
                    ELSE rar.value
                    END
                ) FROM JSONB_EACH(artifact_role_assignments_json -> 'roleAssignmentsRules') AS rar -- artifact_role_assignments_json -> 'roleAssignmentsRules' should be an object of at least 1 element
            )
        )
    ELSE artifact_role_assignments_json
    END
)
WHERE EXISTS (SELECT 1 FROM artifacts WHERE artifacts.artifact_id = artifact_role_assignments.artifact_role_assignments_artifact_id AND artifacts.artifact_blueprint_id = 'bp.system.dataiku_saved_model_version');

UPDATE artifact_role_assignments_history
SET artifact_role_assignments_json = (
    CASE WHEN artifact_role_assignments_json -> 'roleAssignmentsRules' IS NOT NULL AND artifact_role_assignments_json -> 'roleAssignmentsRules' != 'null'::JSONB AND artifact_role_assignments_json -> 'roleAssignmentsRules' != '{}'::JSONB
    THEN
        artifact_role_assignments_json || JSONB_BUILD_OBJECT('roleAssignmentsRules',
            (
                SELECT JSONB_OBJECT_AGG(
                    rar.key,
                    CASE WHEN rar.value IS NOT NULL AND rar.value != 'null'::JSONB AND rar.value != '[]'::JSONB
                    THEN
                        (
                            SELECT JSONB_AGG(
                                CASE WHEN rule -> 'criteria' IS NOT NULL AND rule -> 'criteria' != 'null'::JSONB AND rule -> 'criteria' != '[]'::JSONB
                                THEN
                                    rule || JSONB_BUILD_OBJECT(
                                        'criteria',
                                        (
                                            SELECT JSONB_AGG(
                                                CASE WHEN criterion ->> 'type' = 'blueprint-version-id' AND criterion ->> 'versionId' = 'bv.system.default' THEN (criterion || '{"versionId": "bv.system.prediction"}'::JSONB) ELSE criterion END
                                            ) AS criteria
                                            FROM JSONB_ARRAY_ELEMENTS(rule -> 'criteria') AS criterion -- rule -> 'criteria' should be an array of at least 1 element
                                        )
                                    )
                                ELSE rule
                                END
                            ) FROM JSONB_ARRAY_ELEMENTS(rar.value) AS rule -- rar.value should be an array of at least 1 element
                        )
                    ELSE rar.value
                    END
                ) FROM JSONB_EACH(artifact_role_assignments_json -> 'roleAssignmentsRules') AS rar -- artifact_role_assignments_json -> 'roleAssignmentsRules' should be an object of at least 1 element
            )
        )
    ELSE artifact_role_assignments_json
    END
)
WHERE EXISTS (
	SELECT 1
    FROM artifacts_history
    WHERE _revision_id IN (
        SELECT DISTINCT ON (h.artifact_id) h._revision_id
        FROM artifacts_history h
        WHERE h._revision_timestamp <= artifact_role_assignments_history._revision_timestamp
        AND h.artifact_id = artifact_role_assignments_history.artifact_role_assignments_artifact_id
        ORDER BY h.artifact_id, h._revision_timestamp DESC, h._revision_id DESC
    )
    AND artifact_blueprint_id = 'bp.system.dataiku_saved_model_version'
);

UPDATE blueprint_version_migration_paths
SET blueprint_version_migration_json = blueprint_version_migration_json || '{"blueprintVersionIdFrom": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_migration_blueprint_id_from = 'bp.system.dataiku_saved_model_version' AND blueprint_version_migration_version_id_from = 'bv.system.default';
UPDATE blueprint_version_migration_paths
SET blueprint_version_migration_json = blueprint_version_migration_json || '{"blueprintVersionIdTo": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_migration_blueprint_id_to = 'bp.system.dataiku_saved_model_version' AND blueprint_version_migration_version_id_to = 'bv.system.default';

UPDATE blueprint_version_migration_paths_history
SET blueprint_version_migration_json = blueprint_version_migration_json || '{"blueprintVersionIdFrom": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_migration_blueprint_id_from = 'bp.system.dataiku_saved_model_version' AND blueprint_version_migration_version_id_from = 'bv.system.default';
UPDATE blueprint_version_migration_paths_history
SET blueprint_version_migration_json = blueprint_version_migration_json || '{"blueprintVersionIdTo": {"blueprintId": "bp.system.dataiku_saved_model_version", "versionId": "bv.system.prediction"}}'::JSONB
WHERE blueprint_version_migration_blueprint_id_to = 'bp.system.dataiku_saved_model_version' AND blueprint_version_migration_version_id_to = 'bv.system.default';


-- other non-migrated parts: custom page artifact filters (not documented even if allowed via API), governance settings (there should be a check that it cannot be a dku blueprint version selected)
