import streamlit as st
import pandas as pd
import numpy as np
import dataiku

st.set_page_config(page_title="Histogram from DataFrame", layout="wide")

st.title("Histogram from DataFrame")
st.write("A simple histogram visualization using Streamlit")

# Load dummy data into a dataframe
df = pd.DataFrame({
    "values": np.random.normal(50, 15, 1000),
})
column = "values"
# end of dummy data

# To use your own dataset, remove the above randomly generated data and uncomment the following
# and replace the data set name and the name of the column containing the distribution to visualize
# df = dataiku.Dataset("YOUR_DATASET_NAME").get_dataframe()
# column = "YOUR_COLUMN_NAME"

# Create histogram
bins = 20 # adjust if needed
cuts = pd.cut(df[column], bins=bins)
hist_data = cuts.value_counts().sort_index()
hist_data.index = [interval.left for interval in hist_data.index]
st.bar_chart(hist_data)

# For more details about Streamlit's charts and other components,
# check Streamlit's documentation: https://docs.streamlit.io
