# A Tiny client for the DSS public API. Internal usage only.

.dku_publicapi__request <- function(method, path, body=NULL, query=NULL) {
    location_data <- dku_intercom__get_location_info()
    prefix <- "/dip/publicapi"

    url <- paste0(location_data$backend_url, prefix, path)
    print(paste("Query", url))

    resp = method(url,body = body, query=query, dku__get_auth_headers(), dku_intercom__get_httr_config(), content_type("application/json"), verbose())
    dku__check_api_error(resp, paste("API call failed on", path))
    return (content(resp))
}