dataframe_to_dss_schema <- function(df) {
    # First, we build the DSS schema in JSON
    outputSchema <- list()
    outputSchema[["userModified"]] <- FALSE
    convertedColumns = list()
    for(i in 1:length(df)) {
        columnName <- colnames(df[i])
        columnRType <- class(df[[i]])
        columnDSSType <- "string"
        if(length(columnRType) == 1) {
            if(columnRType == "numeric") {
                columnDSSType <- "double"
            }
            if(columnRType == "integer") {
                columnDSSType <- "bigint"
            }
            if(columnRType == "logical") {
                columnDSSType <- "boolean"
            }
        }
        convertedColumn = {}
        convertedColumn$name <- columnName
        convertedColumn$type <- columnDSSType
        convertedColumns[[length(convertedColumns)+1]] <- convertedColumn
    }
    outputSchema$columns=convertedColumns
    return(outputSchema)
}