/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.defaults.internal.logstore.LogStoreProvider;
import io.delta.kernel.defaults.internal.parquet.ParquetFileReader;
import io.delta.kernel.defaults.internal.parquet.ParquetFileWriter;
import io.delta.kernel.engine.ParquetHandler;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.DataFileStatus;
import io.delta.kernel.utils.FileStatus;
import io.delta.storage.LogStore;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DefaultParquetHandler
implements ParquetHandler {
    private final Configuration hadoopConf;

    public DefaultParquetHandler(Configuration configuration) {
        this.hadoopConf = configuration;
    }

    public CloseableIterator<ColumnarBatch> readParquetFiles(final CloseableIterator<FileStatus> closeableIterator, final StructType structType, final Optional<Predicate> optional) throws IOException {
        return new CloseableIterator<ColumnarBatch>(){
            private final ParquetFileReader batchReader;
            private CloseableIterator<ColumnarBatch> currentFileReader;
            {
                this.batchReader = new ParquetFileReader(DefaultParquetHandler.this.hadoopConf);
            }

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader, closeableIterator});
            }

            public boolean hasNext() {
                if (this.currentFileReader != null && this.currentFileReader.hasNext()) {
                    return true;
                }
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader});
                this.currentFileReader = null;
                if (closeableIterator.hasNext()) {
                    String string = ((FileStatus)closeableIterator.next()).getPath();
                    this.currentFileReader = this.batchReader.read(string, structType, optional);
                    return this.hasNext();
                }
                return false;
            }

            public ColumnarBatch next() {
                return (ColumnarBatch)this.currentFileReader.next();
            }
        };
    }

    public CloseableIterator<DataFileStatus> writeParquetFiles(String string, CloseableIterator<FilteredColumnarBatch> closeableIterator, List<Column> list) throws IOException {
        ParquetFileWriter parquetFileWriter = new ParquetFileWriter(this.hadoopConf, new Path(string), list);
        return parquetFileWriter.write(closeableIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeParquetFileAtomically(String string, CloseableIterator<FilteredColumnarBatch> closeableIterator) throws IOException {
        block24: {
            try {
                Optional optional;
                FileSystem fileSystem;
                Object object;
                Path path = new Path(string);
                LogStore logStore = LogStoreProvider.getLogStore(this.hadoopConf, path.toUri().getScheme());
                boolean bl = logStore.isPartialWriteVisible(path, this.hadoopConf);
                Path path2 = path;
                if (bl) {
                    object = String.format(".%s.%s.tmp", path.getName(), UUID.randomUUID());
                    path2 = new Path(path.getParent(), (String)object);
                }
                object = new ParquetFileWriter(this.hadoopConf, path2);
                try {
                    fileSystem = ((ParquetFileWriter)object).write(closeableIterator);
                    Throwable throwable = null;
                    try {
                        optional = InternalUtils.getSingularElement(fileSystem);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileSystem != null) {
                            if (throwable != null) {
                                try {
                                    fileSystem.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                fileSystem.close();
                            }
                        }
                    }
                }
                catch (UncheckedIOException uncheckedIOException) {
                    throw uncheckedIOException.getCause();
                }
                Preconditions.checkState((boolean)optional.isPresent(), (String)"expected to write one output file");
                if (!bl) break block24;
                fileSystem = path.getFileSystem(this.hadoopConf);
                boolean bl2 = false;
                try {
                    bl2 = fileSystem.rename(path2, path);
                    if (!bl2) {
                        if (fileSystem.exists(path)) {
                            throw new FileAlreadyExistsException("target file already exists: " + path);
                        }
                        throw new IOException("Failed to rename the file");
                    }
                }
                finally {
                    if (!bl2) {
                        fileSystem.delete(path2, false);
                    }
                }
            }
            catch (Throwable throwable) {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
                throw throwable;
            }
        }
        Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
    }
}

