/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DefaultColumnarBatch
implements ColumnarBatch {
    private final int size;
    private final StructType schema;
    private final List<ColumnVector> columnVectors;

    public DefaultColumnarBatch(int n, StructType structType, ColumnVector[] columnVectorArray) {
        this.schema = structType;
        this.size = n;
        this.columnVectors = Collections.unmodifiableList(Arrays.asList(columnVectorArray));
    }

    public StructType getSchema() {
        return this.schema;
    }

    public ColumnVector getColumnVector(int n) {
        this.checkColumnOrdinal(n);
        return this.columnVectors.get(n);
    }

    public ColumnarBatch withNewColumn(int n, StructField structField, ColumnVector columnVector) {
        if (n < 0 || n > this.columnVectors.size()) {
            throw new IllegalArgumentException("Invalid ordinal: " + n);
        }
        if (columnVector == null || columnVector.getSize() != this.size) {
            throw new IllegalArgumentException("given vector size is not matching the current batch size");
        }
        ArrayList<StructField> arrayList = new ArrayList<StructField>(this.schema.fields());
        arrayList.ensureCapacity(this.schema.length() + 1);
        arrayList.add(n, structField);
        StructType structType = new StructType(arrayList);
        ArrayList<ColumnVector> arrayList2 = new ArrayList<ColumnVector>(this.columnVectors);
        arrayList2.ensureCapacity(this.columnVectors.size() + 1);
        arrayList2.add(n, columnVector);
        return new DefaultColumnarBatch(this.size, structType, arrayList2.toArray(new ColumnVector[0]));
    }

    public ColumnarBatch withDeletedColumnAt(int n) {
        if (n < 0 || n >= this.columnVectors.size()) {
            throw new IllegalArgumentException("Invalid ordinal: " + n);
        }
        ArrayList arrayList = new ArrayList(this.schema.fields());
        arrayList.remove(n);
        StructType structType = new StructType(arrayList);
        ArrayList<ColumnVector> arrayList2 = new ArrayList<ColumnVector>(this.columnVectors);
        arrayList2.remove(n);
        return new DefaultColumnarBatch(this.size, structType, arrayList2.toArray(new ColumnVector[0]));
    }

    public ColumnarBatch withNewSchema(StructType structType) {
        if (!this.schema.equivalent((DataType)structType)) {
            throw new IllegalArgumentException("Given new schema data type is not same as the existing schema");
        }
        return new DefaultColumnarBatch(this.size, structType, this.columnVectors.toArray(new ColumnVector[0]));
    }

    public int getSize() {
        return this.size;
    }

    private void checkColumnOrdinal(int n) {
        if (n < 0 || n >= this.columnVectors.size()) {
            throw new IllegalArgumentException("invalid column ordinal: " + n);
        }
    }
}

