/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DoubleType;
import java.util.Objects;
import java.util.Optional;

public class DefaultDoubleVector
extends AbstractColumnVector {
    private final double[] values;

    public DefaultDoubleVector(int n, Optional<boolean[]> optional, double[] dArray) {
        super(n, (DataType)DoubleType.DOUBLE, optional);
        this.values = Objects.requireNonNull(dArray, "values is null");
        Preconditions.checkArgument((dArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{dArray.length, n});
    }

    @Override
    public double getDouble(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

