/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractLongMeaning;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;

public class DateOnly
extends AbstractLongMeaning {
    public static final DateTimeFormatter FORMATTER = DKUDateUtils.ymdDashOrSlash().withZone(DateTimeZone.UTC);

    @Override
    public String getMeaningId() {
        return "DateOnly";
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    public long msSinceEpoch(String v) {
        char sep2;
        char sep1;
        if (v == null || v.isEmpty()) {
            return Long.MAX_VALUE;
        }
        if (v.length() != 10) {
            return Long.MAX_VALUE;
        }
        if (DateOnly.areDigits(v, 0, 3) && DateOnly.areDigits(v, 5, 6) && DateOnly.areDigits(v, 8, 9) && (sep1 = v.charAt(4)) == (sep2 = v.charAt(7)) && (sep1 == '-' || sep1 == '/')) {
            try {
                return FORMATTER.parseMillis(v);
            }
            catch (Exception e) {
                return Long.MAX_VALUE;
            }
        }
        return Long.MAX_VALUE;
    }

    @Override
    public double detects(String val) {
        return this.msSinceEpoch(val) == Long.MAX_VALUE ? 0.0 : 0.9;
    }

    @Override
    public long longValue(String v) {
        return this.msSinceEpoch(v);
    }

    @Override
    public double doubleValue(String v) {
        long lv = this.longValue(v);
        if (lv == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return lv;
    }

    private static boolean areDigits(String s, int startIndex, int endIndex) {
        for (int i = startIndex; i <= endIndex; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

