/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelib.com.google.common.net.InetAddresses;

public class IPAddress
extends AbstractAnumMeaning {
    private static final FastSafePatternMatcher MATCHER = new FastSafePatternMatcher("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");

    @Override
    public double detects(String v) {
        if (v == null) {
            return 0.0;
        }
        int nbDots = StringUtils.countChar((String)v, (char)'.');
        if (nbDots == 3) {
            return MATCHER.matches(v) ? 0.7 : 0.0;
        }
        int nbColons = StringUtils.countChar((String)v, (char)':');
        if (nbColons >= 2 && v.length() < 40 && "0123456789:ABCDEFabcedf".contains("" + v.charAt(0))) {
            return InetAddresses.isInetAddress((String)v) ? 0.7 : 0.0;
        }
        return 0.0;
    }
}

