/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.HiveJDBCSSOSAMLBrowserServerResponse;
import com.databricks.client.hivecommon.api.WebBrowserClient;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

public class WebBrowserSSOSAMLClient
extends WebBrowserClient {
    public WebBrowserSSOSAMLClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        super(hiveJDBCSettings, iLogger);
    }

    @Override
    public int getPort() {
        return this.m_serverSocket.getLocalPort();
    }

    public synchronized String getToken() {
        return null == this.m_serverResponse ? null : ((HiveJDBCSSOSAMLBrowserServerResponse)this.m_serverResponse).getToken();
    }

    public synchronized String getMessage() {
        return null == this.m_serverResponse ? "" : ((HiveJDBCSSOSAMLBrowserServerResponse)this.m_serverResponse).getMsg();
    }

    @Override
    protected ServerSocket getServerSocket() throws ErrorException {
        ServerSocket serverSocket = null;
        int n = this.m_settings.m_ssoSettings.m_ssoLocalPort;
        try {
            serverSocket = new ServerSocket(n, 0, InetAddress.getByName("localhost"));
            serverSocket.setReuseAddress(true);
            serverSocket.setSoTimeout(100);
            this.m_browserTimeout = this.m_settings.m_ssoSettings.m_ssoBrowserTimeout;
        }
        catch (IOException iOException) {
            ErrorException errorException = null;
            errorException = 0 == n ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_SERVER_PORT_BIND_ERR.name(), "" + n) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_SERVER_PORT_BIND_ERR_WITH_PORT_SET.name(), new String[]{"" + n, "SSOWebServerPort"});
            throw errorException;
        }
        return serverSocket;
    }

    @Override
    protected ErrorException getResponseException() {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_RESPONSE_TIMEOUT.name());
        return errorException;
    }

    @Override
    String getSensitiveInfoLogMessage() {
        return "Token received is: " + this.getToken();
    }
}

