/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.shared.WorkSetPreparator;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.WeightParams;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.AnalysisCoreDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalysisCRUDService {
    @Autowired
    private AnalysisCoreDAO dao;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private PredictionService predictionService;
    private static final DKULogger logger;

    public boolean exists(String projectKey, String analysisId) throws IOException {
        return this.dao.exists(projectKey, analysisId);
    }

    public AnalysisCoreParams getCoreOrNullUnsafe(String projectKey, String analysisId) throws IOException {
        return (AnalysisCoreParams)this.dao.getOrNullUnsafe(projectKey, analysisId);
    }

    public AnalysisCoreParams getCoreMandatory(String projectKey, String analysisId) throws IOException {
        return (AnalysisCoreParams)this.dao.getMandatory(projectKey, analysisId);
    }

    public AnalysisCoreParams getCoreMandatoryUnsafe(String projectKey, String analysisId) throws IOException {
        return (AnalysisCoreParams)this.dao.getMandatoryUnsafe(projectKey, analysisId);
    }

    public AnalysisCoreParams.AnalysisListItem getHeadMandatory(String projectKey, String analysisId, boolean withMLTasks) throws IOException {
        AnalysisCoreParams cp = (AnalysisCoreParams)this.dao.getMandatory(projectKey, analysisId);
        return this.makeHead(cp, withMLTasks);
    }

    public AnalysisCoreParams.AnalysisListItem getHeadMandatoryUnsafe(String projectKey, String analysisId, boolean withMLTasks) throws IOException {
        AnalysisCoreParams cp = (AnalysisCoreParams)this.dao.getMandatoryUnsafe(projectKey, analysisId);
        return this.makeHead(cp, withMLTasks);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    public List<AnalysisCoreParams.AnalysisListItem> listHeadsUnsafe(String projectKey, String restrictToDatasetSM) throws IOException {
        return this.listHeadsUnsafe(projectKey, restrictToDatasetSM, false);
    }

    public List<AnalysisCoreParams.AnalysisListItem> listHeadsUnsafe(String projectKey, String restrictToDatasetSM, boolean withMLTasks) throws IOException {
        ArrayList<AnalysisCoreParams.AnalysisListItem> ret = new ArrayList<AnalysisCoreParams.AnalysisListItem>();
        for (AnalysisCoreParams acp : this.dao.listUnsafe(projectKey)) {
            if (restrictToDatasetSM != null && !acp.inputDatasetSmartName.equals(restrictToDatasetSM)) continue;
            try {
                AnalysisCoreParams.AnalysisListItem head = this.makeHead(acp, withMLTasks);
                ret.add(head);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public List<AnalysisCoreParams> listCoreUnsafe(String projectKey, String restrictToDatasetSM) throws IOException {
        ArrayList<AnalysisCoreParams> ret = new ArrayList<AnalysisCoreParams>();
        for (AnalysisCoreParams acp : this.dao.listUnsafe(projectKey)) {
            if (restrictToDatasetSM != null && !acp.inputDatasetSmartName.equals(restrictToDatasetSM)) continue;
            ret.add(acp);
        }
        return ret;
    }

    public AnalysisCoreParams.AnalysisListItem makeHead(AnalysisCoreParams acp, boolean withMLTasks) throws IOException {
        RelFile mlFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        AnalysisCoreParams.AnalysisListItem head = new AnalysisCoreParams.AnalysisListItem(acp);
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(acp.projectKey, head.inputDatasetSmartName);
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc);
        if (dataset != null) {
            head.inputDatasetType = dataset.type;
        }
        if (t.isDirectory(mlFolder = this.mlFolder(head.projectKey, head.id))) {
            head.nbMLTasks = t.listFiles(mlFolder).size();
        }
        if (withMLTasks) {
            head.mlTasks = this.listMLTasks(head.projectKey, head.id, true);
        }
        return head;
    }

    public AnalysisCoreParams saveCore(AnalysisCoreParams acp, boolean summaryOnly) throws IOException, UnauthorizedException, CodedException {
        Preconditions.checkNotNull((Object)acp, (Object)"Analysis params are empty");
        Preconditions.checkNotNull((Object)acp.id, (Object)"Analysis id is not specified");
        Preconditions.checkNotNull((Object)acp.projectKey, (Object)"Project key is not specified");
        Preconditions.checkNotNull((Object)acp.script, (Object)"Analysis script is empty");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ShakerUtils.checkScriptCodePermission(t.getUser(), acp.script);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.ANALYSIS_EDIT;
        JsonObject details = new JsonObject();
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        AnalysisCoreParams preExisting = (AnalysisCoreParams)this.dao.getOrNullUnsafe(acp.projectKey, acp.id);
        try {
            if (preExisting != null) {
                if (preExisting.name != null && !preExisting.name.equals(acp.name)) {
                    logger.infoV("Analysis rename: %s -> %s", new Object[]{preExisting.name, acp.name});
                    action = TaggableObjectChangedEvent.ActionType.ANALYSIS_RENAME;
                    details.addProperty("oldName", preExisting.name);
                    details.addProperty("newName", acp.name);
                } else {
                    diff = this.colaborativeMetadataDiffService.diff(preExisting, acp, t.getUser().getIdentifier());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get analysis diff", (Throwable)e);
        }
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(acp, preExisting);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.ANALYSIS, acp.projectKey, acp.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(acp.projectKey, acp.tags);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(acp.projectKey, acp.id), acp);
        this.dao.save(acp);
        return acp;
    }

    public void deleteMLTask(String projectKey, String analysisId, String mlTaskId) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(this.mlTaskFolder(projectKey, analysisId, mlTaskId));
    }

    public void delete(String projectKey, String analysisId) throws IOException, SQLException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            AnalysisCoreParams acp = (AnalysisCoreParams)this.dao.getOrNullUnsafe(projectKey, analysisId);
            if (acp != null) {
                details.addProperty("objectDisplayName", acp.name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.ANALYSIS, projectKey, analysisId, t.getUser(), TaggableObjectChangedEvent.ActionType.ANALYSIS_DELETE).withDetails(details));
        t.deleteDirectory(this.baseFolder(projectKey, analysisId));
        this.deleteData(projectKey, analysisId);
    }

    public void deleteData(String projectKey, String analysisId) throws IOException {
        File analysisDataFolder = this.analysisDataFolder(projectKey, analysisId);
        if (analysisDataFolder.isDirectory()) {
            FilesystemACLUtils.removeACLRestrictiveMask(analysisDataFolder);
            DKUFileUtils.deleteDirectory((File)analysisDataFolder);
        }
    }

    public void deleteAllAnalysisForDataset(String projectKey, String restrictToDatasetSM) throws IOException, SQLException {
        List<AnalysisCoreParams.AnalysisListItem> analyses = this.listHeadsUnsafe(projectKey, restrictToDatasetSM);
        for (AnalysisCoreParams.AnalysisListItem head : analyses) {
            this.delete(projectKey, head.id);
        }
    }

    public String create(String projectKey, String datasetSmartName, String name) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AnalysisCoreParams acp = new AnalysisCoreParams();
        acp.id = SecretKeyGenerator.generate((int)8);
        acp.projectKey = projectKey;
        acp.inputDatasetSmartName = datasetSmartName;
        if (StringUtils.isBlank((String)name)) {
            name = "Analyse " + datasetSmartName;
        }
        acp.name = name;
        acp.versionTag = acp.creationTag = new VersionTag(t.getUser().getIdentifier());
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(acp);
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatory(AnyLoc.resolveSmart(projectKey, datasetSmartName));
        for (SchemaColumn col : dataset.getSchema().getColumns()) {
            if (col.getMeaning() == null && StringUtils.isBlank((String)col.comment) && col.customFields == null) continue;
            SerializedShakerScript.AnalysisColumnData acd = new SerializedShakerScript.AnalysisColumnData();
            acd.comment = com.dataiku.dip.utils.StringUtils.nullIfBlank((String)col.comment);
            acd.meaning = com.dataiku.dip.utils.StringUtils.nullIfBlank((String)col.getMeaning());
            if (col.customFields != null) {
                acd.customFields = (JsonObject)JSON.deepCopy((Object)col.customFields);
            }
            acp.script.analysisColumnData.put(col.getName(), acd);
        }
        DatasetExploreSettings exploreSettings = this.exploresService.get(projectKey, datasetSmartName);
        acp.script.explorationSampling = (SerializedShakerScript.ShakerExplorationSampleSettings)JSON.deepCopy((Object)exploreSettings.script.explorationSampling);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, acp);
        this.dao.save(acp);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.ANALYSIS, projectKey, acp.id, t.getUser(), TaggableObjectChangedEvent.ActionType.ANALYSIS_CREATE));
        return acp.id;
    }

    public void saveMLTask(MLTaskLoc loc, MLTask task, boolean fixupRoles) throws IOException, UnauthorizedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (task instanceof PredictionMLTask.ClassicalPredictionMLTask) {
            this.checkClassicalPredictionMLTask(t, (PredictionMLTask.ClassicalPredictionMLTask)task, fixupRoles);
        } else if (task instanceof ClusteringMLTask) {
            this.checkClusteringMLTask(t, (ClusteringMLTask)task);
        } else if (task instanceof PredictionMLTask.DeepHubPredictionMLTask) {
            this.checkDeepHubPredictionMLTask(t, (PredictionMLTask.DeepHubPredictionMLTask)task, fixupRoles);
        } else if (task instanceof PredictionMLTask.CausalPredictionMLTask) {
            this.checkCausalPredictionMLTask(t, (PredictionMLTask.CausalPredictionMLTask)task, fixupRoles);
        } else if (task instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
            this.checkTimeseriesForecastingMLTask(t, (PredictionMLTask.TimeseriesForecastingMLTask)task, fixupRoles);
        } else {
            throw new IllegalArgumentException("Unsupported ML Task: " + task.getClass().getSimpleName());
        }
        t.writeObject(this.mlTaskParamsFile(loc), (Object)task);
        TaggableObjectChangedEvent evt = new TaggableObjectChangedEvent(ITaggingService.TaggableType.ANALYSIS, loc.analysisProjectKey, loc.analysisId, t.getUser(), TaggableObjectChangedEvent.ActionType.ANALYSIS_EDIT);
        this.pubSub.publishAfterTransaction(evt);
    }

    private void checkDeepHubPredictionMLTask(RWTransactionRef t, PredictionMLTask.DeepHubPredictionMLTask task, boolean fixupRoles) {
        assert (task.backendType == MLTask.BackendType.DEEP_HUB);
    }

    private void checkAllowedCustomCodeTabularPredictionMLTask(RWTransactionRef t, PredictionMLTask.TabularPredictionMLTask mlTask) throws UnauthorizedException {
        if (t.getUser().isUnsafeCodeAllowed()) {
            return;
        }
        if (mlTask.getPreprocessingParams() != null && mlTask.getPreprocessingParams().per_feature != null) {
            for (Map.Entry feat : mlTask.getPreprocessingParams().per_feature.entrySet()) {
                if (!((FeaturePreprocessingParams)feat.getValue()).usesCustomHandling()) continue;
                t.getUser().failIfNoSafeCode("use a custom Python preprocessing for feature: " + (String)feat.getKey());
            }
        }
        if (mlTask.backendType == MLTask.BackendType.KERAS) {
            t.getUser().failIfNoSafeCode("use a custom Keras architecture");
        }
        if (mlTask.modeling != null && mlTask.modeling.custom_python != null) {
            for (PredictionModelingParams.CustomPythonParams cp : mlTask.modeling.custom_python) {
                if (cp == null || !cp.enabled) continue;
                t.getUser().failIfNoSafeCode("use a custom Python model");
            }
        }
        if (mlTask.modeling != null && mlTask.modeling.gridSearchParams != null && mlTask.modeling.gridSearchParams.mode == PredictionModelingParams.GridSearchCrossValidationMode.CUSTOM) {
            t.getUser().failIfNoSafeCode("use a custom cross-validation function");
        }
        if (mlTask.modeling != null && mlTask.modeling.metrics != null) {
            if (mlTask.modeling.metrics.evaluationMetric == MetricParams.EvaluationMetric.CUSTOM) {
                t.getUser().failIfNoSafeCode("use a custom Python scoring function");
            }
            if (mlTask.modeling.metrics.getCustomMetrics().size() > 0) {
                t.getUser().failIfNoSafeCode("use a custom Python evaluation function");
            }
        }
    }

    private void checkCausalPredictionMLTask(RWTransactionRef t, PredictionMLTask.CausalPredictionMLTask mlTask, boolean fixupRoles) throws UnauthorizedException, CodedIOException {
        assert (mlTask.backendType == MLTask.BackendType.PY_MEMORY);
        this.checkAllowedCustomCodeTabularPredictionMLTask(t, mlTask);
        if (mlTask.getPreprocessingParams() == null) {
            return;
        }
        for (Map.Entry e : mlTask.getPreprocessingParams().per_feature.entrySet()) {
            String featureName = (String)e.getKey();
            FeaturePreprocessingParams featurePreprocessingParams = (FeaturePreprocessingParams)e.getValue();
            if (featureName.equals(mlTask.targetVariable)) {
                if (featurePreprocessingParams.role == FeaturePreprocessingParams.Role.TARGET) continue;
                if (fixupRoles) {
                    featurePreprocessingParams.role = FeaturePreprocessingParams.Role.TARGET;
                    continue;
                }
                throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: outcome column must have role TARGET");
            }
            if (!featureName.equals(mlTask.treatmentVariable) || featurePreprocessingParams.role == FeaturePreprocessingParams.Role.TREATMENT) continue;
            if (fixupRoles) {
                featurePreprocessingParams.role = FeaturePreprocessingParams.Role.TREATMENT;
                continue;
            }
            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: treatment variable column must have role TREATMENT");
        }
    }

    private void checkTimeseriesForecastingMLTask(RWTransactionRef t, PredictionMLTask.TimeseriesForecastingMLTask mlTask, boolean fixupRoles) throws UnauthorizedException, CodedIOException {
        this.checkAllowedCustomCodeTabularPredictionMLTask(t, mlTask);
        if (mlTask.getPreprocessingParams() == null) {
            return;
        }
        for (Map.Entry e : mlTask.getPreprocessingParams().per_feature.entrySet()) {
            String featureName = (String)e.getKey();
            FeaturePreprocessingParams featurePreprocessingParams = (FeaturePreprocessingParams)e.getValue();
            if (mlTask.timeseriesIdentifiers.contains(featureName)) {
                if (featurePreprocessingParams.role == FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER) continue;
                if (fixupRoles) {
                    featurePreprocessingParams.role = FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER;
                    featurePreprocessingParams.type = FeaturePreprocessingParams.FeatureType.TEXT;
                    continue;
                }
                throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: time-series identifier column must have role TIMESERIES_IDENTIFIER");
            }
            if (featureName.equals(mlTask.targetVariable)) {
                if (featurePreprocessingParams.role == FeaturePreprocessingParams.Role.TARGET) continue;
                if (fixupRoles) {
                    featurePreprocessingParams.role = FeaturePreprocessingParams.Role.TARGET;
                    continue;
                }
                throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: target column must have role TARGET");
            }
            if (featureName.equals(mlTask.timeVariable)) {
                if (featurePreprocessingParams.role == FeaturePreprocessingParams.Role.TIME) continue;
                if (fixupRoles) {
                    featurePreprocessingParams.role = FeaturePreprocessingParams.Role.TIME;
                    continue;
                }
                throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: time variable column must have role TIME");
            }
            if (!Arrays.asList(FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER, FeaturePreprocessingParams.Role.TARGET, FeaturePreprocessingParams.Role.TIME).contains((Object)featurePreprocessingParams.role)) continue;
            if (fixupRoles) {
                featurePreprocessingParams.role = FeaturePreprocessingParams.Role.INPUT;
                continue;
            }
            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: column '" + featureName + "' has role " + String.valueOf((Object)featurePreprocessingParams.role) + " but is not in timeseries identifiers, target, or time variable");
        }
        HashSet<Double> uniqueQuantiles = new HashSet<Double>(mlTask.quantilesToForecast);
        if (mlTask.quantilesToForecast.size() != uniqueQuantiles.size()) {
            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Duplicate quantiles were specified");
        }
        for (Double quantile : mlTask.quantilesToForecast) {
            if (Math.abs(quantile - Math.floor(quantile * 10000.0) / 10000.0) > 1.0E-8) {
                throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Can only specify quantiles with up to 4 decimals. Got value: " + quantile);
            }
            if (!(quantile < 1.0E-4) && !(quantile > 0.9999)) continue;
            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Quantile values must be between 0.0001 and 0.9999. Got value: " + quantile);
        }
        if (!mlTask.quantilesToForecast.contains(0.5)) {
            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Quantile 0.5 must be one of the quantiles to forecast");
        }
    }

    private void checkClassicalPredictionMLTask(RWTransactionRef t, PredictionMLTask.ClassicalPredictionMLTask pmlTask, boolean fixupRoles) throws UnauthorizedException, CodedIOException {
        this.checkAllowedCustomCodeTabularPredictionMLTask(t, pmlTask);
        if (pmlTask.backendType.isSparkBased() && !this.licenseEnforcementService.getFeaturesStatus().sparkMLLibAllowed) {
            throw new SecurityException("Spark MLLib is not allowed by your license");
        }
        if (pmlTask.splitParams != null && pmlTask.splitParams.kfold && pmlTask.splitParams.ttPolicy != SplitParams.TrainTestPolicy.SPLIT_SINGLE_DATASET) {
            pmlTask.splitParams.kfold = false;
        }
        if (pmlTask.weight.weightMethod == WeightParams.WeightMethod.SAMPLE_WEIGHT && StringUtils.isNotBlank((String)pmlTask.weight.sampleWeightVariable)) {
            for (Map.Entry e : pmlTask.preprocessing.per_feature.entrySet()) {
                if (((String)e.getKey()).equals(pmlTask.weight.sampleWeightVariable)) {
                    if (((FeaturePreprocessingParams)e.getValue()).role == FeaturePreprocessingParams.Role.WEIGHT) continue;
                    if (fixupRoles) {
                        ((FeaturePreprocessingParams)e.getValue()).role = FeaturePreprocessingParams.Role.WEIGHT;
                        ((FeaturePreprocessingParams)e.getValue()).type = FeaturePreprocessingParams.FeatureType.NUMERIC;
                        continue;
                    }
                    throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: weight column must have role WEIGHT");
                }
                if (((String)e.getKey()).equals(pmlTask.targetVariable)) {
                    if (((FeaturePreprocessingParams)e.getValue()).role == FeaturePreprocessingParams.Role.TARGET) continue;
                    if (fixupRoles) {
                        ((FeaturePreprocessingParams)e.getValue()).role = FeaturePreprocessingParams.Role.TARGET;
                        continue;
                    }
                    throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: target column must have role TARGET");
                }
                if (((FeaturePreprocessingParams)e.getValue()).role != FeaturePreprocessingParams.Role.WEIGHT && ((FeaturePreprocessingParams)e.getValue()).role != FeaturePreprocessingParams.Role.TARGET) continue;
                if (fixupRoles) {
                    ((FeaturePreprocessingParams)e.getValue()).role = FeaturePreprocessingParams.Role.INPUT;
                    continue;
                }
                throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_STEP_CONFIG, "Inconsistent setup per-feature: column '" + (String)e.getKey() + "' has role " + String.valueOf((Object)((FeaturePreprocessingParams)e.getValue()).role) + " but is not in sample weight, target, or time variable");
            }
        }
    }

    private void checkClusteringMLTask(RWTransactionRef t, ClusteringMLTask cmlTask) throws UnauthorizedException {
        if (t.getUser().isUnsafeCodeAllowed()) {
            return;
        }
        if (cmlTask.modeling != null && cmlTask.modeling.metrics != null && cmlTask.modeling.metrics.evaluationMetric == ClusteringModelingParams.EvaluationMetric.CUSTOM) {
            t.getUser().failIfNoSafeCode("use a custom Python scoring function");
        }
        if (cmlTask.modeling != null && cmlTask.modeling.custom_python != null) {
            for (ClusteringModelingParams.ClusteringCustomPythonParams clusteringCustomPythonParams : cmlTask.modeling.custom_python) {
                if (clusteringCustomPythonParams == null || !clusteringCustomPythonParams.enabled) continue;
                t.getUser().failIfNoSafeCode("use a custom Python model");
            }
        }
        if (cmlTask.preprocessing != null && cmlTask.preprocessing.per_feature != null) {
            for (Map.Entry entry : cmlTask.preprocessing.per_feature.entrySet()) {
                String featureName = (String)entry.getKey();
                FeaturePreprocessingParams param = (FeaturePreprocessingParams)entry.getValue();
                if (param.role != FeaturePreprocessingParams.Role.INPUT && param.role != FeaturePreprocessingParams.Role.PROFILING) continue;
                boolean hasCustomCode = !StringUtils.isBlank((String)param.customHandlingCode);
                boolean useCustomHandling = false;
                if (!hasCustomCode) continue;
                if (param instanceof NumFeaturePreprocessingParams) {
                    boolean bl = useCustomHandling = ((NumFeaturePreprocessingParams)param).numerical_handling == NumFeaturePreprocessingParams.NumericalHandlingMethod.CUSTOM;
                }
                if (param instanceof CatFeaturePreprocessingParams) {
                    boolean bl = useCustomHandling = ((CatFeaturePreprocessingParams)param).category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.CUSTOM;
                }
                if (param instanceof TextFeaturePreprocessingParams) {
                    boolean bl = useCustomHandling = ((TextFeaturePreprocessingParams)param).text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.CUSTOM;
                }
                if (!useCustomHandling) continue;
                t.getUser().failIfNoSafeCode("use a custom Python preprocessing for feature: " + featureName);
            }
        }
    }

    public void prepareMLTaskCreation(MLTaskLoc loc, MLTask mlTask, AuthCtx authCtx) throws CodedException, IOException {
        AnalysisCoreParams analysis = (AnalysisCoreParams)this.dao.getMandatory(loc.analysisProjectKey, loc.analysisId);
        SerializedDataset sd = this.datasetAccessService.getMandatory(AnyLoc.resolveSmart(analysis.projectKey, analysis.inputDatasetSmartName)).serialize();
        this.customPolicyHooksRegistry.onPreMLModelCreation(authCtx, sd, analysis, mlTask);
    }

    public PredictionMLTask getPMLSessionTask(MLTaskLoc loc, String sessionId, boolean forceInstanceIdRefresher) throws IOException {
        File sessionFolder = loc.getSessionFolder(sessionId);
        PredictionMLTask sessionMlTask = (PredictionMLTask)JSON.parseFile((File)new File(sessionFolder, "mltask.json"), MLTask.class);
        if (forceInstanceIdRefresher) {
            PredictionMLTask task = this.getPMLTaskUnsafe(loc);
            sessionMlTask.splitParams.instanceIdRefresher = task.splitParams.instanceIdRefresher;
        }
        return sessionMlTask;
    }

    public SerializedShakerScript revertScriptToMLSession_T(String projectKey, String analysisId, String mlTaskId, String sessionId, RWTransaction t) throws IOException {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        File sessionFolder = loc.getSessionFolder(sessionId);
        SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)new File(sessionFolder, "script.json"), SerializedShakerScript.class);
        AnalysisCoreParams coreParams = (AnalysisCoreParams)this.dao.getOrNull(projectKey, analysisId);
        coreParams.script = script;
        this.dao.save(coreParams);
        t.commit("Reverted script of analysis " + projectKey + "." + analysisId + " to version corresponding to ML session " + sessionId);
        return script;
    }

    public ActualModelParameters getPMLActualSessionParams(MLTaskLoc loc, String sessionId, String preProcessingId, String modelId) throws IOException {
        File sessionFolder = loc.getSessionFolder(sessionId);
        return (ActualModelParameters)JSON.parseFile((File)DKUFileUtils.getWithin((File)sessionFolder, (String[])new String[]{"/" + preProcessingId + "/" + modelId + "/actual_params.json"}), ActualModelParameters.class);
    }

    public ClusteringMLTask getCMLSessionTask(MLTaskLoc loc, String sessionId, boolean forceInstanceIdRefresher) throws IOException {
        File sessionFolder = loc.getSessionFolder(sessionId);
        ClusteringMLTask sessionMlTask = (ClusteringMLTask)JSON.parseFile((File)new File(sessionFolder, "mltask.json"), ClusteringMLTask.class);
        if (forceInstanceIdRefresher) {
            ClusteringMLTask task = this.getCMLTaskUnsafe(loc);
            sessionMlTask.sampling.instanceIdRefresher = task.sampling.instanceIdRefresher;
        }
        return sessionMlTask;
    }

    public PredictionMLTask getPMLTaskUnsafe(MLTaskLoc loc) throws IOException {
        RelFile file = this.getMLTaskParamsFile(loc, "Prediction ML task");
        TransactionRef t = TransactionContext.retrieveRead();
        PredictionMLTask task = (PredictionMLTask)t.readObjectUnsafe(file, MLTask.class);
        AnalysisCRUDService.checkMLTaskType(task, MLTask.MLTaskType.PREDICTION);
        return task;
    }

    public PredictionMLTask getPMLTask(MLTaskLoc loc) throws IOException {
        RelFile file = this.getMLTaskParamsFile(loc, "Prediction ML task");
        TransactionRef t = TransactionContext.retrieveRead();
        PredictionMLTask task = (PredictionMLTask)t.readObject(file, MLTask.class);
        AnalysisCRUDService.checkMLTaskType(task, MLTask.MLTaskType.PREDICTION);
        return task;
    }

    public ClusteringMLTask getCMLTaskUnsafe(MLTaskLoc loc) throws IOException {
        RelFile file = this.getMLTaskParamsFile(loc, "Clustering ML task");
        TransactionRef t = TransactionContext.retrieveRead();
        ClusteringMLTask task = (ClusteringMLTask)t.readObjectUnsafe(file, ClusteringMLTask.class);
        AnalysisCRUDService.checkMLTaskType(task, MLTask.MLTaskType.CLUSTERING);
        return task;
    }

    public ClusteringMLTask getCMLTask(MLTaskLoc loc) throws IOException {
        RelFile file = this.getMLTaskParamsFile(loc, "Clustering ML task");
        TransactionRef t = TransactionContext.retrieveRead();
        ClusteringMLTask task = (ClusteringMLTask)t.readObject(file, ClusteringMLTask.class);
        AnalysisCRUDService.checkMLTaskType(task, MLTask.MLTaskType.CLUSTERING);
        return task;
    }

    public MLTask getMLTask(MLTaskLoc loc) throws IOException {
        RelFile file = this.getMLTaskParamsFile(loc, "ML task");
        TransactionRef t = TransactionContext.retrieveRead();
        return (MLTask)t.readObject(file, MLTask.class);
    }

    public List<MLTaskHead> listMLTasks(String projectKey, String analysisId, boolean withModelCount) throws IOException {
        RelFile mlFolder;
        ArrayList<MLTaskHead> ret = new ArrayList<MLTaskHead>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(mlFolder = this.mlFolder(projectKey, analysisId))) {
            return ret;
        }
        for (RelFile rf : t.listFiles(mlFolder)) {
            try {
                RelFile prf = new RelFile(rf, new String[]{"params.json"});
                if (!t.isDirectory(rf) || !t.isFile(prf)) continue;
                MLTask task = (MLTask)t.readObjectUnsafe(prf, MLTask.class);
                MLTaskHead head = new MLTaskHead();
                head.mlTaskId = rf.getLeafName();
                head.name = task.name;
                head.taskType = task.taskType;
                head.backendType = task.backendType;
                if (task.taskType == MLTask.MLTaskType.PREDICTION) {
                    head.predictionType = ((PredictionMLTask)task).predictionType;
                }
                head.lastModifiedOn = t.getLastModified(prf);
                if (withModelCount) {
                    List<FullModelId> modelIds = ((MLBaseService)SpringUtils.getBean(MLBaseService.class)).listCompletedModelIds(new MLTaskLoc(projectKey, analysisId, head.mlTaskId));
                    HashSet<String> sessionsIds = new HashSet<String>();
                    HashSet<CallSite> baseModelIds = new HashSet<CallSite>();
                    for (FullModelId modelId : modelIds) {
                        sessionsIds.add(modelId.getSessionId());
                        baseModelIds.add((CallSite)((Object)(modelId.getSessionId() + WorkSetPreparator.extractPrefixAndId(modelId.getPreprocessingId()))));
                    }
                    head.modelCount = baseModelIds.size();
                    head.sessionCount = sessionsIds.size();
                }
                ret.add(head);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to parse ML task " + rf.getFullPath()), (Throwable)e);
            }
        }
        return ret;
    }

    public List<MLTask> listRawMLTasks(String projectKey, String analysisId) throws IOException {
        RelFile mlFolder;
        ArrayList<MLTask> ret = new ArrayList<MLTask>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(mlFolder = this.mlFolder(projectKey, analysisId))) {
            return ret;
        }
        for (RelFile rf : t.listFiles(mlFolder)) {
            try {
                MLTask task;
                RelFile prf = new RelFile(rf, new String[]{"params.json"});
                if (!t.isDirectory(rf) || !t.isFile(prf) || (task = (MLTask)t.readObjectUnsafe(prf, MLTask.class)) == null) continue;
                ret.add(task);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to parse ML task " + rf.getFullPath()), (Throwable)e);
            }
        }
        return ret;
    }

    public List<FullModelId> listMLTaskModels(String projectKey, String analysisId, String taskId) {
        return ((MLBaseService)SpringUtils.getBean(MLBaseService.class)).listCompletedModelIds(new MLTaskLoc(projectKey, analysisId, taskId));
    }

    public List<FullModelId> listAnalysisCompletedFMI(String projectKey, String analysisId) throws IOException {
        ArrayList<FullModelId> ret = new ArrayList<FullModelId>();
        for (MLTask curMLTask : this.listRawMLTasks(projectKey, analysisId)) {
            ret.addAll(this.listMLTaskModels(projectKey, analysisId, curMLTask.id));
        }
        return ret;
    }

    public Id duplicate(String projectKey, String analysisId) throws Exception {
        File srcDataFolder;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AnalysisCoreParams oldA = (AnalysisCoreParams)this.dao.getMandatoryUnsafe(projectKey, analysisId);
        AnalysisCoreParams acp = (AnalysisCoreParams)JSON.deepCopy((Object)oldA);
        acp.projectKey = projectKey;
        acp.id = SecretKeyGenerator.generate((int)8);
        acp.name = "Copy of " + oldA.name;
        acp.versionTag = acp.creationTag = VersionTag.increment(null, t.getUser().getIdentifier());
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, acp);
        this.dao.save(acp);
        RelFile oldMlFolder = this.mlFolder(oldA.projectKey, oldA.id);
        RelFile newMlFolder = this.mlFolder(acp.projectKey, acp.id);
        if (t.isDirectory(oldMlFolder)) {
            for (RelFile rf : t.listFiles(oldMlFolder)) {
                RelFile newParamsFile = new RelFile(newMlFolder, new String[]{rf.getLeafName(), "params.json"});
                t.copyFile(new RelFile(rf, new String[]{"params.json"}), newParamsFile);
            }
        }
        if ((srcDataFolder = this.analysisDataFolder(projectKey, analysisId)).isDirectory()) {
            File tgtDataFolder = this.analysisDataFolder(acp.projectKey, acp.id);
            DKUFileUtils.copyDirectory((File)srcDataFolder, (File)tgtDataFolder);
            MLPaths.restrictPermissionsAnalysisFolder(tgtDataFolder);
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.ANALYSIS, projectKey, acp.id, t.getUser(), TaggableObjectChangedEvent.ActionType.ANALYSIS_CREATE));
        return new Id(acp.id);
    }

    private RelFile baseFolder(String projectKey, String analysisId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)analysisId), (Object)"Analysis id is not specified");
        return new RelFile(new String[]{"projects", projectKey, "analysis", analysisId});
    }

    private RelFile mlFolder(String projectKey, String analysisId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)analysisId), (Object)"Analysis id is not specified");
        return new RelFile(new String[]{"projects", projectKey, "analysis", analysisId, "ml"});
    }

    private RelFile mlTaskFolder(String projectKey, String analysisId, String mlTaskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)analysisId), (Object)"Analysis id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)mlTaskId), (Object)"ML task id is not specified");
        return new RelFile(new String[]{"projects", projectKey, "analysis", analysisId, "ml", mlTaskId});
    }

    private RelFile mlTaskParamsFile(MLTaskLoc loc) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)loc.analysisProjectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)loc.analysisId), (Object)"Analysis id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)loc.mlTaskId), (Object)"ML task id is not specified");
        return new RelFile(new String[]{"projects", loc.analysisProjectKey, "analysis", loc.analysisId, "ml", loc.mlTaskId, "params.json"});
    }

    private File analysisDataFolder(String projectKey, String analysisId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)analysisId), (Object)"Analysis id is not specified");
        return ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", projectKey, analysisId});
    }

    private RelFile getMLTaskParamsFile(MLTaskLoc loc, String description) throws IOException {
        RelFile file;
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.exists(file = this.mlTaskParamsFile(loc))) {
            return file;
        }
        throw new NotFoundException(String.format("%s not found: %s", description, loc.mlTaskId));
    }

    private static void checkMLTaskType(MLTask task, MLTask.MLTaskType taskType) {
        if (task.taskType != taskType) {
            throw new IllegalArgumentException(String.format("Wrong ML task type: expected=%s, actual=%s", new Object[]{taskType, task.taskType}));
        }
    }

    static {
        DKUMLUtils.loadClasses();
        logger = DKULogger.getLogger((String)"dku.analysis");
    }

    public static class MLTaskHead {
        public String mlTaskId;
        public MLTask.MLTaskType taskType;
        public String name;
        public int modelCount;
        public int sessionCount;
        public PredictionMLTask.PredictionType predictionType;
        public long lastModifiedOn;
        public MLTask.BackendType backendType;
    }
}

