/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ResultsMLOverridesBaseTableExtractor
implements ModelExtractor<List<List<String>>> {
    public static final String NO_OVERRIDES_DEFINED = "No overrides defined in the settings";

    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        ResolvedCoreParams coreParams = model.getCoreParams();
        if (coreParams == null || coreParams.taskType != MLTask.MLTaskType.PREDICTION) {
            throw new IOException("ML overrides are only defined for prediction tasks");
        }
        ResolvedPredictionCoreParams predictionCoreParams = (ResolvedPredictionCoreParams)coreParams;
        if (predictionCoreParams.prediction_type == null || !predictionCoreParams.prediction_type.supportsMLOverrides()) {
            throw new IOException("This prediction type does not support overrides");
        }
        ClassicalPredictionModelDetails modelDetails = (ClassicalPredictionModelDetails)model;
        if (modelDetails.overridesParams == null || !modelDetails.overridesParams.hasOverrides()) {
            return this.buildEmptyTable();
        }
        return this.buildTableForNonEmptyOverrides(modelDetails);
    }

    private List<List<String>> buildEmptyTable() {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(new ArrayList<String>(Collections.singletonList("ML Overrides")));
        table.add(new ArrayList<String>(Collections.singletonList(NO_OVERRIDES_DEFINED)));
        return table;
    }

    protected abstract List<List<String>> buildTableForNonEmptyOverrides(ClassicalPredictionModelDetails var1);
}

