/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.WeightParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class TestMetricNameExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (model instanceof ClassicalPredictionModelDetails) {
            ClassicalPredictionModelDetails predictionModel = (ClassicalPredictionModelDetails)model;
            return (TestMetricNameExtractor.areMetricsWeighted(predictionModel) ? "Weighted " : "") + TestMetricNameExtractor.formatMetricName(predictionModel.modeling.metrics);
        }
        if (model instanceof TimeseriesForecastingModelDetails) {
            return TestMetricNameExtractor.formatMetricName(((TimeseriesForecastingModelDetails)model).modeling.metrics);
        }
        if (model instanceof ClusteringModelDetails) {
            return TestMetricNameExtractor.formatMetricName(((ClusteringModelDetails)model).modeling.metrics);
        }
        throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
    }

    private static boolean areMetricsWeighted(ClassicalPredictionModelDetails model) {
        if (model.coreParams == null || model.coreParams.weight == null) {
            return false;
        }
        return model.coreParams.weight.weightMethod == WeightParams.WeightMethod.SAMPLE_WEIGHT || model.coreParams.weight.weightMethod == WeightParams.WeightMethod.CLASS_AND_SAMPLE_WEIGHT;
    }

    private static String formatMetricName(ClusteringModelingParams.MetricParams metrics) {
        switch (metrics.evaluationMetric) {
            case SILHOUETTE: {
                return "Silhouette";
            }
            case INERTIA: {
                return "Inertia";
            }
            case NB_CLUSTERS: {
                return "Clusters";
            }
            case CUSTOM: {
                return "Custom score";
            }
        }
        return metrics.evaluationMetric != null ? metrics.evaluationMetric.name() : "null";
    }

    private static String formatMetricName(MetricParams metrics) {
        if (metrics.evaluationMetric == null) {
            return "null";
        }
        switch (metrics.evaluationMetric) {
            case PRECISION: {
                return "Precision";
            }
            case RECALL: {
                return "Recall";
            }
            case F1: {
                return "F1 Score";
            }
            case ACCURACY: {
                return "Accuracy";
            }
            case EVS: {
                return "EVS";
            }
            case MAPE: {
                return "MAPE";
            }
            case MAE: {
                return "MAE";
            }
            case MSE: {
                return "MSE";
            }
            case RMSE: {
                return "RMSE";
            }
            case RMSLE: {
                return "RMSLE";
            }
            case R2: {
                return "R2 Score";
            }
            case COST_MATRIX: {
                return "Cost Matrix Gain";
            }
            case LOG_LOSS: {
                return "Log Loss";
            }
            case ROC_AUC: {
                return "ROC AUC";
            }
            case MASE: {
                return "MASE";
            }
            case MEAN_ABSOLUTE_QUANTILE_LOSS: {
                return "Mean absolute quantile loss";
            }
            case MEAN_WEIGHTED_QUANTILE_LOSS: {
                return "Mean weighted quantile loss";
            }
            case MSIS: {
                return "MSIS";
            }
            case ND: {
                return "ND";
            }
            case SMAPE: {
                return "SMAPE";
            }
            case CUSTOM: {
                return "Custom score";
            }
            case CUMULATIVE_LIFT: {
                return TestMetricNameExtractor.isNumeric(metrics.liftPoint) ? "Lift at " + Math.round(metrics.liftPoint * 100.0) + "%" : "Lift";
            }
        }
        return metrics.evaluationMetric.name();
    }

    private static boolean isNumeric(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }
}

