/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.transform;

import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.docgen.transform.PuppeteerConfig;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.graphicsexport.charts.execution.DomElementEnrichedExport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PuppeteerConfigResolver {
    private PuppeteerConfigResolver() {
    }

    public static PuppeteerConfig resolve(Placeholder placeholder, MLTask mltask, ModelDetailsBase model) {
        switch (placeholder) {
            case RESULT_CONFUSION_MATRIX_IMAGE: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.INVALID, PuppeteerConfig.BC_CONFUSION_MATRIX, PuppeteerConfig.MC_CONFUSION_MATRIX, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_DETAILED_METRICS_IMAGE: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.R_DETAILED_METRICS_IMAGE, PuppeteerConfig.C_DETAILED_METRICS_IMAGE, PuppeteerConfig.C_DETAILED_METRICS_IMAGE, PuppeteerConfig.DETAILED_METRICS_IMAGE, PuppeteerConfig.INVALID);
            }
            case RESULT_DETAILED_METRICS_TABLE: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.R_DETAILED_METRICS_TABLE, PuppeteerConfig.BINARY_C_DETAILED_METRICS_TABLE, PuppeteerConfig.MULTICLASS_C_DETAILED_METRICS_TABLE, PuppeteerConfig.CLUSTERING_DETAILED_METRICS_TABLE, PuppeteerConfig.TIMESERIES_DETAILED_METRICS_TABLE);
            }
            case RESULT_ROC_CURVE_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.INVALID, PuppeteerConfig.ROC_CURVE, PuppeteerConfig.ROC_CURVE_MULTICLASS, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_FEATURE_EFFECTS_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.FEATURE_EFFECTS, PuppeteerConfig.FEATURE_EFFECTS, PuppeteerConfig.FEATURE_EFFECTS_MULTICLASS, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_FEATURE_DEPENDENCE_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.FEATURE_DEPENDENCE, PuppeteerConfig.FEATURE_DEPENDENCE, PuppeteerConfig.FEATURE_DEPENDENCE_MULTICLASS, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_PR_CURVE_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.INVALID, PuppeteerConfig.PR_CURVE, PuppeteerConfig.PR_CURVE_MULTICLASS, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_DENSITY_CHART_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.INVALID, PuppeteerConfig.DENSITY_GRAPH, PuppeteerConfig.DENSITY_GRAPH_MULTICLASS, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_CALIBRATION_CHART_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.INVALID, PuppeteerConfig.CALIBRATION_CHART, PuppeteerConfig.CALIBRATION_CHART_MULTICLASS, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID);
            }
            case RESULT_INDIVIDUAL_EXPLANATIONS_IMAGE: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.INDIVIDUAL_EXPLANATIONS_IMAGE, PuppeteerConfig.INDIVIDUAL_EXPLANATIONS_IMAGE, PuppeteerConfig.INDIVIDUAL_EXPLANATIONS_IMAGE_MULTICLASS, PuppeteerConfig.INDIVIDUAL_EXPLANATIONS_IMAGE, PuppeteerConfig.INVALID);
            }
            case RESULT_CHOSEN_ALGORITHM_DETAILS_IMAGE: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_IMAGE, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_IMAGE, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_IMAGE, PuppeteerConfig.C_CHOSEN_ALGORITHM_DETAILS_IMAGE, PuppeteerConfig.INVALID);
            }
            case RESULT_CHOSEN_ALGORITHM_DETAILS_TABLE: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_TABLE, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_TABLE, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_TABLE, PuppeteerConfig.C_CHOSEN_ALGORITHM_DETAILS_TABLE, PuppeteerConfig.CHOSEN_ALGORITHM_DETAILS_TABLE);
            }
            case RESULT_SCATTER_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.R_SCATTER_CHART, PuppeteerConfig.INVALID, PuppeteerConfig.INVALID, PuppeteerConfig.C_SCATTER_CHART, PuppeteerConfig.INVALID);
            }
            case RESULT_DECISION_TREE_IMAGE: {
                return PuppeteerConfigResolver.resolveDecisionTreePlot(mltask, model);
            }
            case RESULT_FEATURE_IMPORTANCE_PLOT: {
                return PuppeteerConfigResolver.resolveFromModelType(mltask, PuppeteerConfig.PREDICTION_VARIABLE_IMPORTANCE, PuppeteerConfig.PREDICTION_VARIABLE_IMPORTANCE, PuppeteerConfig.PREDICTION_VARIABLE_IMPORTANCE, PuppeteerConfig.CLUSTERING_VARIABLE_IMPORTANCE, PuppeteerConfig.INVALID);
            }
        }
        return PuppeteerConfig.INVALID;
    }

    public static List<DomElementEnrichedExport.Target.Step> getStepList(PuppeteerConfig puppeteerConfig, ModelDetailsBase model, String parameterValue) throws IOException {
        List<DomElementEnrichedExport.Target.Step> steps = puppeteerConfig.getStepList();
        switch (puppeteerConfig) {
            case DESIGN_CHOSEN_ALGORITHM_SEARCH_STRATEGY_TEXT: 
            case DESIGN_CHOSEN_ALGORITHM_SEARCH_STRATEGY_IMAGE: 
            case DESIGN_CHOSEN_ALGORITHM_SEARCH_STRATEGY_TABLE: 
            case DESIGN_OTHER_ALGORITHMS_SEARCH_STRATEGY_IMAGE: 
            case DESIGN_OTHER_ALGORITHMS_SEARCH_STRATEGY_TABLE: {
                return PuppeteerConfigResolver.resolveAlgorithmName(steps, model);
            }
            case LEADERBOARD: 
            case LEADERBOARD_ACCURACY: 
            case LEADERBOARD_PRECISION: 
            case LEADERBOARD_RECALL: 
            case LEADERBOARD_F1: 
            case LEADERBOARD_COST_MATRIX: 
            case LEADERBOARD_LOG_LOSS: 
            case LEADERBOARD_ROC_AUC: 
            case LEADERBOARD_AVERAGE_PRECISION: 
            case LEADERBOARD_CALIBRATION_LOSS: 
            case LEADERBOARD_CUMULATIVE_LIFT: 
            case LEADERBOARD_EVS: 
            case LEADERBOARD_MAPE: 
            case LEADERBOARD_MAE: 
            case LEADERBOARD_MSE: 
            case LEADERBOARD_RMSE: 
            case LEADERBOARD_RMSLE: 
            case LEADERBOARD_R2: 
            case LEADERBOARD_MASE: 
            case LEADERBOARD_SMAPE: 
            case LEADERBOARD_MEAN_ABSOLUTE_QUANTILE_LOSS: 
            case LEADERBOARD_MEAN_WEIGHTED_QUANTILE_LOSS: 
            case LEADERBOARD_MSIS: 
            case LEADERBOARD_ND: 
            case LEADERBOARD_CORRELATION: 
            case LEADERBOARD_SILHOUETTE: 
            case LEADERBOARD_INERTIA: 
            case LEADERBOARD_CLUSTERS: {
                return PuppeteerConfigResolver.resolveSessionId(steps, model);
            }
            case TIMESERIES_FORECAST_CHART_MULTI: {
                return PuppeteerConfigResolver.resolveTimeseriesForecastChartMulti(steps, model);
            }
            case FEATURE_DEPENDENCE: 
            case FEATURE_DEPENDENCE_MULTICLASS: {
                return PuppeteerConfigResolver.resolveStepParameterValue(steps, parameterValue);
            }
        }
        return steps;
    }

    private static List<DomElementEnrichedExport.Target.Step> resolveAlgorithmName(List<DomElementEnrichedExport.Target.Step> stepList, ModelDetailsBase model) {
        List<DomElementEnrichedExport.Target.Step> steps = PuppeteerConfigResolver.deepCopySteps(stepList);
        String algorithmName = PuppeteerConfigResolver.convertBackAlgNameToFrontAlgName(model);
        Object puppeteerHook = "[puppeteer-hook=\"";
        if ("Custom Python model".equalsIgnoreCase(algorithmName)) {
            String customModelName = algorithmName;
            if (model instanceof ClusteringModelDetails) {
                customModelName = ((ClusteringModelDetails)model).modeling.custom_model_name;
            } else if (model instanceof TabularPredictionModelDetails) {
                customModelName = ((TabularPredictionModelDetails)model).modeling.custom_python.name;
            }
            puppeteerHook = (String)puppeteerHook + customModelName;
        } else {
            puppeteerHook = (String)puppeteerHook + algorithmName;
        }
        puppeteerHook = (String)puppeteerHook + "\"]";
        DomElementEnrichedExport.Target.Step clickStep = steps.get(0);
        clickStep.cssSelector = clickStep.cssSelector.replace("[#@#]", (CharSequence)puppeteerHook);
        return steps;
    }

    private static List<DomElementEnrichedExport.Target.Step> resolveSessionId(List<DomElementEnrichedExport.Target.Step> stepList, ModelDetailsBase model) {
        List<DomElementEnrichedExport.Target.Step> steps = PuppeteerConfigResolver.deepCopySteps(stepList);
        String puppeteerHook = "[puppeteer-hook=\"" + model.sessionId + "\"]";
        DomElementEnrichedExport.Target.Step step = steps.get(steps.size() - 1);
        step.cssSelector = step.cssSelector.replace("[#@#]", puppeteerHook);
        return steps;
    }

    private static List<DomElementEnrichedExport.Target.Step> resolveTimeseriesForecastChartMulti(List<DomElementEnrichedExport.Target.Step> stepList, ModelDetailsBase model) throws IOException {
        ArrayList<DomElementEnrichedExport.Target.Step> steps = new ArrayList<DomElementEnrichedExport.Target.Step>();
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            return steps;
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        DomElementEnrichedExport.Target.Step stepTemplate = stepList.get(0);
        FullModelId fmi = FullModelId.parse(timeseriesModelDetails.fullModelId);
        TimeseriesForecastingModelPerf fullPerf = fmi.getTimeseriesForecastingPerf(true);
        int numSteps = Math.min(5, fullPerf.perTimeseriesMetrics.size());
        for (int i = 0; i < numSteps; ++i) {
            DomElementEnrichedExport.Target.Step newStep = stepTemplate.deepCopy();
            newStep.cssSelector = newStep.cssSelector.replace("[#@#]", String.valueOf(i));
            newStep.loadedStateField = newStep.loadedStateField.replace("[#@#]", String.valueOf(i));
            steps.add(newStep);
        }
        return steps;
    }

    private static List<DomElementEnrichedExport.Target.Step> resolveStepParameterValue(List<DomElementEnrichedExport.Target.Step> stepList, String parameterValue) {
        List<DomElementEnrichedExport.Target.Step> steps = PuppeteerConfigResolver.deepCopySteps(stepList);
        for (DomElementEnrichedExport.Target.Step step : steps) {
            if (!step.hasParameter || parameterValue == null) continue;
            step.setParameterValue(parameterValue);
            break;
        }
        return steps;
    }

    private static String convertBackAlgNameToFrontAlgName(ModelDetailsBase model) {
        if (model instanceof TabularPredictionModelDetails) {
            return PuppeteerConfigResolver.convertPredictionAlgoName(((TabularPredictionModelDetails)model).modeling.algorithm);
        }
        if (model instanceof ClusteringModelDetails) {
            return PuppeteerConfigResolver.convertClusteringAlgoName(((ClusteringModelDetails)model).modeling.algorithm);
        }
        return "";
    }

    private static String convertPredictionAlgoName(PreTrainPredictionModelingParams.Algorithm algorithm) {
        switch (algorithm) {
            case SVC_CLASSIFICATION: {
                return "svc_classifier";
            }
            case SGD_CLASSIFICATION: {
                return "sgd_classifier";
            }
            case LARS: {
                return "lars_params";
            }
            case SCIKIT_MODEL: {
                return "Custom Python model";
            }
            case TRIVIAL_IDENTITY_TIMESERIES: {
                return "trivial_identity_timeseries";
            }
            case SEASONAL_NAIVE: {
                return "seasonal_naive_timeseries";
            }
            case AUTO_ARIMA: {
                return "autoarima_timeseries";
            }
            case ARIMA: {
                return "arima_timeseries";
            }
            case CROSTON: {
                return "croston_timeseries";
            }
            case ETS: {
                return "ets_timeseries";
            }
            case SEASONAL_LOESS: {
                return "seasonal_loess_timeseries";
            }
            case PROPHET: {
                return "prophet_timeseries";
            }
            case GLUONTS_TORCH_SIMPLE_FEEDFORWARD: {
                return "gluonts_torch_simple_feed_forward_timeseries";
            }
            case GLUONTS_TORCH_DEEPAR: {
                return "gluonts_torch_deepar_timeseries";
            }
            case GLUONTS_NPTS_FORECASTER: {
                return "gluonts_npts_timeseries";
            }
            case GLUONTS_SIMPLE_FEEDFORWARD: {
                return "gluonts_simple_feed_forward_timeseries";
            }
            case GLUONTS_DEEPAR: {
                return "gluonts_deepar_timeseries";
            }
            case GLUONTS_TRANSFORMER: {
                return "gluonts_transformer_timeseries";
            }
            case GLUONTS_MQCNN: {
                return "gluonts_mqcnn_timeseries";
            }
            case SPARKLING_DEEP_LEARNING: {
                return "deep_learning_sparkling";
            }
            case SPARKLING_GBM: {
                return "gbm_sparkling";
            }
            case SPARKLING_RF: {
                return "rf_sparkling";
            }
            case SPARKLING_GLM: {
                return "glm_sparkling";
            }
            case SPARKLING_NB: {
                return "nb_sparkling";
            }
            case MLLIB_LOGISTIC_REGRESSION: {
                return "mllib_logit";
            }
            case MLLIB_DECISION_TREE: {
                return "mllib_dt";
            }
            case MLLIB_LINEAR_REGRESSION: {
                return "mllib_linreg";
            }
            case MLLIB_RANDOM_FOREST: {
                return "mllib_rf";
            }
            case MLLIB_NAIVE_BAYES: {
                return "mllib_naive_bayes";
            }
            case MLLIB_GBT: {
                return "mllib_gbt";
            }
            case MLLIB_CUSTOM: {
                return "Custom MLlib model";
            }
            case KERAS_CODE: {
                return "Custom MLlib model";
            }
        }
        return algorithm.name().toLowerCase();
    }

    private static String convertClusteringAlgoName(PreTrainClusteringModelingParams.Algorithm algorithm) {
        switch (algorithm) {
            case KMEANS: {
                return "kmeans_clustering";
            }
            case PY_ISOLATION_FOREST: {
                return "isolation_forest";
            }
            case GMM: {
                return "gmm_clustering";
            }
            case MiniBatchKMeans: {
                return "mini_batch_kmeans_clustering";
            }
            case WARD: {
                return "ward_clustering";
            }
            case SPECTRAL: {
                return "spectral_clustering";
            }
            case DBSCAN: {
                return "db_scan_clustering";
            }
            case HDBSCAN: {
                return "hdb_scan_clustering";
            }
            case PY_TWO_STEP: {
                return "two_step";
            }
            case SCIKIT_MODEL: {
                return "Custom Python model";
            }
            case MLLIB_ISOLATION_FOREST: {
                return "isolation_forest";
            }
            case MLLIB_GAUSSIAN_MIXTURE: {
                return "mllib_gaussian_mixture_clustering";
            }
            case MLLIB_TWO_STEP: {
                return "two_step";
            }
            case MLLIB_KMEANS: {
                return "mllib_kmeans_clustering";
            }
            case MLLIB_CUSTOM: {
                return "Custom MLlib model";
            }
            case SPARKLING_KMEANS: {
                return "h2o_kmeans";
            }
        }
        return algorithm.name().toLowerCase();
    }

    private static PuppeteerConfig resolveFromModelType(MLTask mlTask, PuppeteerConfig regressionDef, PuppeteerConfig binaryPredictionDef, PuppeteerConfig multiClassPredictionDef, PuppeteerConfig clusteringDef, PuppeteerConfig timeseriesDef) {
        if (mlTask.taskType.equals((Object)MLTask.MLTaskType.PREDICTION)) {
            if (mlTask instanceof PredictionMLTask) {
                PredictionMLTask predictionMLTask = (PredictionMLTask)mlTask;
                if (predictionMLTask.predictionType == null) {
                    return PuppeteerConfig.INVALID;
                }
                switch (predictionMLTask.predictionType) {
                    case REGRESSION: {
                        return regressionDef;
                    }
                    case BINARY_CLASSIFICATION: {
                        return binaryPredictionDef;
                    }
                    case MULTICLASS: {
                        return multiClassPredictionDef;
                    }
                    case TIMESERIES_FORECAST: {
                        return timeseriesDef;
                    }
                }
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)predictionMLTask.predictionType));
            }
            return PuppeteerConfig.INVALID;
        }
        return clusteringDef;
    }

    private static PuppeteerConfig resolveDecisionTreePlot(MLTask mlTask, ModelDetailsBase model) {
        if (MLTask.MLTaskType.PREDICTION.equals((Object)mlTask.taskType) && model instanceof ClassicalPredictionModelDetails) {
            ClassicalPredictionModelDetails predictionModelDetails = (ClassicalPredictionModelDetails)model;
            switch (predictionModelDetails.modeling.algorithm) {
                case MLLIB_RANDOM_FOREST: 
                case MLLIB_GBT: 
                case RANDOM_FOREST_CLASSIFICATION: 
                case RANDOM_FOREST_REGRESSION: 
                case GBT_CLASSIFICATION: 
                case GBT_REGRESSION: {
                    return PuppeteerConfig.RANDOM_FOREST;
                }
                case MLLIB_DECISION_TREE: 
                case DECISION_TREE_CLASSIFICATION: 
                case DECISION_TREE_REGRESSION: {
                    return PuppeteerConfig.DECISION_TREE;
                }
            }
            return PuppeteerConfig.INVALID;
        }
        return PuppeteerConfig.INVALID;
    }

    private static List<DomElementEnrichedExport.Target.Step> deepCopySteps(List<DomElementEnrichedExport.Target.Step> steps) {
        ArrayList<DomElementEnrichedExport.Target.Step> newSteps = new ArrayList<DomElementEnrichedExport.Target.Step>();
        for (DomElementEnrichedExport.Target.Step s : steps) {
            newSteps.add(s.deepCopy());
        }
        return newSteps;
    }
}

