/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering;

import com.dataiku.dip.analysis.ml.shared.ParamsExpander;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringPreprocessingParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.preprocessing.ClusteringPreprocessingParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClusteringParamsExpander
extends ParamsExpander {
    private ClusteringMLTask task;
    private String sessionId;

    public ClusteringParamsExpander(ClusteringMLTask task, String sessionId) {
        this.task = task;
        this.sessionId = sessionId;
    }

    @Override
    protected List<WorkSet.PreprocessingSet> expandPreprocessing() {
        WorkSet.PreprocessingSet ps2;
        ResolvedClusteringPreprocessingParams rppp;
        ClusteringPreprocessingParams ppp = this.task.preprocessing;
        ArrayList<WorkSet.PreprocessingSet> ret = new ArrayList<WorkSet.PreprocessingSet>();
        assert (ppp.reduce.disable || ppp.reduce.enable);
        if (ppp.reduce.disable) {
            rppp = new ResolvedClusteringPreprocessingParams();
            rppp.per_feature = (Map)JSON.deepCopy((Object)ppp.per_feature);
            rppp.reduce = new ResolvedPreprocessingParams.ReductionParams();
            rppp.reduce.enabled = false;
            rppp.outliers = ppp.outliers;
            rppp.feature_generation = ppp.feature_generation;
            ps2 = new WorkSet.PreprocessingSet(rppp, "");
            ret.add(ps2);
        }
        if (ppp.reduce.enable) {
            if (ppp.reduce.kept_variance <= 0.0f || (double)ppp.reduce.kept_variance >= 1.0) {
                throw ErrorContext.iae((String)"For PCA, kept variance must be strictly between 0 and 100%");
            }
            rppp = new ResolvedClusteringPreprocessingParams();
            rppp.per_feature = (Map)JSON.deepCopy((Object)ppp.per_feature);
            rppp.reduce = new ResolvedPreprocessingParams.ReductionParams();
            rppp.reduce.enabled = true;
            rppp.reduce.kept_variance = ppp.reduce.kept_variance;
            rppp.outliers = ppp.outliers;
            rppp.feature_generation = ppp.feature_generation;
            ps2 = new WorkSet.PreprocessingSet(rppp, "PCA (" + Math.round(rppp.reduce.kept_variance * 100.0f) + "%)");
            ret.add(ps2);
        }
        return ret;
    }

    public WorkSet expand() throws Exception {
        WorkSet ws = new WorkSet(this.sessionId);
        ClusteringParameterChecks checks = new ClusteringParameterChecks();
        ClusteringPreprocessingParams ppp = this.task.preprocessing;
        ppp.validate(checks);
        for (PreTrainClusteringModelingParams.Algorithm algo : PreTrainClusteringModelingParams.Algorithm.values()) {
            algo.meta.validateParameters(this.task.modeling, this.task, checks);
            List<WorkSet.ModelingSet> modelingSets = algo.meta.expandModeling(this.task.modeling, this.task);
            if (algo.meta.oneModelPerPreprocessingSet()) {
                for (WorkSet.ModelingSet modelingSet : modelingSets) {
                    this.addModelingSets(Lists.newArrayList((Object[])new WorkSet.ModelingSet[]{modelingSet}), ws, algo.meta.autoCompleter());
                }
                continue;
            }
            this.addModelingSets(modelingSets, ws, algo.meta.autoCompleter());
        }
        ws.messages = checks.getMessages();
        return ws;
    }
}

