/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.interactivemodel;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.analysis.coreservices.AnalysisMLContainerKernel;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.IAnalysisMLKernel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelParams;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelResponse;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.AlivenessCheckableAndClosable;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InteractiveModelKernel
implements AlivenessCheckableAndClosable {
    private IAnalysisMLKernel kernel;
    private final AuthCtx authCtx;
    private final FullModelId fmi;
    private final boolean runsInContainer;
    private boolean started;
    private final boolean writeOperation;
    private final SingleCommandKernelLink link;
    private static final String pythonModule = "dataiku.doctor.interactive_model.server";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.interactivemodel");

    public InteractiveModelKernel(AuthCtx authCtx, FullModelId fmi, boolean writeOperation, ContainerExecSelection containerExecSelection) throws Exception {
        this.authCtx = authCtx;
        this.fmi = fmi;
        this.writeOperation = writeOperation;
        if (fmi.isExternalMLflowModelVersion()) {
            ContainerExecRuntimeConfig containerConfig;
            String envName = fmi.getMLflowImportedModelMetadata().pythonCodeEnvName;
            if (containerExecSelection == null) {
                containerExecSelection = new ContainerExecSelection(ContainerExecSelection.ContainerExecMode.INHERIT);
            }
            this.runsInContainer = (containerConfig = new ContainerExecConfigSelector().select_autoTXN(authCtx, fmi.getProjectKey(), containerExecSelection)) != null;
            this.link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), ApplicationConfigurator.getPortRangeParams(), this.runsInContainer ? EncryptedRPC.getSSLContext() : null);
            if (!this.runsInContainer) {
                this.kernel = new AnalysisMLKernel(this.link, null, fmi.getProjectKey(), envName, authCtx, fmi.getModelFolder());
                this.kernel.setPythonModule("dataiku.external_ml.mlflow.interactive_model_server");
            } else {
                AnalysisMLContainerKernel containerKernel = new AnalysisMLContainerKernel(this.link, null, fmi.getProjectKey(), envName, authCtx, fmi.getPreprocessingFolder(), MLPaths.getContextDir(fmi), containerConfig, "mlflow-interactive-scoring-");
                containerKernel.setExecutionType(RemoteRunsRegistry.ExecutionType.ML_INTERACTIVE_SCORING);
                containerKernel.setPythonModule("dataiku.container.exec_mlflow_interactive_model_server");
                this.kernel = containerKernel;
            }
        } else {
            ResolvedCoreParams coreParams = fmi.getResolvedCoreParams();
            String envName = coreParams.executionParams.envName;
            if (containerExecSelection != null) {
                throw new IllegalArgumentException("Container selection override is not available for non-MLflow models.");
            }
            ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(authCtx, fmi.getProjectKey(), coreParams.executionParams.containerSelection, coreParams.backendType);
            this.runsInContainer = containerConfig != null;
            this.link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), ApplicationConfigurator.getPortRangeParams(), this.runsInContainer ? EncryptedRPC.getSSLContext() : null);
            if (!this.runsInContainer) {
                this.kernel = new AnalysisMLKernel(this.link, null, fmi.getProjectKey(), envName, authCtx, fmi.getModelFolder());
            } else {
                AnalysisMLContainerKernel containerKernel = new AnalysisMLContainerKernel(this.link, null, fmi.getProjectKey(), envName, authCtx, fmi.getPreprocessingFolder(), MLPaths.getContextDir(fmi), containerConfig, "doctor-interactive-scoring-");
                containerKernel.setExecutionType(RemoteRunsRegistry.ExecutionType.ML_INTERACTIVE_SCORING);
                this.kernel = containerKernel;
            }
            this.kernel.setPythonModule(pythonModule);
        }
    }

    public synchronized void startIfNeeded() throws Exception {
        if (!this.started) {
            this.start();
            this.started = true;
        }
    }

    private synchronized void start() throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing computation engine", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            FutureProgress.updateState((double)0.0);
            logger.info((Object)("Starting kernel with user id " + this.authCtx.getIdentifier() + " and model id " + this.fmi.getModelId()));
            this.kernel.start();
            this.grantACLToKernelOwner();
            FutureProgress.updateState((double)1.0);
        }
        catch (Exception e) {
            this.close();
            throw new CodedException((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, "Interactive Model Python kernel failed to start", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        logger.info((Object)"Killing Interactive Model kernel");
        try {
            this.link.close();
        }
        catch (IOException e) {
            logger.error((Object)"Could not close Javalink", (Throwable)e);
        }
    }

    public void killKernel() throws IOException {
        try {
            this.kernel.abort();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while killing python kernel", e);
        }
    }

    public synchronized InteractiveModelResponse.InteractiveModelResult[] compute(InteractiveModelParams.ComputationParams computationParams, List<JsonObject> records) throws Exception {
        InteractiveModelResponse response;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.fmi.isExternalMLflowModelVersion()) {
            MLFlowModelVersionInfo mim;
            DSSConnection connection;
            ProxySettings proxySettings;
            params.put("model_folder", this.fmi.getModelFolder().getAbsolutePath());
            params.put("fmi", this.fmi.toString());
            params.put("computation_params", (Object)computationParams);
            params.put("records", records);
            if (!this.runsInContainer && (proxySettings = ExternalInfrasUtils.getProxy(connection = ExternalInfrasUtils.getAndCheckConnection(this.authCtx, (mim = this.fmi.getMLflowImportedModelMetadata()).getProxyModelConnection()))).hasProxy()) {
                params.put("_PROXY_MODELS_PROXY", proxySettings.getAsString());
            }
        } else {
            ResolvedCoreParams coreParams = this.fmi.getResolvedCoreParams();
            params.put("split_desc", this.fmi.getSplitDesc());
            params.put("core_params", coreParams);
            params.put("model_folder", this.fmi.getModelFolder().getAbsolutePath());
            params.put("preprocessing_folder", this.fmi.getPreprocessingFolder().getAbsolutePath());
            params.put("split_folder", this.fmi.getSplitFolder().getAbsolutePath());
            params.put("computation_params", (Object)computationParams);
            params.put("records", records);
            params.put("fmi", this.fmi.toString());
        }
        try {
            this.link.sendRequest((Object)new ArbitraryCommand(JSON.pretty(params), JSON.getType((Object)((Object)computationParams))));
            response = (InteractiveModelResponse)this.link.receiveJsonResponse(InteractiveModelResponse.class);
        }
        catch (SocketBlockLinkException e) {
            logger.error((Object)e.getMessage());
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
        }
        catch (IOException e) {
            throw new SocketBlockLinkIOException("Failed to run kernel computation", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel);
        }
        if (response.error != null) {
            throw new SocketBlockLinkKernelException("Could not compute " + JSON.getType((Object)((Object)computationParams)), response.error).withLogTail((IDSSKernelBase)this.kernel);
        }
        return response.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runNonInteractiveMLflowCommand(String commandType, Map<String, Object> additionalParams) throws Exception {
        MLFlowModelVersionInfo mim;
        DSSConnection connection;
        ProxySettings proxySettings;
        if (!this.fmi.isExternalMLflowModelVersion()) {
            throw new UnsupportedOperationException("Cannot run a mlflow command on a non-mlflow model.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(additionalParams);
        params.put("model_folder", this.fmi.getModelFolder().getAbsolutePath());
        if (!this.runsInContainer && (proxySettings = ExternalInfrasUtils.getProxy(connection = ExternalInfrasUtils.getAndCheckConnection(this.authCtx, (mim = this.fmi.getMLflowImportedModelMetadata()).getProxyModelConnection()))).hasProxy()) {
            params.put("_PROXY_MODELS_PROXY", proxySettings.getAsString());
        }
        InteractiveModelResponse response = null;
        Throwable error = null;
        try {
            try {
                this.link.sendRequest((Object)new ArbitraryCommand(JSON.pretty(params), commandType));
                response = (InteractiveModelResponse)this.link.receiveJsonResponse(InteractiveModelResponse.class);
            }
            catch (SocketBlockLinkException e) {
                logger.error((Object)e.getMessage());
                error = this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
            }
            catch (IOException e) {
                error = new SocketBlockLinkIOException("Failed to run kernel command", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel);
            }
            if (response != null && response.error != null) {
                error = new SocketBlockLinkKernelException("Could not run command " + commandType + ":", response.error).withLogTail((IDSSKernelBase)this.kernel);
            }
        }
        finally {
            try {
                this.kernel.waitForResults();
            }
            catch (Exception e) {
                logger.error((Object)"Failure while waiting for results", (Throwable)e);
            }
            try {
                this.kernel.cleanup();
                this.kernel.killWithoutMercy();
            }
            catch (Exception e) {
                logger.error((Object)"Failure while destroying interactive model kernel", (Throwable)e);
            }
            if (this.link != null) {
                try {
                    this.link.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while closing link to interactive model kernel", (Throwable)e);
                }
            }
            this.kernel = null;
            if (error != null) {
                throw error;
            }
        }
    }

    public SingleCommandKernelLink getLink() {
        return this.link;
    }

    @Override
    public boolean isAlive() {
        return !this.kernel.isAborted() && !this.kernel.isFinished();
    }

    private void grantACLToKernelOwner() throws DKUSecurityException, InterruptedException, IOException {
        FilesystemACLUtils.grantFSReadACLs(this.authCtx, this.fmi.getProjectKey(), this.fmi.getFolderEnsuringSecurity());
        if (this.writeOperation) {
            this.grantFullACLToKernelOwner();
        } else {
            this.grantReadACLToKernelOwner();
        }
    }

    private void grantFullACLToKernelOwner() throws DKUSecurityException, InterruptedException, IOException {
        if (this.runsInContainer) {
            return;
        }
        if (!this.fmi.isPartitionedBaseModel()) {
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.fmi.getProjectKey(), this.fmi.getPreprocessingFolder());
        } else if (this.fmi.type == FullModelId.Type.SAVED) {
            File smBaseFolder = MLPaths.savedModelBaseFolder(this.fmi.getProjectKey(), this.fmi.getSavedModelID());
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.fmi.getProjectKey(), smBaseFolder);
        } else {
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.fmi.getProjectKey(), this.fmi.getSessionFolder());
        }
    }

    private void grantReadACLToKernelOwner() throws DKUSecurityException, InterruptedException, IOException {
        if (this.runsInContainer) {
            return;
        }
        if (!this.fmi.isPartitionedBaseModel()) {
            FilesystemACLUtils.grantFSReadACLs(this.authCtx, this.fmi.getProjectKey(), this.fmi.getPreprocessingFolder());
        } else if (this.fmi.type == FullModelId.Type.SAVED) {
            File smBaseFolder = MLPaths.savedModelBaseFolder(this.fmi.getProjectKey(), this.fmi.getSavedModelID());
            FilesystemACLUtils.grantFSReadACLs(this.authCtx, this.fmi.getProjectKey(), smBaseFolder);
        } else {
            FilesystemACLUtils.grantFSReadACLs(this.authCtx, this.fmi.getProjectKey(), this.fmi.getSessionFolder());
        }
    }

    public SmartLogTail getKernelLogTail() {
        if (null == this.kernel) {
            return new SmartLogTail();
        }
        return this.kernel.getLogTail();
    }

    static class ArbitraryCommand {
        String type;
        String params;

        ArbitraryCommand(String params, String type) {
            this.params = params;
            this.type = type;
        }
    }

    public static enum KernelType {
        MLFLOW_KERNEL_TYPE("MLflow Python"),
        PROXY_MODEL_KERNEL_TYPE("External Model");

        public final String name;

        private KernelType(String name) {
            this.name = name;
        }

        public String displayName() {
            return this.name.replace(" ", "_").toLowerCase();
        }
    }
}

