/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.MetricMapProvider;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MulticlassModelPerf
extends PredictionModelPerf {
    public String[] classes;
    public MulticlassConfusion confusion;
    public Map<String, List<BinaryClassificationModelPerf.RocVizBin>> oneVsAllRocCurves = new HashMap<String, List<BinaryClassificationModelPerf.RocVizBin>>();
    public Map<String, Double> oneVsAllRocAUC = new HashMap<String, Double>();
    public Map<String, BinaryClassificationModelPerf.PrVizData> oneVsAllPrCurves = new HashMap<String, BinaryClassificationModelPerf.PrVizData>();
    public Map<String, Double> oneVsAllAveragePrecision = new HashMap<String, Double>();
    public Map<String, BinaryClassificationModelPerf.PerClassPredictedProbabilityDensityData> densityData = new HashMap<String, BinaryClassificationModelPerf.PerClassPredictedProbabilityDensityData>();
    public Map<String, List<BinaryClassificationModelPerf.CalibrationBin>> oneVsAllCalibrationCurves = new HashMap<String, List<BinaryClassificationModelPerf.CalibrationBin>>();
    public Map<String, Double> oneVsAllCalibrationLoss = new HashMap<String, Double>();
    public Metrics metrics = new Metrics();

    @Override
    public Map<String, Double> getMetricMap(boolean withStdMetrics) {
        HashMap<String, Double> metricMap = new HashMap<String, Double>();
        metricMap.put("mrocAUC", this.metrics.mrocAUC);
        metricMap.put("averagePrecision", this.metrics.averagePrecision);
        metricMap.put("mcalibrationLoss", this.metrics.mcalibrationLoss);
        metricMap.put("recall", this.metrics.recall);
        metricMap.put("precision", this.metrics.precision);
        metricMap.put("f1", this.metrics.f1);
        metricMap.put("accuracy", this.metrics.accuracy);
        metricMap.put("logLoss", this.metrics.logLoss);
        metricMap.put("hammingLoss", this.metrics.hammingLoss);
        if (withStdMetrics) {
            metricMap.put("mrocAUCstd", this.metrics.mrocAUCstd);
            metricMap.put("averagePrecisionstd", this.metrics.averagePrecisionstd);
            metricMap.put("mcalibrationLossstd", this.metrics.mcalibrationLossstd);
            metricMap.put("recallstd", this.metrics.recallstd);
            metricMap.put("precisionstd", this.metrics.precisionstd);
            metricMap.put("f1std", this.metrics.f1std);
            metricMap.put("accuracystd", this.metrics.accuracystd);
            metricMap.put("logLossstd", this.metrics.logLossstd);
            metricMap.put("hammingLossstd", this.metrics.hammingLossstd);
        }
        return MetricMapProvider.addCustomMetricsToMetricMap(this.metrics.customMetricsResults, metricMap, withStdMetrics);
    }

    public static class Metrics {
        public Double mrocAUC;
        public double mrocAUCstd;
        public Double averagePrecision;
        public double averagePrecisionstd;
        public Double mcalibrationLoss;
        public double mcalibrationLossstd;
        public Double recall;
        public double recallstd;
        public Double precision;
        public double precisionstd;
        public Double f1;
        public double f1std;
        public Double accuracy;
        public double accuracystd;
        public Double logLoss;
        public double logLossstd;
        public Double hammingLoss;
        public double hammingLossstd;
        public Double customScore;
        public double customScorestd;
        public PredictionModelPerf.AssertionsMetrics assertionsMetrics;
        public PredictionModelPerf.OverridesMetrics overridesMetrics;
        public CustomMetricResult[] customMetricsResults;
    }

    public static class Point {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class MulticlassConfusion {
        public Map<String, MulticlassActualClassConfusion> perActual = new HashMap<String, MulticlassActualClassConfusion>();
        public long totalRows;
    }

    public static class MulticlassActualClassConfusion {
        public double actualClassCount;
        public Map<String, Double> perPredicted = new HashMap<String, Double>();
    }
}

