/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.PredictionAlgorithmMeta;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EnsembleMeta
extends PredictionAlgorithmMeta {
    private final boolean isPython;

    public EnsembleMeta(boolean isPython) {
        this.isPython = isPython;
    }

    @Override
    public MLTask.BackendType backendType() {
        return this.isPython ? MLTask.BackendType.PY_MEMORY : MLTask.BackendType.MLLIB;
    }

    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Ensemble";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        ModelTrainInfo.PreSearchDescription d = new ModelTrainInfo.PreSearchDescription(rpmp);
        ArrayList<String> algos = new ArrayList<String>();
        for (PreTrainPredictionModelingParams r : rpmp.ensemble_params.modeling_params) {
            algos.add(r.algorithm.meta.generateName(r));
        }
        return d.withSVParam("method", rpmp.ensemble_params.method.methodName).withMVParam("algorithms", algos);
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        ModelTrainInfo.PostSearchDescription d = new ModelTrainInfo.PostSearchDescription();
        ArrayList<String> algos = new ArrayList<String>();
        for (PreTrainPredictionModelingParams r : before.ensemble_params.modeling_params) {
            algos.add(r.algorithm.meta.generateName(r));
        }
        return d.withSVParam("method", before.ensemble_params.method.methodName).withSVParam("algorithms", StringUtils.join(algos, (String)","));
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        return new ArrayList<WorkSet.ModelingSet>();
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        return this.getCopyWithGridStrategy(usedToTrain);
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        throw new Error("should not regridify an ensemble");
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
    }
}

