/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.spark;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.spark.MLLibAlgorithmMeta;
import java.util.ArrayList;
import java.util.List;

public class MLLibNBMeta
extends MLLibAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Naive Bayes (MLLib)";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        return new ModelTrainInfo.PreSearchDescription(rpmp).withMVParam("lambda", rpmp.mllib_naive_bayes_grid.lambda);
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        return new ModelTrainInfo.PostSearchDescription().withSVParam("lambda", after.mllib_naive_bayes.lambda);
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        if (pmp.mllib_naive_bayes == null || !pmp.mllib_naive_bayes.enabled) {
            return;
        }
        checks.checkNumericalDimension(pmp.mllib_naive_bayes.lambda, "Lambda parameter (Naive Bayes)");
        checks.checkNoNumericalFeatures("Naive Bayes cannot be trained with numerical features.");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (pmp.mllib_naive_bayes == null || !pmp.mllib_naive_bayes.enabled) {
            return ret;
        }
        PreTrainPredictionModelingParams rcmp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.MLLIB_NAIVE_BAYES, pmp);
        rcmp.mllib_naive_bayes_grid = pmp.mllib_naive_bayes;
        rcmp.gridLength = pmp.mllib_naive_bayes.lambda.getLength();
        WorkSet.ModelingSet ms = new WorkSet.ModelingSet(rcmp);
        ms.estimatedTrains = rcmp.gridLength > 1 ? rcmp.gridLength * gsFolds + 1 : 1;
        ret.add(ms);
        return ret;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams ret = this.getCopyWithGridStrategy(usedToTrain);
        ret.mllib_naive_bayes_grid.lambda.setToSingleValueGrid(optimized.mllib_naive_bayes.lambda);
        return ret;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.mllib_naive_bayes = preTrain.mllib_naive_bayes_grid;
        target.mllib_naive_bayes.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.mllib_naive_bayes = usedToTrain.mllib_naive_bayes_grid;
        target.mllib_naive_bayes.enabled = true;
    }
}

