/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.spark;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.spark.SparklingAlgorithmMeta;
import java.util.ArrayList;
import java.util.List;

public class SparklingGBMMeta
extends SparklingAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Gradient Boosting (H2O)";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        return new ModelTrainInfo.PreSearchDescription(rpmp).withSVParam("family", rpmp.gbm_sparkling_grid.family).withSVParam("trees", rpmp.gbm_sparkling_grid.ntrees).withSVParam("depth", rpmp.gbm_sparkling_grid.max_depth).withSVParam("learning_rate", Float.valueOf(rpmp.gbm_sparkling_grid.learn_rate));
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        return new ModelTrainInfo.PostSearchDescription().withSVParam("family", before.gbm_sparkling_grid.family).withSVParam("trees", before.gbm_sparkling_grid.ntrees).withSVParam("depth", before.gbm_sparkling_grid.max_depth).withSVParam("learning_rate", Float.valueOf(before.gbm_sparkling_grid.learn_rate));
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        if (pmp.gbm_sparkling == null || !pmp.gbm_sparkling.enabled) {
            return;
        }
        pmp.gbm_sparkling.validate();
        checks.addWarningSparse("GBM");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (pmp.gbm_sparkling == null || !pmp.gbm_sparkling.enabled) {
            return ret;
        }
        PreTrainPredictionModelingParams rcmp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.SPARKLING_GBM, pmp);
        rcmp.gbm_sparkling_grid = pmp.gbm_sparkling;
        ret.add(new WorkSet.ModelingSet(rcmp));
        return ret;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        return this.getCopyWithGridStrategy(usedToTrain);
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gbm_sparkling = preTrain.gbm_sparkling_grid;
        target.gbm_sparkling.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gbm_sparkling = usedToTrain.gbm_sparkling_grid;
        target.gbm_sparkling.enabled = true;
    }
}

