/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.deployments.ApiServiceDeployerKeysCRUDService;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.HashUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.AuthRealm;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class APIServiceDeploymentHelper {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.mad.deployments.helper");

    private APIServiceDeploymentHelper() {
    }

    public static File getOrMakeAuthReadyPackage(File sourcePackageFile, File tempDir, AbstractAPIServiceDeployment deployment, String generation) throws IOException {
        logger.info((Object)("Handling auth-ready sourcePackage=" + String.valueOf(sourcePackageFile) + " deployment=" + deployment.id + " generation=" + generation));
        PublishedAPIServicesService publishedAPIServicesService = (PublishedAPIServicesService)SpringUtils.getBean(PublishedAPIServicesService.class);
        String deployerKey = ((ApiServiceDeployerKeysCRUDService)SpringUtils.getBean(ApiServiceDeployerKeysCRUDService.class)).get(deployment.id);
        File authReadyFile = publishedAPIServicesService.getAuthReadyPackageFile(deployment.publishedServiceId, generation, deployment.auth.getHash(), deployerKey);
        if (authReadyFile.isFile()) {
            logger.info((Object)("auth-ready cache already exists: " + String.valueOf(authReadyFile)));
            return authReadyFile;
        }
        boolean authorizationToQueryThroughDeployer = deployment.auth.permissions.stream().anyMatch(permission -> permission.queryThroughDeployer);
        String deployerKeyHash = authorizationToQueryThroughDeployer && deployerKey != null ? HashUtils.sha256WithSalt((String)deployerKey) : null;
        switch (deployment.auth.authMode) {
            case PUBLIC: {
                logger.info((Object)"requested mode = public");
                try (ZipFile zf = new ZipFile(sourcePackageFile);){
                    ZipEntry configEntry = zf.getEntry("config.json");
                    LambdaServiceConfig lsc = (LambdaServiceConfig)JSON.parse((InputStream)zf.getInputStream(configEntry), LambdaServiceConfig.class);
                    if (lsc.getAuthMethod() == LambdaAuthMethod.PUBLIC && !authorizationToQueryThroughDeployer) {
                        logger.info((Object)"Source package is already in public mode and no authorization to query through deployer, nothing to do");
                        File file = sourcePackageFile;
                        return file;
                    }
                    DKUFileUtils.mkdirs((File)tempDir);
                    logger.info((Object)("Source package is not public, unpacking to " + String.valueOf(tempDir)));
                    ZipUnzipDir.extractFolder(sourcePackageFile, tempDir);
                    lsc = (LambdaServiceConfig)JSON.parseFile((File)new File(tempDir, "config.json"), LambdaServiceConfig.class);
                    lsc.authMethod = LambdaAuthMethod.PUBLIC;
                    lsc.authRealm = null;
                    lsc.deployerKeyHash = deployerKeyHash;
                    JSON.prettyToFile((Object)lsc, (File)new File(tempDir, "config.json"));
                    DKUFileUtils.mkdirsParent((File)authReadyFile);
                    ZipUnzipDir.zipDirectory(tempDir, authReadyFile);
                    DKUFileUtils.forceDelete((File)tempDir);
                    logger.info((Object)("Built authReadyFile " + String.valueOf(authReadyFile)));
                    File file = authReadyFile;
                    return file;
                }
            }
            case API_KEYS: {
                logger.info((Object)("Requested mode = explicit, unpacking to " + String.valueOf(tempDir)));
                DKUFileUtils.mkdirs((File)tempDir);
                ZipUnzipDir.extractFolder(sourcePackageFile, tempDir);
                LambdaServiceConfig lsc = (LambdaServiceConfig)JSON.parseFile((File)new File(tempDir, "config.json"), LambdaServiceConfig.class);
                lsc.authMethod = LambdaAuthMethod.API_KEYS;
                lsc.authRealm = new AuthRealm();
                lsc.authRealm.queryKeys.addAll(deployment.auth.apiKeys.stream().map(QueryAPIKey::deepCopy).toList());
                lsc.deployerKeyHash = deployerKeyHash;
                PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                lsc.authRealm.decryptKeysIfEncrypted(passwordEncryptionService);
                JSON.prettyToFile((Object)lsc, (File)new File(tempDir, "config.json"));
                DKUFileUtils.mkdirsParent((File)authReadyFile);
                ZipUnzipDir.zipDirectory(tempDir, authReadyFile);
                DKUFileUtils.forceDelete((File)tempDir);
                logger.info((Object)("Built authReadyFile " + String.valueOf(authReadyFile)));
                return authReadyFile;
            }
            case OAUTH2: {
                logger.info((Object)("Requested mode = explicit, unpacking to " + String.valueOf(tempDir)));
                DKUFileUtils.mkdirs((File)tempDir);
                ZipUnzipDir.extractFolder(sourcePackageFile, tempDir);
                LambdaServiceConfig lsc = (LambdaServiceConfig)JSON.parseFile((File)new File(tempDir, "config.json"), LambdaServiceConfig.class);
                lsc.authMethod = LambdaAuthMethod.OAUTH2;
                lsc.authRealm = null;
                lsc.oauth2Config = deployment.auth.oauth2Config;
                lsc.deployerKeyHash = deployerKeyHash;
                JSON.prettyToFile((Object)lsc, (File)new File(tempDir, "config.json"));
                DKUFileUtils.mkdirsParent((File)authReadyFile);
                ZipUnzipDir.zipDirectory(tempDir, authReadyFile);
                DKUFileUtils.forceDelete((File)tempDir);
                logger.info((Object)("Built authReadyFile " + String.valueOf(authReadyFile)));
                return authReadyFile;
            }
            case INHERIT_DEV: {
                logger.info((Object)("Requested mode = inherit, authorization to query through deployer, unpacking to " + String.valueOf(tempDir)));
                DKUFileUtils.mkdirs((File)tempDir);
                ZipUnzipDir.extractFolder(sourcePackageFile, tempDir);
                LambdaServiceConfig lsc = (LambdaServiceConfig)JSON.parseFile((File)new File(tempDir, "config.json"), LambdaServiceConfig.class);
                lsc.deployerKeyHash = deployerKeyHash;
                JSON.prettyToFile((Object)lsc, (File)new File(tempDir, "config.json"));
                DKUFileUtils.mkdirsParent((File)authReadyFile);
                ZipUnzipDir.zipDirectory(tempDir, authReadyFile);
                DKUFileUtils.forceDelete((File)tempDir);
                logger.info((Object)("Built authReadyFile " + String.valueOf(authReadyFile)));
                return authReadyFile;
            }
        }
        throw new Error("unreachable");
    }

    public static String getSanitizedDSSVersionForImages() {
        return DKUApp.getDSSVersion().product_version.toLowerCase(Locale.ENGLISH).replace("/", "_").trim();
    }

    public static String getSanitizedInstallIdForImages() {
        return DKUApp.getInstallId().toLowerCase(Locale.ENGLISH).replace("/", "_").trim();
    }
}

