/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.badges;

import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.badges.ProjectBadges;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.ProjectBadgesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.recipes.nlp.classification.model_provided.NLPLLMModelProvidedClassificationRecipeMeta;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeMeta;
import com.dataiku.dip.recipes.nlp.evaluation.llm.LLMEvaluationRecipeMeta;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRecipeMeta;
import com.dataiku.dip.recipes.nlp.finetuning.FineTuningRecipeMeta;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipeMeta;
import com.dataiku.dip.recipes.nlp.rag_embedding.RAGEmbeddingRecipeMeta;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipeMeta;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectTypeBadgesChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.IExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.WebAppUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectTypeBadgesService {
    private static final List<SavedModel.SavedModelType> ML_SAVED_MODEL_TYPES = List.of(SavedModel.SavedModelType.DSS_MANAGED, SavedModel.SavedModelType.PROXY_MODEL, SavedModel.SavedModelType.MLFLOW_PYFUNC);
    private static final List<SavedModel.SavedModelType> LLM_SAVED_MODEL_TYPES = List.of(SavedModel.SavedModelType.LLM_GENERIC, SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM);
    private static final List<String> LLM_RECIPE_TYPES = List.of(PromptRecipeMeta.META.getType(), NLPLLMModelProvidedClassificationRecipeMeta.META.getType(), SummarizationRecipeMeta.META.getType(), EmbedDocumentsRecipeMeta.META.getType(), ExtractContentRecipeMeta.META.getType(), RAGEmbeddingRecipeMeta.META.getType(), FineTuningRecipeMeta.META.getType(), LLMEvaluationRecipeMeta.META.getType());
    private static final List<ITaggingService.TaggableType> IGNORED_TAGGABLE_TYPES = List.of(ITaggingService.TaggableType.PROJECT, ITaggingService.TaggableType.LAMBDA_SERVICE, ITaggingService.TaggableType.WORKSPACE, ITaggingService.TaggableType.DATA_COLLECTION, ITaggingService.TaggableType.STATISTICS_WORKSHEET, ITaggingService.TaggableType.API_DEPLOYER_INFRA, ITaggingService.TaggableType.API_DEPLOYER_SERVICE, ITaggingService.TaggableType.API_DEPLOYER_DEPLOYMENT, ITaggingService.TaggableType.PROJECT_DEPLOYER_INFRA, ITaggingService.TaggableType.PROJECT_DEPLOYER_PROJECT, ITaggingService.TaggableType.PROJECT_DEPLOYER_DEPLOYMENT, ITaggingService.TaggableType.WORKSPACE_LINK, ITaggingService.TaggableType.CODE_STUDIO_TEMPLATE, ITaggingService.TaggableType.WORKSPACE_STORY);
    private final TransactionService transactionService;
    private final TaggableObjectsReadService taggableObjectsReadService;
    private final ProjectBadgesDAO projectBadgesDAO;
    private final PubSubService pubSubService;
    private final ProjectsDAO projectsDAO;
    private final IExposedObjectsService exposedObjectsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.badges.project-type-badges-service");

    @Autowired
    public ProjectTypeBadgesService(TaggableObjectsReadService taggableObjectsReadService, ProjectBadgesDAO projectBadgesDAO, TransactionService transactionService, PubSubService pubSubService, ProjectsDAO projectsDAO, IExposedObjectsService exposedObjectsService) {
        this.taggableObjectsReadService = taggableObjectsReadService;
        this.projectBadgesDAO = projectBadgesDAO;
        this.transactionService = transactionService;
        this.pubSubService = pubSubService;
        this.projectsDAO = projectsDAO;
        this.exposedObjectsService = exposedObjectsService;
    }

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("object-change", this::handleTaggableObjectChangedEvent);
    }

    public List<TypeBadge> listBadges(String projectKey) throws IOException {
        ProjectBadges projectBadges;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            projectBadges = this.projectBadgesDAO.read(projectKey);
        }
        if (projectBadges != null) {
            return projectBadges.listBadges();
        }
        return Collections.emptyList();
    }

    public void synchronizeBadges_NT(String projectKey, List<ProjectsService.AnyLocWithType> exposedObjects) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        ProjectBadges projectBadges = this.computeProjectBadges(projectKey, exposedObjects, false);
        this.saveBadgesIfNeeded(projectKey, projectBadges);
    }

    public void synchronizeBadges_NT(String projectKey) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        ProjectBadges projectBadges = this.computeProjectBadges(projectKey);
        this.saveBadgesIfNeeded(projectKey, projectBadges);
    }

    private ProjectBadges computeProjectBadges(String projectKey) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            ProjectBadges projectBadges = this.computeProjectBadges(projectKey, this.projectsDAO.getAllExposedObjects(projectKey), true);
            return projectBadges;
        }
    }

    private ProjectBadges computeProjectBadges(String projectKey, List<ProjectsService.AnyLocWithType> exposedObjects, boolean considerAllTaggableObjects) throws IOException {
        logger.infoV("Starting the computation of Type Badges for project %s", new Object[]{projectKey});
        List<Object> taggableObjects = new ArrayList<TaggableObjectsService.TaggableObject>();
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            if (considerAllTaggableObjects) {
                taggableObjects = this.taggableObjectsReadService.listUnsafe(projectKey, null);
            } else {
                taggableObjects.addAll(this.taggableObjectsReadService.listUnsafe(projectKey, ITaggingService.TaggableType.WEB_APP));
                taggableObjects.addAll(this.taggableObjectsReadService.listUnsafe(projectKey, ITaggingService.TaggableType.SAVED_MODEL));
                taggableObjects.addAll(this.taggableObjectsReadService.listUnsafe(projectKey, ITaggingService.TaggableType.RECIPE));
            }
            for (ProjectsService.AnyLocWithType anyLocWithType : exposedObjects) {
                TaggableObjectsService.TaggableObject sharedTaggableObject;
                if (anyLocWithType.type == null || (sharedTaggableObject = this.taggableObjectsReadService.getOrNullUnsafe(anyLocWithType.getProjectKey(), anyLocWithType.type, anyLocWithType.getId())) == null) continue;
                taggableObjects.add(sharedTaggableObject);
            }
        }
        ProjectBadges projectBadges = new ProjectBadges();
        for (TaggableObjectsService.TaggableObject taggableObject : taggableObjects) {
            if (taggableObject == null || taggableObject.getTaggableType() == ITaggingService.TaggableType.LAMBDA_SERVICE) {
                logger.debugV("Not considering lambda service %s in the computation of project badges for project %s", new Object[]{taggableObject.getId(), projectKey});
                continue;
            }
            this.addObjectToBadgeContributorsIfNeeded(projectBadges, taggableObject, projectKey);
        }
        logger.infoV("Finished computing Type Badges for project %s", new Object[]{projectKey});
        return projectBadges;
    }

    private boolean isML(TaggableObjectsService.TaggableObject taggableObject) {
        if (taggableObject instanceof SavedModel) {
            SavedModel savedModel = (SavedModel)taggableObject;
            if (savedModel.savedModelType != null) {
                return ML_SAVED_MODEL_TYPES.contains((Object)savedModel.savedModelType);
            }
        }
        return false;
    }

    private boolean isLLM(TaggableObjectsService.TaggableObject taggableObject) {
        if (taggableObject instanceof SavedModel) {
            SavedModel savedModel = (SavedModel)taggableObject;
            if (savedModel.savedModelType != null) {
                return LLM_SAVED_MODEL_TYPES.contains((Object)savedModel.savedModelType);
            }
        }
        if (taggableObject instanceof WebApp) {
            WebApp webApp = (WebApp)taggableObject;
            return WebAppUtils.isDataikuAnswers(webApp);
        }
        if (taggableObject instanceof SerializedRecipe) {
            SerializedRecipe recipe = (SerializedRecipe)taggableObject;
            return LLM_RECIPE_TYPES.contains(recipe.getType());
        }
        return false;
    }

    private boolean isAgent(TaggableObjectsService.TaggableObject taggableObject) {
        if (taggableObject instanceof SavedModel) {
            SavedModel savedModel = (SavedModel)taggableObject;
            if (savedModel.savedModelType != null) {
                return savedModel.savedModelType.isAgent();
            }
        }
        if (taggableObject instanceof WebApp) {
            WebApp webApp = (WebApp)taggableObject;
            return WebAppUtils.isAgentConnect(webApp) || WebAppUtils.isAgentHub(webApp);
        }
        return false;
    }

    @VisibleForTesting
    static boolean canBeIgnored(TaggableObjectChangedEvent event) {
        try {
            if (IGNORED_TAGGABLE_TYPES.contains((Object)event.objectType)) {
                return true;
            }
            return switch (event.action.category) {
                case TaggableObjectChangedEvent.ActionCategory.EDITED -> {
                    if (!TaggableObjectDiffService.TaggableObjectsDiff.isAboutTags(event.details)) {
                        yield true;
                    }
                    yield false;
                }
                case TaggableObjectChangedEvent.ActionCategory.CREATED -> {
                    if (!List.of(ITaggingService.TaggableType.SAVED_MODEL, ITaggingService.TaggableType.RECIPE, ITaggingService.TaggableType.WEB_APP).contains((Object)event.objectType)) {
                        yield true;
                    }
                    yield false;
                }
                case TaggableObjectChangedEvent.ActionCategory.DELETED, TaggableObjectChangedEvent.ActionCategory.RENAMED, TaggableObjectChangedEvent.ActionCategory.SHARED -> false;
                default -> true;
            };
        }
        catch (Exception e) {
            return false;
        }
    }

    private void handleTaggableObjectChangedEvent(TaggableObjectChangedEvent event) {
        if (ProjectTypeBadgesService.canBeIgnored(event)) {
            return;
        }
        TaggableObjectsService.TaggableObjectRef taggableObjectRef = event.getTaggableObjectRef();
        try {
            switch (event.action.category) {
                case CREATED: {
                    this.updateOnObjectCreation(taggableObjectRef);
                    break;
                }
                case EDITED: {
                    this.updateOnObjectEdit(taggableObjectRef, event);
                    break;
                }
                case DELETED: {
                    this.updateOnObjectDeletion(taggableObjectRef);
                    break;
                }
                case RENAMED: {
                    this.updateOnObjectRenaming(taggableObjectRef, event.objectId);
                    break;
                }
                case SHARED: {
                    this.updateOnObjectShare(taggableObjectRef, event.details);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Failed to process TaggableObjectChangedEvent for taggable object %s of type %s in project %s", new Object[]{taggableObjectRef.id, taggableObjectRef.projectKey, taggableObjectRef.type});
        }
    }

    private void updateOnObjectCreation(@Nonnull TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException {
        ProjectBadges projectBadges;
        TaggableObjectsService.TaggableObject taggableObject;
        logger.debugV("Handling creation of taggable object %s in project %s", new Object[]{taggableObjectRef.id, taggableObjectRef.projectKey});
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            taggableObject = this.taggableObjectsReadService.getOrNullUnsafe(taggableObjectRef);
            projectBadges = this.projectBadgesDAO.read(taggableObject.getProjectKey());
        }
        this.addObjectToBadgeContributorsIfNeeded(projectBadges, taggableObject, taggableObject.getProjectKey());
        this.saveBadgesIfNeeded(taggableObject.getProjectKey(), projectBadges);
    }

    private void updateOnObjectDeletion(@Nonnull TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException {
        ProjectBadges projectBadges;
        logger.debugV("Handling deletion of taggable object %s in project %s", new Object[]{taggableObjectRef.id, taggableObjectRef.projectKey});
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            projectBadges = this.projectBadgesDAO.read(taggableObjectRef.projectKey);
        }
        for (TypeBadge badge : TypeBadge.values()) {
            projectBadges.removeFromContributors(badge, taggableObjectRef.getType(), taggableObjectRef.id);
        }
        this.saveBadgesIfNeeded(taggableObjectRef.projectKey, projectBadges);
    }

    private void syncBadgeOnRenaming(String projectKey, ITaggingService.TaggableType objectType, String newObjectId, String oldObjectId) throws IOException {
        ProjectBadges projectBadges;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            projectBadges = this.projectBadgesDAO.read(projectKey);
        }
        for (TypeBadge badge : TypeBadge.values()) {
            if (!projectBadges.isContributing(badge, objectType, oldObjectId)) continue;
            projectBadges.removeFromContributors(badge, objectType, oldObjectId);
            projectBadges.addToContributors(badge, objectType, newObjectId);
        }
        this.saveBadgesIfNeeded(projectKey, projectBadges);
    }

    private void updateOnObjectRenaming(@Nonnull TaggableObjectsService.TaggableObjectRef taggableObjectRef, String oldObjectId) throws IOException {
        ExposedObjectsService.ObjectsExpositions objectExpositions;
        if (Objects.equals(taggableObjectRef.id, oldObjectId)) {
            logger.debugV("Object ID '%s' has not changed. Skipping rename badge update.", new Object[]{oldObjectId});
            return;
        }
        logger.debugV("Handling renaming of taggable object %s to %s in project %s", new Object[]{oldObjectId, taggableObjectRef.id, taggableObjectRef.projectKey});
        this.syncBadgeOnRenaming(taggableObjectRef.projectKey, taggableObjectRef.getType(), taggableObjectRef.id, oldObjectId);
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            objectExpositions = this.exposedObjectsService.getObjectsExpositions(Set.of(taggableObjectRef));
        }
        for (String objectExposedProjectKey : objectExpositions.projects.keySet()) {
            this.syncBadgeOnRenaming(objectExposedProjectKey, taggableObjectRef.getType(), taggableObjectRef.getLoc().getFullName(), new AnyLoc(taggableObjectRef.projectKey, oldObjectId).getFullName());
        }
    }

    private void syncBadgeOnEdit(String projectKey, List<String> addedTags, List<String> removedTags, TaggableObjectsService.TaggableObject taggableObject, String objectId) throws IOException {
        ProjectBadges projectBadges;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            projectBadges = this.projectBadgesDAO.read(projectKey);
        }
        if (addedTags.contains("type-ml")) {
            projectBadges.addToContributors(TypeBadge.ML, taggableObject.getTaggableType(), objectId);
        }
        if (addedTags.contains("type-llm")) {
            projectBadges.addToContributors(TypeBadge.LLM, taggableObject.getTaggableType(), objectId);
        }
        if (addedTags.contains("type-agent")) {
            projectBadges.addToContributors(TypeBadge.AGENT, taggableObject.getTaggableType(), objectId);
        }
        if (removedTags.contains("type-ml") && !this.isML(taggableObject)) {
            projectBadges.removeFromContributors(TypeBadge.ML, taggableObject.getTaggableType(), objectId);
        }
        if (removedTags.contains("type-llm") && !this.isLLM(taggableObject)) {
            projectBadges.removeFromContributors(TypeBadge.LLM, taggableObject.getTaggableType(), objectId);
        }
        if (removedTags.contains("type-agent") && !this.isAgent(taggableObject)) {
            projectBadges.removeFromContributors(TypeBadge.AGENT, taggableObject.getTaggableType(), objectId);
        }
        this.saveBadgesIfNeeded(projectKey, projectBadges);
    }

    private void updateOnObjectEdit(@Nonnull TaggableObjectsService.TaggableObjectRef taggableObjectRef, TaggableObjectChangedEvent event) throws IOException {
        ExposedObjectsService.ObjectsExpositions objectExpositions;
        TaggableObjectsService.TaggableObject taggableObject;
        logger.debugV("Handling edit of taggable object %s in project %s", new Object[]{event.objectId, event.projectKey});
        List<String> addedTags = TaggableObjectDiffService.getAddedTags(event);
        List<String> removedTags = TaggableObjectDiffService.getRemovedTags(event);
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            taggableObject = this.taggableObjectsReadService.getOrNullUnsafe(taggableObjectRef);
            objectExpositions = this.exposedObjectsService.getObjectsExpositions(Set.of(taggableObjectRef));
        }
        ArrayList<String> listProjects = new ArrayList<String>(objectExpositions.projects.keySet());
        listProjects.add(taggableObject.getProjectKey());
        for (String curProject : listProjects) {
            this.syncBadgeOnEdit(curProject, addedTags, removedTags, taggableObject, new AnyLoc(taggableObject.getProjectKey(), taggableObject.getId()).getSmartName(curProject));
        }
    }

    private void updateOnObjectShare(@Nonnull TaggableObjectsService.TaggableObjectRef taggableObjectRef, JsonObject eventDetails) throws IOException {
        ProjectBadges projectBadges;
        String contextProjectKey;
        TaggableObjectsService.TaggableObject taggableObject;
        logger.debugV("Handling sharing of taggable object %s in project %s", new Object[]{taggableObjectRef.id, taggableObjectRef.projectKey});
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            taggableObject = this.taggableObjectsReadService.getOrNullUnsafe(taggableObjectRef);
            contextProjectKey = eventDetails.get("projectSharedTo").getAsString();
            projectBadges = this.projectBadgesDAO.read(contextProjectKey);
        }
        this.addObjectToBadgeContributorsIfNeeded(projectBadges, taggableObject, contextProjectKey);
        this.saveBadgesIfNeeded(contextProjectKey, projectBadges);
    }

    @VisibleForTesting
    void addObjectToBadgeContributorsIfNeeded(ProjectBadges projectBadges, TaggableObjectsService.TaggableObject taggableObject, String contextProjectKey) {
        String objectId = new AnyLoc(taggableObject.getProjectKey(), taggableObject.getId()).getSmartName(contextProjectKey);
        if (this.isML(taggableObject) || taggableObject.tags.contains("type-ml")) {
            projectBadges.addToContributors(TypeBadge.ML, taggableObject.getTaggableType(), objectId);
        }
        if (this.isLLM(taggableObject) || taggableObject.tags.contains("type-llm")) {
            projectBadges.addToContributors(TypeBadge.LLM, taggableObject.getTaggableType(), objectId);
        }
        if (this.isAgent(taggableObject) || taggableObject.tags.contains("type-agent")) {
            projectBadges.addToContributors(TypeBadge.AGENT, taggableObject.getTaggableType(), objectId);
        }
    }

    public boolean hasBadgesFile(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            boolean bl = this.projectBadgesDAO.exists(projectKey);
            return bl;
        }
    }

    public UsageSummaryModel.TypeBadgesReport getTypeBadgesReport_NT() {
        try {
            List<String> projectKeys;
            UsageSummaryModel.TypeBadgesReport report = new UsageSummaryModel.TypeBadgesReport();
            try (Transaction t = this.transactionService.beginRead();){
                projectKeys = this.projectsDAO.listProjectKeys();
            }
            for (String projectKey : projectKeys) {
                try {
                    List<TypeBadge> badges = this.listBadges(projectKey);
                    badges.forEach(badge -> report.nbProjectBadgesPerType.merge((TypeBadge)badge, 1, Integer::sum));
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to retrieve Type Badges for project %s", new Object[]{projectKey});
                }
            }
            return report;
        }
        catch (Exception e) {
            logger.warn((Object)"Could not compute report data for Type Badges", (Throwable)e);
            return null;
        }
    }

    private void saveBadgesIfNeeded(String projectKey, ProjectBadges projectBadges) throws IOException {
        ProjectBadges oldProjectBadges;
        logger.debugV("Saving badges file for project %s if needed", new Object[]{projectKey});
        try (Transaction t = this.transactionService.beginRead();){
            oldProjectBadges = this.projectBadgesDAO.getUnsafe(projectKey);
        }
        if (Objects.equals(oldProjectBadges, projectBadges)) {
            logger.debugV("No modification of the contributors of Type Badges for project %s, not saving", new Object[]{projectKey});
            return;
        }
        t = this.transactionService.beginWriteAsDSS();
        try {
            this.projectBadgesDAO.save(projectKey, projectBadges);
            if (!Objects.equals(oldProjectBadges.listBadges(), projectBadges.listBadges())) {
                this.pubSubService.publishAfterTransaction((DSSEvent)new ProjectTypeBadgesChangedEvent(projectKey));
            }
            t.commitV("Updated badges of project %s", new Object[]{projectKey});
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }
}

