/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.runtime;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.codestudio.CodeStudioCodes;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockRegistry;
import com.dataiku.dip.codestudio.blocks.component.LoadedPythonPluginCodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockDesc;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockParams;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class CodeStudioRuntimeManager
implements ApplicationListener<DSSStartedEvent> {
    @Autowired
    private FutureService futureService;
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.manager");

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.debug((Object)"Init Code Studio runtime manager");
                    File[] projects = CodeStudioRuntime.getWorkingDirBase().listFiles();
                    HashMap persistedStates = Maps.newHashMap();
                    if (projects != null) {
                        for (File project : projects) {
                            File[] codeStudios;
                            if (project == null || !project.exists() || !project.isDirectory()) {
                                logger.debug((Object)"/!\\ project folder for Code Studio runtimes deleted during cleanup");
                                continue;
                            }
                            for (File codeStudio : codeStudios = project.listFiles()) {
                                if (codeStudio == null || !codeStudio.exists() || !codeStudio.isDirectory()) {
                                    logger.debug((Object)"/!\\ Code Studio folder for Code Studio runtimes deleted during cleanup");
                                    continue;
                                }
                                String projectKey = project.getName();
                                String id = codeStudio.getName();
                                String fullId = String.format("%s.%s", projectKey, id);
                                persistedStates.put(fullId, CodeStudioRuntime.getPersistedState(codeStudio, projectKey, id));
                            }
                        }
                        logger.debug((Object)("Found " + persistedStates.size() + " states of Code Studio runtimes"));
                        for (Map.Entry entry : persistedStates.entrySet()) {
                            CodeStudioRuntime.CodeStudioPersistedState persistedState = (CodeStudioRuntime.CodeStudioPersistedState)entry.getValue();
                            AnyLoc loc = AnyLoc.resolveFull((String)entry.getKey());
                            if (!StringUtils.isNotBlank((String)persistedState.jobId) || CodeStudioRuntimeManager.this.futureService.getThread(persistedState.jobId) != null) continue;
                            try {
                                logger.debug((Object)("Handle old Code Studio runtime " + loc.getFullName()));
                                CodeStudioObject codeStudio = persistedState.codeStudio;
                                codeStudio.projectKey = loc.getProjectKey();
                                codeStudio.id = loc.getId();
                                CodeStudioRuntime runtime = new CodeStudioRuntime((AuthCtx)persistedState.authCtx, codeStudio);
                                runtime.loadFromPersistedState(persistedState);
                                if (runtime.shouldReattach()) {
                                    runtime.reattach();
                                    CodeStudioRuntimeManager.this.futureService.runFuture(runtime, 0L, new TypeToken<FutureResponse<Void>>(){});
                                    continue;
                                }
                                runtime.forceStopCodeStudio(persistedState);
                            }
                            catch (Exception e2) {
                                logger.warn((Object)("Unable to cleanup Code Studio runtime for " + loc.getFullName() + ", trying again with minimal identifiers"), (Throwable)e2);
                                try {
                                    CodeStudioObject codeStudio = new CodeStudioObject();
                                    codeStudio.projectKey = loc.getProjectKey();
                                    codeStudio.id = loc.getId();
                                    codeStudio.templateId = "__cleanup__";
                                    CodeStudioRuntime runtime = new CodeStudioRuntime((AuthCtx)DSSAuthCtx.newNone(), codeStudio);
                                    runtime.loadFromPersistedState(persistedState);
                                    runtime.forceStopCodeStudio(persistedState);
                                }
                                catch (Exception e3) {
                                    logger.warn((Object)("Unable to cleanup Code Studio runtime for " + loc.getFullName()), (Throwable)e3);
                                }
                            }
                        }
                    }
                    logger.debug((Object)"Done init Code Studio runtime manager");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init Code Studio runtime manager", (Throwable)e);
                }
            }
        }).start();
    }

    public CodeStudioRuntime getRuntimeOrNull(AuthCtx authCtx, CodeStudioObject codeStudio) throws IOException, InterruptedException {
        return this.getRuntimeOrNull(authCtx, codeStudio.projectKey, codeStudio.id);
    }

    public CodeStudioRuntime getRuntimeOrNull(AuthCtx authCtx, String projectKey, String id) throws IOException, InterruptedException {
        CodeStudioRuntime.CodeStudioPersistedState state = CodeStudioRuntime.getPersistedState(projectKey, id);
        CodeStudioRuntime runtime = null;
        if (state.state != null && state.state != CodeStudioRuntime.CodeStudioRuntimeState.STOPPED) {
            runtime = (CodeStudioRuntime)this.futureService.getThread(state.jobId);
            if (runtime != null) {
                return runtime;
            }
            logger.warn((Object)("Existing Code Studio in state " + String.valueOf((Object)state.state) + " listed but not monitored any more"));
            return null;
        }
        return null;
    }

    public CodeStudioRuntime.CodeStudioPersistedState getRunningStateOrNull(AuthCtx authCtx, CodeStudioObject codeStudio) throws IOException, InterruptedException {
        return this.getRunningStateOrNull(authCtx, codeStudio.projectKey, codeStudio.id);
    }

    public CodeStudioRuntime.CodeStudioPersistedState getRunningStateOrNull(AuthCtx authCtx, String projectKey, String id) throws IOException, InterruptedException {
        CodeStudioRuntime.CodeStudioPersistedState state = CodeStudioRuntime.getPersistedState(projectKey, id);
        CodeStudioRuntime runtime = null;
        if (state.state != null && state.state != CodeStudioRuntime.CodeStudioRuntimeState.STOPPED) {
            runtime = (CodeStudioRuntime)this.futureService.getThread(state.jobId);
            if (runtime != null) {
                return state;
            }
            logger.warn((Object)("Existing Code Studio in state " + String.valueOf((Object)state.state) + " listed but not monitored any more"));
            return null;
        }
        return null;
    }

    public CodeStudioRuntime.CodeStudioUIState getState(AuthCtx authCtx, CodeStudioObject codeStudio) throws IOException, InterruptedException {
        return this.getState(authCtx, codeStudio.projectKey, codeStudio.id);
    }

    public CodeStudioRuntime.CodeStudioUIState tryRestartServer(AuthCtx authCtx, CodeStudioObject codeStudio, String exposedLabel) throws Exception {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio.projectKey, codeStudio.id);
        CodeStudioRuntime.CodeStudioUIState state = this.getState(authCtx, codeStudio.projectKey, codeStudio.id);
        if (!state.state.equals((Object)CodeStudioRuntime.CodeStudioRuntimeState.RUNNING)) {
            return state;
        }
        String restartScript = this.getRestartScript(exposedLabel);
        if (restartScript != null) {
            JsonObject command = new JsonObject();
            command.addProperty("commandString", restartScript);
            command.addProperty("useShell", Boolean.valueOf(true));
            logger.info((Object)("Restarting exposed server designated by label: " + exposedLabel + "."));
            runtime.enqueueCommandAndWait(authCtx, "run_command_line", command);
        }
        return state;
    }

    public CodeStudioRuntime.CodeStudioUIState openFile(AuthCtx authCtx, CodeStudioRuntime runtime, CodeStudioObject codeStudio, String zone, String fileToOpen) throws Exception {
        if (StringUtils.isBlank((String)zone) || StringUtils.isBlank((String)fileToOpen)) {
            throw new IllegalArgumentException("zone and fileToOpen have to be defined to open a file in a Code Studio");
        }
        return this.openFileInEditors(runtime, codeStudio, this.getState(authCtx, codeStudio.projectKey, codeStudio.id), zone, fileToOpen);
    }

    private CodeStudioRuntime.CodeStudioUIState openFileInEditors(CodeStudioRuntime runtime, CodeStudioObject codeStudio, CodeStudioRuntime.CodeStudioUIState state, String zone, String fileToOpen) throws Exception {
        if (!state.state.equals((Object)CodeStudioRuntime.CodeStudioRuntimeState.RUNNING)) {
            return state;
        }
        return this.retrieveExposeIdeAndOpenFile(state, zone, fileToOpen, runtime);
    }

    private CodeStudioRuntime.CodeStudioUIState retrieveExposeIdeAndOpenFile(CodeStudioRuntime.CodeStudioUIState state, String zone, String fileToOpen, CodeStudioRuntime runtime) throws Exception {
        CodeStudioMeta.SyncZoneInstance syncZoneInstance = null;
        String workspaceRoot = "workspace_root";
        if (!zone.equals(workspaceRoot)) {
            syncZoneInstance = state.syncedZones.stream().filter(zoneInstance -> zoneInstance.zone.equals(zone)).findFirst().orElse(null);
        }
        if (syncZoneInstance != null || zone.equals(workspaceRoot)) {
            for (CodeStudioRuntime.CodeStudioExposedState currentExposed : state.exposed) {
                PythonPluginCodeStudioBlockDesc blockDesc = this.getOpenFileConf(currentExposed.label);
                if (blockDesc == null) continue;
                this.openFile(runtime, currentExposed, blockDesc, zone.equals(workspaceRoot) ? "/home/dataiku/workspace" : syncZoneInstance.pathInContainer, fileToOpen);
            }
        } else {
            logger.warn((Object)("No zone named " + zone + " was found!"));
        }
        return state;
    }

    private void openFile(CodeStudioRuntime runtime, CodeStudioRuntime.CodeStudioExposedState state, PythonPluginCodeStudioBlockDesc blockDesc, String pathInContainer, String fileToOpen) throws Exception {
        PythonPluginCodeStudioBlockDesc.PythonPluginCodeStudioBlockOpenFileConf openfileConf = blockDesc.openFileConfs.get(state.label);
        if (openfileConf.openFileScript != null) {
            JsonObject command = new JsonObject();
            command.addProperty("commandString", openfileConf.openFileScript + " \"" + pathInContainer + "\" \"" + fileToOpen + "\"");
            command.addProperty("useShell", Boolean.valueOf(true));
            logger.info((Object)("Opening file " + pathInContainer + "/" + fileToOpen + " in exposed app " + state.label));
            runtime.enqueueCommand("run_command_line", command);
        }
        if (openfileConf.openFileURL != null) {
            String url = openfileConf.openFileURL;
            PythonPluginCodeStudioBlockParams blockParams = runtime.getBlockConfig(state.exposedPort);
            if (blockParams != null && blockParams.config.has("openInPath")) {
                String zonePathRelativeToOpenInPath = pathInContainer.replace(blockParams.config.get("openInPath").getAsString(), "");
                url = url.replace("__RELATIVE_ZONE_PATH__", zonePathRelativeToOpenInPath);
            }
            state.url = url.replace("__ORIGINAL_URL__", state.url).replace("__FILE_PATH__", fileToOpen).replaceAll("/{2,}", "/");
        }
    }

    private PythonPluginCodeStudioBlockDesc getOpenFileConf(String exposeLabel) {
        Iterable<CodeStudioBlockMeta> codeStudioBlockMetas = CodeStudioBlockRegistry.getAllMeta();
        for (CodeStudioBlockMeta currentCodeStudioBlockMeta : codeStudioBlockMetas) {
            Map<String, PythonPluginCodeStudioBlockDesc.PythonPluginCodeStudioBlockOpenFileConf> openFileConfs;
            LoadedPythonPluginCodeStudioBlock blockDesc;
            if (!(currentCodeStudioBlockMeta instanceof PythonPluginCodeStudioBlockMeta) || (blockDesc = ((PythonPluginCodeStudioBlockMeta)currentCodeStudioBlockMeta).getDesc()) == null || blockDesc.desc == null || (openFileConfs = blockDesc.desc.openFileConfs) == null || !openFileConfs.containsKey(exposeLabel)) continue;
            return blockDesc.desc;
        }
        return null;
    }

    private String getRestartScript(String exposeLabel) {
        Iterable<CodeStudioBlockMeta> codeStudioBlockMetas = CodeStudioBlockRegistry.getAllMeta();
        for (CodeStudioBlockMeta currentCodeStudioBlockMeta : codeStudioBlockMetas) {
            String startScript;
            LoadedPythonPluginCodeStudioBlock blockDesc;
            if (!(currentCodeStudioBlockMeta instanceof PythonPluginCodeStudioBlockMeta) || (blockDesc = ((PythonPluginCodeStudioBlockMeta)currentCodeStudioBlockMeta).getDesc()) == null || blockDesc.desc == null || (startScript = blockDesc.desc.restartScript.get(exposeLabel)) == null) continue;
            return startScript;
        }
        return null;
    }

    public CodeStudioRuntime.CodeStudioUIState getState(AuthCtx authCtx, String projectKey, String id) throws IOException, InterruptedException {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, projectKey, id);
        if (runtime == null) {
            CodeStudioRuntime.CodeStudioPersistedState state = CodeStudioRuntime.getPersistedState(projectKey, id);
            return state != null ? new CodeStudioRuntime.CodeStudioUIState(state) : new CodeStudioRuntime.CodeStudioUIState();
        }
        return runtime.getUIState();
    }

    public FutureResponse<CodeStudioStartStopResult> restart(AuthCtx authCtx, CodeStudioObject codeStudio) throws Exception {
        CodeStudioRestartThread ft = new CodeStudioRestartThread(authCtx, codeStudio);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeStudioStartStopResult>>(){});
    }

    public FutureResponse<CodeStudioRuntime.CodeStudioUIState> stop(AuthCtx authCtx, CodeStudioObject codeStudio) throws Exception {
        CodeStudioStopThread ft = new CodeStudioStopThread(authCtx, codeStudio);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeStudioRuntime.CodeStudioUIState>>(){});
    }

    public CodeStudioRuntime.CodeStudioUIState stopAndWait(AuthCtx authCtx, CodeStudioObject codeStudio) throws IOException, InterruptedException {
        CodeStudioRuntime.CodeStudioPersistedState state = CodeStudioRuntime.getPersistedState(codeStudio);
        if (state.state == CodeStudioRuntime.CodeStudioRuntimeState.STOPPED) {
            return new CodeStudioRuntime.CodeStudioUIState(state);
        }
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            runtime = new CodeStudioRuntime(authCtx, codeStudio);
            runtime.loadFromPersistedState(state);
            logger.info((Object)("Stopping Code Studio " + codeStudio.getFullId() + " (force)"));
            runtime.forceStopCodeStudio(state);
        } else {
            logger.info((Object)("Stopping Code Studio " + codeStudio.getFullId()));
            runtime.stopCodeStudio(state);
            logger.info((Object)("Waiting for stop of Code Studio " + codeStudio.getFullId()));
            while (runtime.getUIState().state != CodeStudioRuntime.CodeStudioRuntimeState.STOPPED) {
                Thread.sleep(3000L);
            }
            logger.info((Object)("Done waiting for stop of Code Studio " + codeStudio.getFullId()));
        }
        return runtime.getUIState();
    }

    public CodeStudioRuntime.CodeStudioUIState startAndWait(AuthCtx authCtx, CodeStudioObject codeStudio, Consumer<CodeStudioRuntime> subFutureConsumer) throws Exception {
        CodeStudioRuntime runtime = new CodeStudioRuntime(authCtx, codeStudio);
        if (subFutureConsumer != null) {
            subFutureConsumer.accept(runtime);
        }
        this.futureService.runFuture(runtime, 0L, new TypeToken<FutureResponse<Void>>(){});
        logger.info((Object)("Waiting for start of Code Studio " + codeStudio.getFullId()));
        while (runtime.getPersistedState().state != CodeStudioRuntime.CodeStudioRuntimeState.RUNNING && !runtime.hasRun()) {
            Thread.sleep(3000L);
        }
        logger.info((Object)("Done waiting for start of Code Studio " + codeStudio.getFullId()));
        if (runtime.hasRun()) {
            runtime.throwExceptionIfAny();
            throw new IllegalStateException("Code Studio started but stopped immediately");
        }
        return runtime.getUIState();
    }

    public FutureResponse<List<CodeStudioRuntime.CodeStudioPersistedState>> stopAll(AuthCtx authCtx, String projectKey) throws Exception {
        CodeStudioStopAllThread ft = new CodeStudioStopAllThread(authCtx, projectKey);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<List<CodeStudioRuntime.CodeStudioPersistedState>>>(){});
    }

    public CodeStudioRuntime.CodeStudioRunInfo getRunInfo(AuthCtx authCtx, CodeStudioObject codeStudio) throws IOException, InterruptedException {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            CodeStudioRuntime.CodeStudioPersistedState state = CodeStudioRuntime.getPersistedState(codeStudio);
            CodeStudioRuntime.CodeStudioRunInfo info = state != null ? new CodeStudioRuntime.CodeStudioRunInfo(state) : new CodeStudioRuntime.CodeStudioRunInfo();
            File workingDir = CodeStudioRuntime.getWorkingDir(codeStudio);
            File logFile = new File(workingDir, "code_studio.log");
            if (logFile.exists() && logFile.length() > 0L) {
                info.logTail = DKUtils.smartTailFile((File)logFile, (int)200);
            } else {
                info.logTail = new SmartLogTail();
                info.logTail.appendLine("No log available, and Code Studio not running");
            }
            return info;
        }
        return runtime.getRunInfo();
    }

    public RemoteFileListing listContainerFiles(AuthCtx authCtx, CodeStudioObject codeStudio, String path) throws Exception {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            throw new IllegalStateException("Code Studio is not running");
        }
        RemoteFileListingCommand cmd = new RemoteFileListingCommand();
        cmd.path = path;
        return this.enqueueCommandAndPollAnswer(runtime, "list_files", cmd, data -> (RemoteFileListing)JSON.parse((byte[])data, RemoteFileListing.class));
    }

    public RemoteFilePreview previewContainerFile(AuthCtx authCtx, CodeStudioObject codeStudio, String path) throws Exception {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            throw new IllegalStateException("Code Studio is not running");
        }
        RemoteFilePreviewCommand cmd = new RemoteFilePreviewCommand();
        cmd.path = path;
        return this.enqueueCommandAndPollAnswer(runtime, "preview_file", cmd, data -> {
            RemoteFilePreview preview = (RemoteFilePreview)JSON.parse((byte[])data, RemoteFilePreview.class);
            preview.mime = DKUtils.guessMimeTypeFromExtension((String)preview.path);
            try {
                preview.stringContent = new String(Base64.decodeBase64((String)preview.content), StandardCharsets.UTF_8);
                preview.content = null;
            }
            catch (Exception e) {
                logger.info((Object)("Apparently not textual content : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            return preview;
        });
    }

    public FutureResponse<GitModel.MultiCommitDiffSummary> pullBundleFromCodeStudio(AuthCtx authCtx, final String zoneId, final CodeStudioObject codeStudio, boolean force) throws Exception {
        final CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            throw new IllegalStateException("Code Studio is not running");
        }
        final PullFromCodeStudioCommand cmd = new PullFromCodeStudioCommand();
        cmd.force = force;
        cmd.zone = zoneId;
        return this.futureService.runFuture(new SimpleFutureThread<GitModel.MultiCommitDiffSummary>(authCtx){

            @Override
            protected GitModel.MultiCommitDiffSummary compute() throws Exception {
                return CodeStudioRuntimeManager.this.enqueueCommandAndPollAnswer(runtime, "pull_bundle_from_code_studio", cmd, data -> {
                    if (((byte[])data).length == 0) {
                        logger.info((Object)"No conflict, pull done immediately");
                        return new GitModel.MultiCommitDiffSummary();
                    }
                    return (GitModel.MultiCommitDiffSummary)JSON.parse((byte[])data, GitModel.MultiCommitDiffSummary.class);
                });
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"pull_bundle_from_code_studio", (String)("Starting pulling bundle for  zone: " + zoneId + " from Code Studio " + codeStudio.id + " in project " + codeStudio.projectKey));
            }
        }, 200L, new TypeToken<FutureResponse<GitModel.MultiCommitDiffSummary>>(){});
    }

    public PushedToCodeStudioSummary pushBundleToCodeStudio(AuthCtx authCtx, String zoneId, CodeStudioObject codeStudio) throws Exception {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            throw new IllegalStateException("Code Studio is not running");
        }
        PushToCodeStudioCommand cmd = new PushToCodeStudioCommand();
        cmd.zone = zoneId;
        return this.enqueueCommandAndPollAnswer(runtime, "push_bundle_to_code_studio", cmd, data -> {
            if (((byte[])data).length == 0) {
                logger.info((Object)"Nothing done, returning empty result");
                return new PushedToCodeStudioSummary();
            }
            return (PushedToCodeStudioSummary)JSON.parse((byte[])data, PushedToCodeStudioSummary.class);
        });
    }

    private <T> T enqueueCommandAndPollAnswer(CodeStudioRuntime runtime, String cmdType, Object cmdParamas, Function<byte[], T> replyHandler) throws Exception {
        int commandNo = runtime.enqueueCommand(cmdType, JSON.toJsonObject((Object)cmdParamas));
        logger.info((Object)("Start waiting for " + cmdType + " response"));
        long st2 = System.currentTimeMillis();
        long timeout = ApplicationConfigurator.getParams().getLongParam("dip.codestudio.command_timeout", 600000L);
        do {
            byte[] data;
            if ((data = runtime.pollAnswer(commandNo)) != null) {
                logger.info((Object)"Response received");
                return replyHandler.apply(data);
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() < st2 + timeout);
        logger.info((Object)("Done waiting for " + cmdType + " response, none received"));
        throw new TimeoutException("Waiting for " + cmdType + " timeout");
    }

    public CheckConflictsResponse checkConflictsFromCodeStudio(AuthCtx authCtx, CodeStudioObject codeStudio, List<String> zoneIds) throws Exception {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            throw new IllegalStateException("Code Studio is not running");
        }
        JsonObject cmd = new JsonObject();
        for (String zoneId : zoneIds) {
            cmd.addProperty(zoneId, Boolean.valueOf(true));
        }
        return this.enqueueCommandAndPollAnswer(runtime, "check_conflicts", cmd, data -> {
            if (((byte[])data).length == 0) {
                logger.info((Object)"No conflict");
                return new CheckConflictsResponse();
            }
            return (CheckConflictsResponse)JSON.parse((byte[])data, CheckConflictsResponse.class);
        });
    }

    public ChangesResponse getChangesFromCodeStudio(AuthCtx authCtx, CodeStudioObject codeStudio) throws Exception {
        CodeStudioRuntime runtime = this.getRuntimeOrNull(authCtx, codeStudio);
        if (runtime == null) {
            throw new IllegalStateException("Code Studio is not running");
        }
        JsonObject cmd = new JsonObject();
        for (CodeStudioMeta.SyncZoneInstance zone : runtime.getUIState().syncedZones) {
            cmd.addProperty(zone.id, Boolean.valueOf(true));
        }
        return this.enqueueCommandAndPollAnswer(runtime, "get_changes", cmd, data -> {
            if (((byte[])data).length == 0) {
                logger.info((Object)"No conflict");
                return new ChangesResponse();
            }
            ChangesResponse response = (ChangesResponse)JSON.parse((byte[])data, ChangesResponse.class);
            return response;
        });
    }

    private class CodeStudioRestartThread
    extends SimpleFutureThread<CodeStudioStartStopResult>
    implements Consumer<CodeStudioRuntime> {
        private final CodeStudioObject codeStudio;
        private CodeStudioRuntime runtime;

        public CodeStudioRestartThread(AuthCtx authCtx, CodeStudioObject codeStudio) {
            super(authCtx);
            this.codeStudio = codeStudio;
        }

        @Override
        protected CodeStudioStartStopResult compute() throws Exception {
            FutureProgress.AutocloseableFutureProgressState state;
            CodeStudioStartStopResult ret = new CodeStudioStartStopResult();
            try {
                state = FutureProgress.pushAutoCloseableState((String)"Stop Code Studio");
                try {
                    CodeStudioRuntimeManager.this.stopAndWait(this.owner, this.codeStudio);
                }
                finally {
                    if (state != null) {
                        state.close();
                    }
                }
            }
            catch (Exception e) {
                ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_START, "Unable to stop previous run : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            try {
                state = FutureProgress.pushAutoCloseableState((String)"Start Code Studio");
                try {
                    CodeStudioRuntimeManager.this.startAndWait(this.owner, this.codeStudio, this);
                }
                finally {
                    if (state != null) {
                        state.close();
                    }
                }
            }
            catch (Exception e) {
                ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_START, "Unable to start run : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            ret.messages.summarize();
            ret.futureLog = this.getLog();
            return ret;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"code_studio_restart", (String)("Restart Code Studio " + this.codeStudio.id + " in project " + this.codeStudio.projectKey));
        }

        public synchronized SmartLogTail getLog() {
            if (this.runtime != null) {
                return this.runtime.getLog();
            }
            return null;
        }

        @Override
        public synchronized void accept(CodeStudioRuntime runtime) {
            this.runtime = runtime;
        }
    }

    private class CodeStudioStopThread
    extends SimpleFutureThread<CodeStudioRuntime.CodeStudioUIState> {
        private final CodeStudioObject codeStudio;

        public CodeStudioStopThread(AuthCtx authCtx, CodeStudioObject codeStudio) {
            super(authCtx);
            this.codeStudio = codeStudio;
        }

        @Override
        protected CodeStudioRuntime.CodeStudioUIState compute() throws Exception {
            return CodeStudioRuntimeManager.this.stopAndWait(this.owner, this.codeStudio);
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"code_studio_stop", (String)("Stop Code Studio " + this.codeStudio.id + " in project " + this.codeStudio.projectKey));
        }
    }

    private class CodeStudioStopAllThread
    extends SimpleFutureThread<List<CodeStudioRuntime.CodeStudioPersistedState>> {
        private final String projectKey;

        public CodeStudioStopAllThread(AuthCtx authCtx, String projectKey) {
            super(authCtx);
            this.projectKey = projectKey;
        }

        @Override
        protected List<CodeStudioRuntime.CodeStudioPersistedState> compute() throws Exception {
            HashMap persistedStates = Maps.newHashMap();
            File project = new File(CodeStudioRuntime.getWorkingDirBase(), this.projectKey);
            if (project.exists() && project.isDirectory()) {
                File[] codeStudios = project.listFiles();
                for (File codeStudio : codeStudios) {
                    if (codeStudio == null || !codeStudio.exists() || !codeStudio.isDirectory()) {
                        logger.debug((Object)"/!\\ Code Studio folder for Code Studio runtimes deleted during cleanup");
                        continue;
                    }
                    String id = codeStudio.getName();
                    String fullId = String.format("%s.%s", this.projectKey, id);
                    persistedStates.put(fullId, CodeStudioRuntime.getPersistedState(codeStudio, this.projectKey, id));
                }
            }
            logger.info((Object)("Found " + persistedStates.size() + " runtimes (running or stopped) for project"));
            ArrayList ret = Lists.newArrayList();
            for (Map.Entry entry : persistedStates.entrySet()) {
                AnyLoc loc = AnyLoc.resolveFull((String)entry.getKey());
                CodeStudioRuntime.CodeStudioPersistedState persistedState = (CodeStudioRuntime.CodeStudioPersistedState)entry.getValue();
                if (!StringUtils.isNotBlank((String)persistedState.jobId) || CodeStudioRuntimeManager.this.futureService.getThread(persistedState.jobId) == null) continue;
                try {
                    logger.debug((Object)("Cleanup Code Studio runtime " + loc.getFullName()));
                    CodeStudioRuntime runtime = (CodeStudioRuntime)CodeStudioRuntimeManager.this.futureService.getThread(persistedState.jobId);
                    runtime.stopCodeStudio(persistedState);
                    ret.add(persistedState);
                }
                catch (Exception e2) {
                    logger.warn((Object)("Unable to cleanup Code Studio runtime for " + loc.getFullName()), (Throwable)e2);
                }
            }
            return ret;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"code_studio_stop_all", (String)("Stop all Code Studios in project " + this.projectKey));
        }
    }

    public static class RemoteFileListingCommand {
        public String path;
    }

    public static class RemoteFileListing {
        public String path;
        public boolean exists;
        public String error;
        public List<RemoteFileEntry> children = Lists.newArrayList();
    }

    public static class RemoteFilePreviewCommand {
        public String path;
    }

    public static class RemoteFilePreview {
        public String path;
        public boolean exists;
        public boolean isFile;
        public long size;
        public long lastModified;
        public String error;
        public String content;
        public String mime;
        public String stringContent;
    }

    public static class PullFromCodeStudioCommand {
        public String zone;
        public boolean force;
    }

    public static class PushToCodeStudioCommand {
        public String zone;
    }

    public static class PushedToCodeStudioSummary {
        public long count;
        public long size;
    }

    public static class CheckConflictsResponse
    extends HashMap<String, GitModel.MultiCommitDiffSummary> {
        private static final long serialVersionUID = 1L;
    }

    public static class ChangesResponse
    extends HashMap<String, GitModel.DiffSummary> {
    }

    public static class CodeStudioStartStopResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public SmartLogTail futureLog = new SmartLogTail();
    }

    public static class RemoteFileEntry {
        public String name;
        public boolean isDirectory;
        public boolean isLink;
        public long size;
        public long lastModified;
    }
}

