/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.sql.KDBSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import org.apache.commons.lang.StringUtils;

public class KDBPlusConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public static final String connectionType = "KDBPlus";
    public Params params = new Params();

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public KDBSQLDialect getDialect() {
        return new KDBSQLDialect();
    }

    @Override
    String getDriver() {
        return "kx.jdbc.jdbc";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"KDB+ connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:q:" + this.params.host + ":" + this.params.port;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams {
        public String host;
        public int port;
        public String user;
        public String password;
        public boolean useURL;
        public String url;
        public String displayedUrl;
        public String fetchSize;

        @Override
        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            super.expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
            this.host = vc.expand(this.host);
            this.user = vc.expand(this.user);
            this.password = vc.expand(this.password);
            this.url = vc.expand(this.url);
            this.displayedUrl = vc.expand(this.displayedUrl);
            this.fetchSize = vc.expand(this.fetchSize);
        }
    }
}

