/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SageMakerConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
ConnectionWithAWSAuthCredentials {
    public Params params = new Params();
    public static final String SAGEMAKER_CONNECTION_TYPE = "SageMaker";

    public SageMakerConnection() {
        this.allowWrite = false;
        this.allowManagedDatasets = false;
        this.allowManagedFolders = false;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.params.secretKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.secretKey);
        }
        AbstractSQLConnection.CustomDatabaseProperty.encryptList(this.params.customAWSCredentialsProviderParams, cryptoService);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.secretKey = cryptoService.decryptIfEncrypted(this.params.secretKey);
        AbstractSQLConnection.CustomDatabaseProperty.decryptList(this.params.customAWSCredentialsProviderParams, cryptoService);
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.mustResolveAWSAuthOnDSSHost();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class));
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = this.getResolvedCredential(ctx.authCtx);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return SAGEMAKER_CONNECTION_TYPE;
    }

    @Override
    public ConnectionWithAWSAuthCredentials.IAWSAuthParams getIAWSAuthNonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public DSSConnection.CredentialsMode getCredentialsMode() {
        return this.credentialsMode;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        if (this.params.credentialsMode == ConnectionWithAWSAuthCredentials.AWSCredentialMode.KEYPAIR) {
            this.params.accessKey = vc.expand(this.params.accessKey);
            this.params.secretKey = vc.expand(this.params.secretKey);
        }
        this.params.regionOrEndpoint = vc.expand(this.params.regionOrEndpoint);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }

    @Override
    public boolean isADataStoringConnection() {
        return false;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testSageMaker_NT(authCtx, this);
    }

    public static class Params
    extends ConnectionWithAWSAuthCredentials.AWSAuthParams {
        public String regionOrEndpoint;
    }
}

