/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.LegacySQLTypeName;
import java.sql.SQLFeatureNotSupportedException;

public enum BigQueryDataType {
    STRING(12, 65535, 0, 65535),
    BYTES(-3, 65535, 0, 131070),
    INTEGER(-5, 19, 0, 20),
    FLOAT(8, 15, 0, 24),
    NUMERIC(2, 38, 9, 45),
    BIGNUMERIC(2, 76, 38, 84),
    BOOLEAN(16, 1, 0, 1),
    TIMESTAMP(93, 26, 6, 26),
    DATE(91, 10, 0, 10),
    TIME(92, 15, 6, 15),
    DATETIME(93, 26, 6, 26),
    GEOGRAPHY(1111, 65535, 0, 65535),
    JSON(1111, 65535, 0, 65535),
    INTERVAL(1111, 65535, 0, 65535),
    RECORD(2002, 65535, 0, 65535),
    ARRAY(2003, 65535, 0, 65535);

    public final int sqlType;
    public final int precision;
    public final int decimalDigits;
    public final int displaySize;

    public static BigQueryDataType fromType(String type) throws SQLFeatureNotSupportedException {
        switch (type) {
            case "STRING": {
                return STRING;
            }
            case "INTEGER": 
            case "INT64": {
                return INTEGER;
            }
            case "FLOAT": 
            case "FLOAT64": {
                return FLOAT;
            }
            case "BOOL": 
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "BYTES": {
                return BYTES;
            }
            case "NUMERIC": {
                return NUMERIC;
            }
            case "BIGNUMERIC": {
                return BIGNUMERIC;
            }
            case "TIMESTAMP": {
                return TIMESTAMP;
            }
            case "DATE": {
                return DATE;
            }
            case "TIME": {
                return TIME;
            }
            case "GEOGRAPHY": {
                return GEOGRAPHY;
            }
            case "DATETIME": {
                return DATETIME;
            }
            case "JSON": {
                return JSON;
            }
            case "INTERVAL": {
                return INTERVAL;
            }
            case "RECORD": 
            case "STRUCT": {
                return RECORD;
            }
            case "ARRAY": {
                return ARRAY;
            }
        }
        if (type.startsWith("STRUCT<")) {
            return RECORD;
        }
        if (type.startsWith("ARRAY<")) {
            return ARRAY;
        }
        if (type.startsWith("STRING(")) {
            return STRING;
        }
        if (type.startsWith("NUMERIC(")) {
            return NUMERIC;
        }
        if (type.startsWith("BIGNUMERIC(")) {
            return BIGNUMERIC;
        }
        if (type.startsWith("BYTES(")) {
            return BYTES;
        }
        throw new SQLFeatureNotSupportedException("Unsupported type: " + type);
    }

    public static BigQueryDataType fromType(LegacySQLTypeName type) throws SQLFeatureNotSupportedException {
        return BigQueryDataType.fromType(type.name());
    }

    private BigQueryDataType(int sqlType, int precision, int decimalDigits, int displaySize) {
        this.sqlType = sqlType;
        this.precision = precision;
        this.decimalDigits = decimalDigits;
        this.displaySize = displaySize;
    }
}

