/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.DirectoryFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SearchNotebooksDAO
extends AbstractStandardDAO<SearchNotebook> {
    private static final String PARAMS_JSON = "params.json";
    private final File rootFolder = ApplicationConfigurator.getBaseFolderF();

    @Override
    public List<SearchNotebook> list(String projectKey) throws IOException {
        return this.list(projectKey, false);
    }

    @Override
    public List<SearchNotebook> listUnsafe(String projectKey) throws IOException {
        return this.list(projectKey, true);
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.SEARCH_NOTEBOOK.toHumanReadableString();
    }

    @Override
    protected List<SearchNotebook> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<SearchNotebook> ret = new ArrayList<SearchNotebook>();
        RelFile notebooksFolder = this.notebooksFolder(projectKey);
        if (!t.isDirectory(notebooksFolder)) {
            return ret;
        }
        for (RelFile f : t.listFiles(notebooksFolder, (RelFileFilter)DirectoryFilter.containingFile((String)PARAMS_JSON))) {
            try {
                String id = f.getLeafName();
                SearchNotebook sn = (SearchNotebook)this.getMandatory(projectKey, id, unsafe);
                ret.add(sn);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error in search notebook file: " + String.valueOf(f)), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile notebooksFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(notebooksFolder = this.notebooksFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(notebooksFolder, (RelFileFilter)DirectoryFilter.containingFile((String)PARAMS_JSON)).size();
    }

    @Override
    protected SearchNotebook getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"SearchNotebook id is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile file = this.getDAOFile(projectKey, id);
        if (!t.isFile(file)) {
            return null;
        }
        SearchNotebook notebook = unsafe ? (SearchNotebook)t.readObjectUnsafe(file, SearchNotebook.class) : (SearchNotebook)t.readObject(file, SearchNotebook.class);
        notebook.projectKey = projectKey;
        notebook.id = id;
        return notebook;
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile folder = this.notebookFolder(projectKey, id);
        t.deleteDirectory(folder);
        File resultFolderFile = this.resultFolder(projectKey, id);
        if (resultFolderFile.isDirectory()) {
            FileUtils.deleteDirectory((File)resultFolderFile);
        }
    }

    public void copy(SearchNotebook nbk, SearchNotebook newNbk) throws Exception {
        this.save(newNbk);
        File oldResultFolder = this.resultFolder(nbk.projectKey, nbk.id);
        File newResultFolder = this.resultFolder(newNbk.projectKey, newNbk.id);
        if (oldResultFolder.isDirectory() && !newResultFolder.exists()) {
            DKUFileUtils.copyDirectory((File)oldResultFolder, (File)newResultFolder);
        }
    }

    private RelFile notebooksFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "notebooks", "search"});
    }

    private RelFile notebookFolder(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Notebook id is not specified");
        return this.notebooksFolder(projectKey).append(new String[]{id});
    }

    private File resultFolder(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Notebook id is not specified");
        return DKUFileUtils.getWithin((File)this.rootFolder, (String[])new String[]{"notebook_results", "search", projectKey, id});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        return this.getDAOFile(projectKey, id, PARAMS_JSON);
    }

    private RelFile getDAOFile(String projectKey, String id, String name) {
        return this.notebookFolder(projectKey, id).append(new String[]{name});
    }
}

