/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.ComputeImpactedInputPartitions;
import com.dataiku.dip.dataflow.ComputeImpactedOutputPartitions;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.commands.PartitionRefreshCommand;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.JobPrinter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ReverseJobUnprunedTreeComputer {
    private final Map<String, List<Partition>> datasetPartitionsCache = new HashMap<String, List<Partition>>();
    private final FlowGraph graph;
    private JobDef def;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.job.reverse");

    public ReverseJobUnprunedTreeComputer(FlowGraph graph) {
        this.graph = graph;
    }

    public Buildable checkBuildability(JobDef def) throws IOException {
        FlowGraphService fghs = (FlowGraphService)SpringUtils.getBean(FlowGraphService.class);
        if (fghs.hasAnyPartitioningInGraph(this.graph, def.projectKey)) {
            return Buildable.no("'Reverse' build (running downstream recipes) is not supported when Flow has some partitioning");
        }
        return Buildable.yes();
    }

    public Job compute(JobDef def) throws Exception {
        this.def = def;
        Buildable buildability = this.checkBuildability(def);
        if (!buildability.ok) {
            throw new IllegalArgumentException(buildability.reason);
        }
        ArrayList<ReverseActivity> leftmostReverseActivities = new ArrayList<ReverseActivity>();
        HashMap<String, ReverseActivity> alreadyProcessedRAs = new HashMap<String, ReverseActivity>();
        for (JobDef.ReverseJobStartingPoint rjsp : def.reverseStartingPoints) {
            leftmostReverseActivities.addAll(this.handleOneInput(rjsp, alreadyProcessedRAs));
        }
        logger.info((Object)"Finished recursing. Left-most activities are");
        leftmostReverseActivities.stream().forEach(ra -> logger.info((Object)(" " + ra.activity.id())));
        logger.info((Object)"Finished recursing. Flat dump of activities");
        alreadyProcessedRAs.values().stream().forEach(ra -> {
            logger.info((Object)(" " + ra.activity.id() + " (" + String.valueOf(ra) + ")"));
            ra.predecessors.stream().forEach(pred -> logger.info((Object)("    predecessor: " + pred.activity.id())));
            ra.successors.stream().forEach(succ -> logger.info((Object)("    successor  : " + succ.activity.id())));
        });
        JobActivity topLevelActivity = this.reverseGraph(leftmostReverseActivities);
        Job j = new Job(def, topLevelActivity);
        logger.info((Object)("Job computed: " + JobPrinter.print(j, 0)));
        return j;
    }

    public JobActivity reverseGraph(List<ReverseActivity> leftmostReverseActivities) {
        List<ReverseActivity> finalRAs = this.getFinalRAs(leftmostReverseActivities);
        JobActivity topLevelActivity = new JobActivity(null);
        HashMap<String, JobActivity> alreadyProcessed = new HashMap<String, JobActivity>();
        logger.info((Object)("Finish reverse, finalRAs (count: " + finalRAs.size() + ")"));
        if (finalRAs.size() > 1000) {
            logger.info((Object)" Full dump of finalRAs elided (too large)");
        } else {
            finalRAs.stream().forEach(ra -> logger.info((Object)(" " + ra.activity.id())));
        }
        HashSet<String> dependenciesOfTLA = new HashSet<String>();
        HashSet<String> currentlyVisitingStack = new HashSet<String>();
        for (ReverseActivity finalRA : finalRAs) {
            currentlyVisitingStack.add(finalRA.activity.id());
            this.resolveJobActivityFromRARec(0, finalRA, alreadyProcessed, currentlyVisitingStack);
            currentlyVisitingStack.remove(finalRA.activity.id());
            String id = finalRA.activity.id();
            if (dependenciesOfTLA.contains(id)) continue;
            topLevelActivity.dependencies.add(finalRA.activity);
            dependenciesOfTLA.add(id);
        }
        assert (currentlyVisitingStack.isEmpty());
        for (JobActivity ja : topLevelActivity.dependencies) {
            ja.topLevelActivity = true;
        }
        return topLevelActivity;
    }

    private void resolveJobActivityFromRARec(int depth, ReverseActivity ra, Map<String, JobActivity> alreadyProcessed, Set<String> currentlyVisitingStack) {
        if (ra.activity != null && alreadyProcessed.containsKey(ra.activity.id())) {
            return;
        }
        logger.info((Object)(this.prefix(depth) + "resolveJAFromRARec on ra=" + ra.activity.id()));
        ra.activity.skipExplicitOrWriteProtected = this.shouldActivityBeSkipped(ra.activity.getSubgraph());
        if (ra.activity.skipExplicitOrWriteProtected) {
            logger.info((Object)("Activity contains at least one 'Explicit Rebuild Only' or 'Write-protected'. It will be skipped: " + ra.activity.id()));
        }
        for (ReverseActivity predecessor : ra.predecessors) {
            logger.info((Object)(this.prefix(depth) + "recurse on predecessor: " + predecessor.activity.id()));
            if (currentlyVisitingStack.contains(predecessor.activity.id())) {
                logger.warnV("Predecessor %s already visited in same stack - Loop in Flow", new Object[]{predecessor.activity.id()});
                continue;
            }
            currentlyVisitingStack.add(predecessor.activity.id());
            this.resolveJobActivityFromRARec(depth + 1, predecessor, alreadyProcessed, currentlyVisitingStack);
            currentlyVisitingStack.remove(predecessor.activity.id());
            ra.activity.dependencies.add(predecessor.activity);
        }
        logger.info((Object)(this.prefix(depth) + "added " + ra.activity.dependencies.size() + " dependencies to activity " + ra.activity.id()));
        if (ra.activity != null) {
            alreadyProcessed.put(ra.activity.id(), ra.activity);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean shouldActivityBeSkipped(RunnableSubgraph subgraph) {
        if (!(subgraph instanceof RecipeRunnableSubgraph)) ** GOTO lbl-1000
        recipeRunnableSubgraph = (RecipeRunnableSubgraph)subgraph;
        if (this.def.reverseStartingPoints.stream().anyMatch((Predicate<JobDef.ReverseJobStartingPoint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$shouldActivityBeSkipped$5(com.dataiku.dip.dataflow.RecipeRunnableSubgraph com.dataiku.dip.coremodel.JobDef$ReverseJobStartingPoint ), (Lcom/dataiku/dip/coremodel/JobDef$ReverseJobStartingPoint;)Z)((RecipeRunnableSubgraph)recipeRunnableSubgraph))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isRecipeAReverseStartingPoint = v0;
        rebuildBehaviorsInTheTargetsThatCanSkipActivity = isRecipeAReverseStartingPoint != false ? Set.of(SerializedDataset.RebuildBehavior.WRITE_PROTECT) : Set.of(SerializedDataset.RebuildBehavior.EXPLICIT, SerializedDataset.RebuildBehavior.WRITE_PROTECT);
        return this.containsTargetWithAnyRebuildBehaviors(subgraph, rebuildBehaviorsInTheTargetsThatCanSkipActivity);
    }

    private boolean containsTargetWithAnyRebuildBehaviors(RunnableSubgraph subgraph, Set<SerializedDataset.RebuildBehavior> rebuildBehaviorSet) {
        return subgraph.getTargets().stream().anyMatch(target -> {
            try {
                SerializedDataset.RebuildBehavior rebuildBehavior = target.getRebuildBehavior();
                return rebuildBehaviorSet.stream().anyMatch(rebuildBehavior::equals);
            }
            catch (IOException ignored) {
                return false;
            }
        });
    }

    private List<ReverseActivity> getFinalRAs(List<ReverseActivity> leftmostReverseActivities) {
        HashMap<String, ReverseActivity> finals = new HashMap<String, ReverseActivity>();
        HashSet<String> alreadyVisited = new HashSet<String>();
        HashSet<String> currentlyVisitingStack = new HashSet<String>();
        for (ReverseActivity ra : leftmostReverseActivities) {
            currentlyVisitingStack.add(ra.activity.id());
            this.getFinalRAsRec(0, ra, finals, alreadyVisited, currentlyVisitingStack);
            currentlyVisitingStack.remove(ra.activity.id());
        }
        assert (currentlyVisitingStack.isEmpty());
        return Lists.newArrayList(finals.values());
    }

    private void getFinalRAsRec(int depth, ReverseActivity current, Map<String, ReverseActivity> out, Set<String> alreadyVisited, Set<String> currentlyVisitingStack) {
        String currentId = current.activity.id();
        if (alreadyVisited.contains(currentId)) {
            return;
        }
        if (current.successors.size() == 0) {
            out.put(currentId, current);
        } else {
            for (ReverseActivity successor : current.successors) {
                if (currentlyVisitingStack.contains(successor.activity.id())) {
                    logger.warnV("Activity already being visited: %s - loop in Flow", new Object[]{successor.activity.id()});
                    continue;
                }
                currentlyVisitingStack.add(successor.activity.id());
                this.getFinalRAsRec(depth + 1, successor, out, alreadyVisited, currentlyVisitingStack);
                currentlyVisitingStack.remove(successor.activity.id());
            }
        }
        alreadyVisited.add(currentId);
    }

    private String prefix(int depth) {
        return IntStream.range(0, depth).mapToObj(x -> "  ").collect(Collectors.joining());
    }

    private List<ReverseActivity> handleOneInput(JobDef.ReverseJobStartingPoint startingPoint, Map<String, ReverseActivity> alreadyProcessedRAs) throws Exception {
        AnyLoc loc = new AnyLoc(startingPoint.projectKey, startingPoint.id);
        GraphNode node = this.graph.getNode(loc.getFullName());
        if (node == null) {
            throw new IllegalArgumentException("Could not find anything in flow for: " + loc.getFullName());
        }
        if (node instanceof FlowComputable) {
            return this.handleComputableRec(0, (FlowComputable)node, null, alreadyProcessedRAs);
        }
        ReverseActivityWithStatus raForRunnable = this.handleRunnableRec(0, (FlowRunnable)node, alreadyProcessedRAs);
        assert (!raForRunnable.wasAlreadyProcessed);
        ArrayList<ReverseActivity> ras = new ArrayList<ReverseActivity>();
        if (raForRunnable != null) {
            ras.add(raForRunnable.ra);
        }
        return ras;
    }

    private ReverseActivityWithStatus handleRunnableRec(int depth, FlowRunnable runnable, Map<String, ReverseActivity> alreadyProcessedRAs) throws Exception {
        JobActivity jobActivity;
        ReverseActivityWithStatus ret = new ReverseActivityWithStatus();
        logger.info((Object)(this.prefix(depth) + "Handling runnable " + runnable.getFullId()));
        ReverseActivity raForRunnable = new ReverseActivity();
        if (runnable instanceof FlowRecipe) {
            FlowRecipe recipe = (FlowRecipe)runnable;
            logger.info((Object)(this.prefix(depth) + "It's a recipe: " + recipe.getFullId()));
            if (RecipeRegistry.getMeta(recipe.getModel()).isContinuous()) {
                ret.cancelledBecauseNotRunnable = true;
                return ret;
            }
            RecipeRunnableSubgraph realSubgraph = new RecipeRunnableSubgraph(recipe);
            jobActivity = new JobActivity(realSubgraph);
            List<GraphNode> recipeSuccessors = recipe.getSuccessors().stream().filter(FlowComputable.class::isInstance).toList();
            if (recipeSuccessors.isEmpty()) {
                logger.warn((Object)"Did not run recipe %s because it has no output".formatted(recipe.getFullId()));
                ret.cancelledBecauseNotRunnable = true;
                return ret;
            }
            FlowComputable firstOutputComputable = (FlowComputable)recipeSuccessors.get(0);
            PartitionRefreshCommand command = new PartitionRefreshCommand(firstOutputComputable, Partition.newNP());
            DatasetsDAO dao = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
            Logger.getLogger((String)"dku.flow.compute.op").setLevel(Level.OFF);
            Logger.getLogger((String)"dku.flow.compute.ip").setLevel(Level.OFF);
            new ComputeImpactedOutputPartitions(dao, command, jobActivity.getSubgraph()).compute();
            if (!recipe.isGenerator() && recipe.getPredecessors().size() > 0) {
                ComputeImpactedInputPartitions ci = new ComputeImpactedInputPartitions(TransactionContext.retrieveWrite().getUser(), realSubgraph, this.datasetPartitionsCache);
                SpringUtils.getInstance().autowire((Object)ci);
                ci.compute();
            }
        } else {
            if (runnable instanceof FlowImplicitRecipe) {
                throw new Exception("an implicit recipe is not expected here: " + String.valueOf(runnable.getClass()) + ": " + runnable.getFullId());
            }
            throw new Exception("unsupported type of runnable for downwards build: " + String.valueOf(runnable.getClass()) + ": " + runnable.getFullId());
        }
        raForRunnable.activity = jobActivity;
        String id = raForRunnable.activity.id();
        if (alreadyProcessedRAs.containsKey(id)) {
            logger.info((Object)(this.prefix(depth) + "This activity is already processed: " + id + ", not recursing, and not returning it"));
            ret.ra = alreadyProcessedRAs.get(id);
            ret.wasAlreadyProcessed = true;
            return ret;
        }
        alreadyProcessedRAs.put(id, raForRunnable);
        for (GraphNode graphNode : runnable.getSuccessors()) {
            if (!(graphNode instanceof FlowComputable)) continue;
            this.handleComputableRec(depth + 1, (FlowComputable)graphNode, raForRunnable, alreadyProcessedRAs);
        }
        ret.ra = raForRunnable;
        return ret;
    }

    private List<ReverseActivity> handleComputableRec(int depth, FlowComputable computable, ReverseActivity raThatBuiltThisComputable, Map<String, ReverseActivity> alreadyProcessedRAs) throws Exception {
        logger.info((Object)(this.prefix(depth) + "Handling computable: " + String.valueOf(computable)));
        ArrayList<ReverseActivity> ras = new ArrayList<ReverseActivity>();
        for (GraphNode graphNode : computable.getSuccessors()) {
            if (graphNode instanceof FlowRunnable) {
                List<ReverseActivity> rasForSuccessorOfImplicitRecipe;
                FlowRunnable runnable = (FlowRunnable)graphNode;
                logger.info((Object)(this.prefix(depth) + " computable " + String.valueOf(computable) + " has successor " + runnable.getFullId()));
                if (!runnable.getProjectKey().equals(this.def.projectKey)) {
                    logger.info((Object)(this.prefix(depth) + " successor runnable is not in the same project key, stopping recursion"));
                    continue;
                }
                if (runnable instanceof FlowImplicitRecipe) {
                    logger.info((Object)(this.prefix(depth) + " successor is an implicit recipe"));
                    for (GraphNode graphNode2 : runnable.getSuccessors()) {
                        if (!(graphNode2 instanceof FlowComputable)) continue;
                        logger.info((Object)(this.prefix(depth) + " processing computable successor of the implicit recipe: " + graphNode2.getFullId()));
                        rasForSuccessorOfImplicitRecipe = this.handleComputableRec(depth + 1, (FlowComputable)graphNode2, raThatBuiltThisComputable, alreadyProcessedRAs);
                        logger.info((Object)(this.prefix(depth) + " processing computable successor of the implicit recipe generated ras:" + rasForSuccessorOfImplicitRecipe.size()));
                        ras.addAll(rasForSuccessorOfImplicitRecipe);
                    }
                    continue;
                }
                if (runnable instanceof FlowLabelingTask) {
                    logger.info((Object)(this.prefix(depth) + " successor is a labeling task"));
                    for (GraphNode graphNode3 : runnable.getSuccessors()) {
                        if (!(graphNode3 instanceof FlowComputable)) continue;
                        logger.info((Object)(this.prefix(depth) + " processing computable successor of the labeling task: " + graphNode3.getFullId()));
                        rasForSuccessorOfImplicitRecipe = this.handleComputableRec(depth + 1, (FlowComputable)graphNode3, raThatBuiltThisComputable, alreadyProcessedRAs);
                        logger.info((Object)(this.prefix(depth) + " processing computable successor of the labeling task generated ras:" + rasForSuccessorOfImplicitRecipe.size()));
                        ras.addAll(rasForSuccessorOfImplicitRecipe);
                    }
                    continue;
                }
                ReverseActivityWithStatus raWithStatusForRunnable = this.handleRunnableRec(depth + 1, runnable, alreadyProcessedRAs);
                if (raWithStatusForRunnable.cancelledBecauseNotRunnable) {
                    logger.info((Object)(this.prefix(depth) + " RAWS was built for successor" + runnable.getFullId() + ": cancelled because not runnable"));
                    continue;
                }
                logger.info((Object)(this.prefix(depth) + " RAWS was built for successor" + runnable.getFullId() + ": id=" + raWithStatusForRunnable.ra.activity.id() + " already=" + raWithStatusForRunnable.wasAlreadyProcessed));
                if (raThatBuiltThisComputable != null) {
                    logger.info((Object)(this.prefix(depth) + " add successor of " + raThatBuiltThisComputable.activity.id() + ": " + raWithStatusForRunnable.ra.activity.id()));
                    raThatBuiltThisComputable.successors.add(raWithStatusForRunnable.ra);
                    logger.info((Object)(this.prefix(depth) + " add predecessor of " + raWithStatusForRunnable.ra.activity.id() + " (" + String.valueOf(raWithStatusForRunnable.ra) + "): " + raThatBuiltThisComputable.activity.id()));
                    raWithStatusForRunnable.ra.predecessors.add(raThatBuiltThisComputable);
                }
                if (raWithStatusForRunnable.wasAlreadyProcessed) continue;
                ras.add(raWithStatusForRunnable.ra);
                continue;
            }
            throw new Error("successor of a computable is not a runnable !?, successor is " + String.valueOf(graphNode) + "  id:" + graphNode.getFullId());
        }
        return ras;
    }

    private static /* synthetic */ boolean lambda$shouldActivityBeSkipped$5(RecipeRunnableSubgraph recipeRunnableSubgraph, JobDef.ReverseJobStartingPoint reverseJobStartingPoint) {
        return Objects.equals(reverseJobStartingPoint.id, recipeRunnableSubgraph.getRecipe().getId());
    }

    public static class Buildable {
        boolean ok;
        String reason;

        public static Buildable yes() {
            Buildable u = new Buildable();
            u.ok = true;
            return u;
        }

        public static Buildable no(String reason) {
            Buildable u = new Buildable();
            u.ok = false;
            u.reason = reason;
            return u;
        }
    }

    static class ReverseActivity {
        JobActivity activity;
        List<ReverseActivity> predecessors = new ArrayList<ReverseActivity>();
        List<ReverseActivity> successors = new ArrayList<ReverseActivity>();

        ReverseActivity() {
        }
    }

    static class ReverseActivityWithStatus {
        ReverseActivity ra;
        boolean cancelledBecauseNotRunnable;
        boolean wasAlreadyProcessed;

        ReverseActivityWithStatus() {
        }
    }
}

