/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.cde.ICDEImageBuilderService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginExtraInfo;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CDEImageBuilderService
implements ICDEImageBuilderService {
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    private static Logger logger = Logger.getLogger((String)"dku.cde.builder.service");

    @Override
    public void buildIfNeededOnPluginCodeEnvChange(String pluginId, DKUtils.SmartLogTailBuilder logTailBuilder, InfoMessage.InfoMessages messages) throws IOException, InterruptedException {
        if (this.shouldRebuildCDEOnPluginCodeEnvChange(pluginId)) {
            BaseImageBuilder builder = new BaseImageBuilder(ContainerExecUtils.BaseImageType.CDE_PLUGINS, new BaseImageBuilder.BaseImageBuildOptions(), logTailBuilder, true, true);
            builder.build(messages);
        }
    }

    public boolean shouldRebuildCDEOnPluginChange(String pluginId, boolean wasExcludedFromCDE, boolean isUpdate) {
        InstalledPluginDesc desc = this.pluginsRegistryService.getInstalledDesc(pluginId);
        if (!isUpdate && desc.codeEnvLang == CodeEnvModel.EnvLang.PYTHON) {
            return false;
        }
        if (isUpdate && wasExcludedFromCDE) {
            return false;
        }
        return CDEImageBuilderService.shouldRebuildCDE(desc);
    }

    public boolean shouldRebuildCDEOnPluginCodeEnvChange(String pluginId) {
        InstalledPluginDesc desc = this.pluginsRegistryService.getInstalledDesc(pluginId);
        if (desc == null) {
            return false;
        }
        return CDEImageBuilderService.shouldRebuildCDE(desc);
    }

    private static boolean shouldRebuildCDE(InstalledPluginDesc desc) {
        ContainerSettings containerSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().containerSettings;
        boolean isAutoRebuildActivated = containerSettings.autoRebuildCDEImageOnPluginChange;
        boolean hasPluginSupport = containerSettings.cdePluginSupport;
        boolean isCDEActivated = containerSettings.cdeEnabled;
        if (!isAutoRebuildActivated) {
            return false;
        }
        if (!isCDEActivated) {
            return false;
        }
        if (!hasPluginSupport) {
            return false;
        }
        boolean hasRequestedCDEBaseImage = StringUtils.isNotBlank((String)containerSettings.cdeBaseImage);
        if (!CDEImageBuilderService.isCDEBuilt() && !hasRequestedCDEBaseImage) {
            logger.info((Object)"No cde image found or requested");
            return false;
        }
        PluginExtraInfo extraInfo = new PluginExtraInfo(desc);
        return !desc.settings.excludedFromCDE && desc.origin != InstalledPluginDesc.PluginOrigin.DEV && extraInfo.usefulForCDE;
    }

    private static boolean isCDEBuilt() {
        ContainerExecImagesHelper.CDEImages cdeImages = ContainerExecImagesHelper.getCDEImages();
        return cdeImages.isBaseBuilt() || cdeImages.isPluginsBuilt();
    }
}

