/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.filter;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.refine.expr.functions.date.DateTrunc;
import com.google.refine.expr.functions.date.Inc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FilterDescUtils {
    public static final String CURRENT_VALUE_SUFFIX = "_cur";
    public static final String PREVIOUS_VALUE_SUFFIX = "_prev";

    public static FilterDesc makeFilterOfExpression(String expression) {
        FilterDesc ret = new FilterDesc();
        ret.expression = expression;
        ret.enabled = true;
        ret.uiData = new FilterDesc.FilterUiData();
        ret.uiData.mode = "CUSTOM";
        return ret;
    }

    public static void expandExpressionIfNeeded(FilterDesc filter, VariablesContext vc) {
        if (filter.expression != null) {
            filter.expression = vc.expand(filter.expression);
            filter.expressionVariablesContext = vc;
        }
    }

    public static String getFilterRepr(FilterDesc filter) {
        if (filter == null) {
            return null;
        }
        if (!filter.enabled) {
            return "disabled";
        }
        if (filter.uiData != null) {
            switch (filter.uiData.mode) {
                case "CUSTOM": 
                case "SQL": 
                case "ES_QUERY_STRING": {
                    return filter.expression;
                }
            }
            try {
                return FilterDescUtils.getGrelExpression(filter);
            }
            catch (Exception e) {
                return "untranslatable expression";
            }
        }
        return filter.expression;
    }

    public static boolean willFilter(FilterDesc filter) {
        if (filter == null || !filter.enabled) {
            return false;
        }
        if (filter.uiData != null) {
            switch (filter.uiData.mode) {
                case "SQL": 
                case "CUSTOM": 
                case "ES_QUERY_STRING": {
                    return StringUtils.isNotBlank((String)filter.expression);
                }
            }
            return filter.uiData.conditions.size() > 0;
        }
        return StringUtils.isNotBlank((String)filter.expression);
    }

    public static void expand(FilterDesc filter, VariablesContext vc) {
        if (filter != null) {
            filter.expressionVariablesContext = vc;
            if (StringUtils.isNotBlank((String)filter.expression)) {
                filter.expression = vc.expand(filter.expression);
            }
            if (filter.uiData != null && filter.uiData.conditions != null) {
                for (FilterDesc.FilterUiCondition condition : filter.uiData.conditions) {
                    FilterDescUtils.expandCondition(condition, vc);
                }
            }
        }
    }

    private static void expandCondition(FilterDesc.FilterUiCondition condition, VariablesContext vc) {
        condition.date = vc.expand(condition.date);
        condition.time = vc.expand(condition.time);
        condition.date2 = vc.expand(condition.date2);
        condition.time2 = vc.expand(condition.time2);
        condition.col = vc.expand(condition.col);
        condition.input = vc.expand(condition.input);
        condition.string = vc.expand(condition.string);
        if (condition.subCondition != null) {
            FilterDescUtils.expand(condition.subCondition, vc);
        }
    }

    public static void expand(List<ComputedColumn> computedColumns, VariablesContext vc) {
        if (computedColumns != null) {
            for (ComputedColumn cc : computedColumns) {
                if (!StringUtils.isNotBlank((String)cc.expr)) continue;
                cc.expr = vc.expand(cc.expr);
                cc.exprVariablesContext = vc;
            }
        }
    }

    public static void checkAstWrtSchema(FilterDesc filter, Schema schema) {
        if (filter.uiData != null && FilterDesc.isAstMode((String)filter.uiData.mode)) {
            for (FilterDesc.FilterUiCondition condition : filter.uiData.conditions) {
                FilterDescUtils.checkAstWrtSchema(condition, schema);
            }
        }
    }

    private static void checkAstWrtSchema(FilterDesc.FilterUiCondition condition, Schema schema) {
        if (condition.subCondition != null) {
            FilterDescUtils.checkAstWrtSchema(condition.subCondition, schema);
            return;
        }
        if (StringUtils.isBlank((String)condition.input)) {
            throw new IllegalArgumentException("Filtered column left blank");
        }
        if (!schema.hasColumn(condition.input)) {
            throw new IllegalArgumentException(String.format("Column '%s' is referenced in filter, but doesn't exist", condition.input));
        }
        switch (FilterDesc.FilterUiOperator.fromRepr((String)condition.operator)) {
            case EMPTY_ARRAY: 
            case NOT_EMPTY_ARRAY: 
            case CONTAINS_ARRAY: 
            case NOT_CONTAINS_ARRAY: 
            case NOT_EMPTY: 
            case EMPTY: 
            case NOT_EMPTY_STRING: 
            case EMPTY_STRING: 
            case IS_TRUE: 
            case IS_FALSE: 
            case EQUALS_STRING: 
            case EQUALS_CASE_INSENSITIVE_STRING: 
            case NOT_EQUALS_STRING: 
            case EQUALS_NUMBER: 
            case NOT_EQUALS_NUMBER: 
            case GREATER_NUMBER: 
            case LESS_NUMBER: 
            case GREATER_OR_EQUAL_NUMBER: 
            case LESS_OR_EQUAL_NUMBER: 
            case BETWEEN_NUMBER: 
            case NOT_BETWEEN_NUMBER: 
            case EQUALS_DATE: 
            case GREATER_OR_EQUAL_DATE: 
            case GREATER_DATE: 
            case LESS_DATE: 
            case LESS_OR_EQUAL_DATE: 
            case BETWEEN_DATE: 
            case CONTAINS_STRING: 
            case CONTAINS_CASE_INSENSITIVE_STRING: 
            case NOT_CONTAINS_STRING: 
            case NOT_CONTAINS_CASE_INSENSITIVE_STRING: 
            case REGEX: 
            case GEO_WITHIN: 
            case GEO_CONTAINS: 
            case IN_ANY_OF_STRING: 
            case IN_NONE_OF_STRING: 
            case IN_ANY_OF_NUMBER: 
            case IN_NONE_OF_NUMBER: 
            case IN_ANY_OF_DATE: 
            case IN_NONE_OF_DATE: 
            case IN_ANY_OF_ENUM: 
            case IN_NONE_OF_ENUM: 
            case ARRAY_CONTAINS_ANY_ENUM: 
            case ARRAY_CONTAINS_NONE_ENUM: 
            case ARRAY_CONTAINS_ALL_ENUM: {
                return;
            }
            case SAME: 
            case DIFFERENT: 
            case EQUALS_COL: 
            case NOT_EQUALS_COL: 
            case GREATER_COL: 
            case LESS_COL: 
            case GREATER_OR_EQUAL_COL: 
            case LESS_OR_EQUAL_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new IllegalArgumentException("Condition column left blank");
                }
                if (!schema.hasColumn(condition.col)) {
                    throw new IllegalArgumentException(String.format("Column '%s' is referenced in filter condition, but doesn't exist", condition.col));
                }
                return;
            }
        }
        throw new NotImplementedException();
    }

    public static ExpressionBuilder translateAstToSql(FilterDesc filter, Dataset inputDataset, boolean translateFully, SQLDialect dialect) {
        return FilterDescUtils.translateAstToSql(filter, inputDataset, translateFully, new Schema(), dialect);
    }

    public static ExpressionBuilder translateAstToSql(FilterDesc filter, Dataset inputDataset, boolean translateFully, Schema currentSchema, SQLDialect dialect) {
        boolean and;
        if (filter.uiData.mode.equals("&&")) {
            and = true;
        } else if (filter.uiData.mode.equals("||")) {
            and = false;
        } else {
            throw new IllegalArgumentException("Invalid mode for combining conditions : " + filter.uiData.mode);
        }
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        ArrayList conditions = Lists.newArrayList();
        try {
            for (FilterDesc.FilterUiCondition condition : filter.uiData.conditions) {
                conditions.add(FilterDescUtils.translateConditionToExpression(condition, ef, inputDataset, translateFully, currentSchema, dialect));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Cannot translate filter to SQL : " + e.getMessage(), e);
        }
        if (conditions.size() == 0) {
            throw new IllegalArgumentException("A Filter must have at least one condition");
        }
        if (conditions.size() == 1) {
            return (ExpressionBuilder)conditions.get(0);
        }
        return and ? ef.and(conditions.toArray(new ExpressionBuilder[0])) : ef.or(conditions.toArray(new ExpressionBuilder[0]));
    }

    public static String translateAstToGrel(FilterDesc filter) throws Exception {
        return FilterDescUtils.translateAstToGrel(filter, false);
    }

    public static String translateAstToGrel(FilterDesc filter, boolean sortConditionsAlphabetically) throws Exception {
        if (filter.uiData.conditions.size() == 0) {
            throw new Exception("A filter must have at least one condition");
        }
        boolean and = false;
        if (filter.uiData.mode.equals("&&")) {
            and = true;
        } else if (filter.uiData.mode.equals("||")) {
            and = false;
        } else if (filter.uiData.conditions.size() > 1) {
            throw new Exception("Invalid filter mode for combining conditions : " + filter.uiData.mode);
        }
        ArrayList conditions = Lists.newArrayList();
        try {
            for (FilterDesc.FilterUiCondition condition : filter.uiData.conditions) {
                conditions.add(FilterDescUtils.translateConditionToGrel(condition));
            }
        }
        catch (Throwable e) {
            throw new Exception("Cannot translate filter to DSS formula : " + e.getMessage(), e);
        }
        if (conditions.size() == 1) {
            return (String)conditions.get(0);
        }
        if (sortConditionsAlphabetically) {
            Collections.sort(conditions);
        }
        return "( " + Joiner.on((String)(and ? " ) && ( " : " ) || ( ")).join((Iterable)conditions) + " )";
    }

    public static String getGrelQuotedString(String str) {
        if (StringUtils.isBlank((String)str)) {
            return "''";
        }
        return "'" + str.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'") + "'";
    }

    private static String translateConditionToGrel(FilterDesc.FilterUiCondition condition) throws Exception {
        if (condition.subCondition != null) {
            return FilterDescUtils.translateAstToGrel(condition.subCondition);
        }
        if (StringUtils.isBlank((String)condition.input)) {
            throw new Exception("Filtered column is not defined");
        }
        switch (FilterDesc.FilterUiOperator.fromRepr((String)condition.operator)) {
            case EMPTY_ARRAY: {
                return "arrayLen(val('" + condition.input + "')) == 0";
            }
            case NOT_EMPTY_ARRAY: {
                return "arrayLen(val('" + condition.input + "')) > 0";
            }
            case CONTAINS_ARRAY: {
                return "arrayContains(val('" + condition.input + "'), " + FilterDescUtils.getGrelQuotedString(condition.string) + ")";
            }
            case NOT_CONTAINS_ARRAY: {
                return "arrayLen(val('" + condition.input + "')) == 0 || not(arrayContains(val('" + condition.input + "'), " + FilterDescUtils.getGrelQuotedString(condition.string) + "))";
            }
            case NOT_EMPTY: {
                return "val('" + condition.input + "') != '' && isNotNull(val('" + condition.input + "'))";
            }
            case EMPTY: {
                return "val('" + condition.input + "') == '' || isNull(val('" + condition.input + "'))";
            }
            case NOT_EMPTY_STRING: {
                return "isNotNull(strval('" + condition.input + "'))";
            }
            case EMPTY_STRING: {
                return "isNull(strval('" + condition.input + "'))";
            }
            case IS_TRUE: {
                return "isTrue(asBool(val('" + condition.input + "')))";
            }
            case IS_FALSE: {
                return "not(isTrue(asBool(val('" + condition.input + "'))))";
            }
            case EQUALS_STRING: {
                return "strval('" + condition.input + "') == " + FilterDescUtils.getGrelQuotedString(condition.string);
            }
            case EQUALS_CASE_INSENSITIVE_STRING: {
                return "toLowercase(strval('" + condition.input + "')) == toLowercase(" + FilterDescUtils.getGrelQuotedString(condition.string) + ")";
            }
            case NOT_EQUALS_STRING: {
                return "strval('" + condition.input + "') != " + FilterDescUtils.getGrelQuotedString(condition.string);
            }
            case SAME: {
                return "strval('" + condition.input + "') == strval('" + condition.col + "')";
            }
            case DIFFERENT: {
                return "strval('" + condition.input + "') != strval('" + condition.col + "')";
            }
            case EQUALS_NUMBER: {
                return "val('" + condition.input + "') == " + FilterDescUtils.getNumGrel(condition);
            }
            case NOT_EQUALS_NUMBER: {
                return "val('" + condition.input + "') != " + FilterDescUtils.getNumGrel(condition);
            }
            case GREATER_NUMBER: {
                return "val('" + condition.input + "') > " + FilterDescUtils.getNumGrel(condition);
            }
            case LESS_NUMBER: {
                return "val('" + condition.input + "') < " + FilterDescUtils.getNumGrel(condition);
            }
            case GREATER_OR_EQUAL_NUMBER: {
                return "val('" + condition.input + "') >= " + FilterDescUtils.getNumGrel(condition);
            }
            case LESS_OR_EQUAL_NUMBER: {
                return "val('" + condition.input + "') <= " + FilterDescUtils.getNumGrel(condition);
            }
            case BETWEEN_NUMBER: {
                return "val('" + condition.input + "') >= " + FilterDescUtils.getNumGrel(condition.num) + " && val('" + condition.input + "') <= " + FilterDescUtils.getNumGrel(condition.num2);
            }
            case NOT_BETWEEN_NUMBER: {
                return "val('" + condition.input + "') < " + FilterDescUtils.getNumGrel(condition.num) + " || val('" + condition.input + "') > " + FilterDescUtils.getNumGrel(condition.num2);
            }
            case EQUALS_DATE: {
                return "diff(trunc(val('" + condition.input + "'),'" + condition.unit + "'), trunc(asDate('" + condition.date + " " + condition.time + "', 'yyyy-MM-dd HH:mm'), '" + condition.unit + "'), 'seconds') == 0";
            }
            case GREATER_OR_EQUAL_DATE: {
                return "diff(val('" + condition.input + "'), asDate('" + condition.date + " " + condition.time + "', 'yyyy-MM-dd HH:mm'), 'seconds') >= 0";
            }
            case GREATER_DATE: {
                return "diff(val('" + condition.input + "'), asDate('" + condition.date + " " + condition.time + "', 'yyyy-MM-dd HH:mm'), 'seconds') > 0";
            }
            case LESS_DATE: {
                return "diff(val('" + condition.input + "'), asDate('" + condition.date + " " + condition.time + "', 'yyyy-MM-dd HH:mm'), 'seconds') < 0";
            }
            case LESS_OR_EQUAL_DATE: {
                return "diff(val('" + condition.input + "'), asDate('" + condition.date + " " + condition.time + "', 'yyyy-MM-dd HH:mm'), 'seconds') <= 0";
            }
            case BETWEEN_DATE: {
                return "diff(val('" + condition.input + "'), asDate('" + condition.date + " " + condition.time + "', 'yyyy-MM-dd HH:mm'), 'seconds') >= 0 && diff(val('" + condition.input + "'), asDate('" + condition.date2 + " " + condition.time2 + "', 'yyyy-MM-dd HH:mm'), 'seconds') < 0";
            }
            case EQUALS_COL: {
                return "val('" + condition.input + "') == val('" + condition.col + "')";
            }
            case NOT_EQUALS_COL: {
                return "val('" + condition.input + "') != val('" + condition.col + "')";
            }
            case GREATER_COL: {
                return "val('" + condition.input + "') > val('" + condition.col + "')";
            }
            case LESS_COL: {
                return "val('" + condition.input + "') < val('" + condition.col + "')";
            }
            case GREATER_OR_EQUAL_COL: {
                return "val('" + condition.input + "') >= val('" + condition.col + "')";
            }
            case LESS_OR_EQUAL_COL: {
                return "val('" + condition.input + "') <= val('" + condition.col + "')";
            }
            case CONTAINS_STRING: {
                return "contains(strval('" + condition.input + "'), " + FilterDescUtils.getGrelQuotedString(condition.string) + ")";
            }
            case CONTAINS_CASE_INSENSITIVE_STRING: {
                return "contains(toLowercase(strval('" + condition.input + "')), toLowercase(" + FilterDescUtils.getGrelQuotedString(condition.string) + "))";
            }
            case NOT_CONTAINS_STRING: {
                return "not(contains(strval('" + condition.input + "'), " + FilterDescUtils.getGrelQuotedString(condition.string) + "))";
            }
            case NOT_CONTAINS_CASE_INSENSITIVE_STRING: {
                return "not(contains(toLowercase(strval('" + condition.input + "')), toLowercase(" + FilterDescUtils.getGrelQuotedString(condition.string) + ")))";
            }
            case REGEX: {
                return "arrayLen(match(strval('" + condition.input + "'), " + FilterDescUtils.getGrelQuotedString(condition.string) + ")) > 0";
            }
            case GEO_WITHIN: {
                return "geoContains(" + FilterDescUtils.getGrelQuotedString(condition.string) + "," + condition.input + ")";
            }
            case GEO_CONTAINS: {
                return "geoContains(" + condition.input + "," + FilterDescUtils.getGrelQuotedString(condition.string) + ")";
            }
            case IN_ANY_OF_STRING: 
            case IN_ANY_OF_ENUM: {
                return "arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], strval('" + condition.input + "'))";
            }
            case ARRAY_CONTAINS_ANY_ENUM: {
                return "filter(" + condition.input + ", v, arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], v)).length() > 0";
            }
            case ARRAY_CONTAINS_NONE_ENUM: {
                return "filter(" + condition.input + ", v, arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], v)).length() == 0";
            }
            case ARRAY_CONTAINS_ALL_ENUM: {
                return "filter([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], v, not(arrayContains(" + condition.input + ", v))).length() == 0";
            }
            case IN_NONE_OF_STRING: 
            case IN_NONE_OF_ENUM: {
                return "not(arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], strval('" + condition.input + "')))";
            }
            case IN_ANY_OF_NUMBER: {
                return "arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getNumGrel(item)).collect(Collectors.joining(",")) : "") + "], val('" + condition.input + "'))";
            }
            case IN_NONE_OF_NUMBER: {
                return "not(arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getNumGrel(item)).collect(Collectors.joining(",")) : "") + "], val('" + condition.input + "')))";
            }
            case IN_ANY_OF_DATE: {
                return condition.items != null ? condition.items.stream().map(item -> "diff(trunc(val('" + condition.input + "'),'" + item.unit + "'), trunc(asDate('" + item.date + " " + item.time + "', 'yyyy-MM-dd HH:mm'), '" + item.unit + "'), 'seconds') == 0").collect(Collectors.joining(" || ")) : "";
            }
            case IN_NONE_OF_DATE: {
                return condition.items != null ? "not(" + condition.items.stream().map(item -> "diff(trunc(val('" + condition.input + "'),'" + item.unit + "'), trunc(asDate('" + item.date + " " + item.time + "', 'yyyy-MM-dd HH:mm'), '" + item.unit + "'), 'seconds') == 0").collect(Collectors.joining(" || ")) + ")" : "";
            }
            case STATUS_NO_LONGER_HEALTHY: {
                return "val('" + condition.input + "_cur') != '" + String.valueOf((Object)UnifiedMonitoringStatus.HEALTHY) + "' && val('" + condition.input + "_prev') == '" + String.valueOf((Object)UnifiedMonitoringStatus.HEALTHY) + "'";
            }
            case STATUS_CHANGES: {
                return "val('" + condition.input + "_cur') != val('" + condition.input + "_prev') && isNotNull(val('" + condition.input + "_prev'))";
            }
            case STATUS_BECOMES_ANY_OF: {
                return "arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], strval('" + condition.input + "_cur')) && not(arrayContains([" + (condition.items != null ? condition.items.stream().map(item -> FilterDescUtils.getGrelQuotedString(item.string)).collect(Collectors.joining(",")) : "") + "], strval('" + condition.input + "_prev')))";
            }
        }
        throw new NotImplementedException();
    }

    private static String getNumGrel(FilterDesc.FilterUiCondition condition) {
        return FilterDescUtils.getNumGrel(condition.num);
    }

    private static String getNumGrel(FilterDesc.FilterUiListConditionValue value) {
        return FilterDescUtils.getNumGrel(value.num);
    }

    private static String getNumGrel(double num) {
        if (!Double.isNaN(num) && !Double.isInfinite(num) && num == (double)((long)num)) {
            return Long.toString((long)num);
        }
        return BigDecimal.valueOf(num).stripTrailingZeros().toPlainString();
    }

    private static boolean columnIsTypeString(Schema schema, String colName) {
        return schema.hasColumn(colName) && Objects.equals(schema.getColumn(colName).getType(), Type.STRING);
    }

    private static ExpressionBuilder translateConditionToExpression(FilterDesc.FilterUiCondition condition, ExpressionBuilder.ExpressionBuilderFactory ef, Dataset inputDataset, boolean translateFully, Schema currentSchema, SQLDialect dialect) throws Exception {
        SchemaColumn schemaColumn;
        if (condition.subCondition != null) {
            return FilterDescUtils.translateAstToSql(condition.subCondition, inputDataset, translateFully, currentSchema, dialect);
        }
        if (StringUtils.isBlank((String)condition.input)) {
            throw new Exception("Filtered column is not defined");
        }
        ExpressionBuilder inputCol = ef.col(condition.input);
        SchemaColumn schemaColumn2 = schemaColumn = inputDataset != null && inputDataset.getSchema() != null ? inputDataset.getSchema().getColumn(condition.input) : null;
        if (schemaColumn != null) {
            inputCol = ExpressionUtils.getAdjustedColumn(inputCol, schemaColumn, inputDataset, dialect);
        }
        switch (FilterDesc.FilterUiOperator.fromRepr((String)condition.operator)) {
            case EMPTY_ARRAY: 
            case NOT_EMPTY_ARRAY: 
            case CONTAINS_ARRAY: 
            case NOT_CONTAINS_ARRAY: {
                if (translateFully) {
                    throw new Exception("Cannot translate an expression using \"Array contains value\" operator to SQL");
                }
                return ef.expr("1 = 1");
            }
            case NOT_EMPTY: {
                return inputCol.castToString(100).ne("").and(inputCol.isnotnull());
            }
            case EMPTY: {
                return inputCol.castToString(100).eq("").or(inputCol.isnull());
            }
            case NOT_EMPTY_STRING: {
                return inputCol.isnotnull();
            }
            case EMPTY_STRING: {
                return inputCol.isnull();
            }
            case IS_TRUE: {
                return inputCol.castToBoolean().isTrue();
            }
            case IS_FALSE: {
                return inputCol.castToBoolean().isFalse();
            }
            case EQUALS_STRING: {
                return inputCol.eq(ef.cst((Object)condition.string, Type.STRING));
            }
            case NOT_EQUALS_STRING: {
                return inputCol.ne(ef.cst((Object)condition.string, Type.STRING));
            }
            case EQUALS_CASE_INSENSITIVE_STRING: {
                return inputCol.lower().eq(ef.cst((Object)condition.string, Type.STRING).lower());
            }
            case SAME: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                return inputCol.eq(ef.col(condition.col));
            }
            case DIFFERENT: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                return inputCol.ne(ef.col(condition.col));
            }
            case EQUALS_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.eq(FilterDescUtils.getNumCst(condition, ef));
            }
            case NOT_EQUALS_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.ne(FilterDescUtils.getNumCst(condition, ef));
            }
            case GREATER_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.gt(FilterDescUtils.getNumCst(condition, ef));
            }
            case LESS_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.lt(FilterDescUtils.getNumCst(condition, ef));
            }
            case GREATER_OR_EQUAL_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.gte(FilterDescUtils.getNumCst(condition, ef));
            }
            case LESS_OR_EQUAL_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.lte(FilterDescUtils.getNumCst(condition, ef));
            }
            case BETWEEN_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.gte(FilterDescUtils.getNumCst(condition.num, ef)).and(inputCol.lte(FilterDescUtils.getNumCst(condition.num2, ef)));
            }
            case NOT_BETWEEN_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.lt(FilterDescUtils.getNumCst(condition.num, ef)).or(inputCol.gt(FilterDescUtils.getNumCst(condition.num2, ef)));
            }
            case EQUALS_DATE: {
                Object eqDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date, condition.time);
                Object eqDateLower = FilterDescUtils.truncate(eqDate, condition.unit);
                Object eqDateUpper = FilterDescUtils.increment(eqDateLower, condition.unit, 1);
                if (eqDateLower.equals(eqDateUpper)) {
                    return inputCol.eq(ef.cst(eqDateLower));
                }
                return inputCol.gte(ef.cst(eqDateLower)).and(inputCol.lt(ef.cst(eqDateUpper)));
            }
            case GREATER_OR_EQUAL_DATE: {
                Object gteDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date, condition.time);
                Object gteDateLower = FilterDescUtils.truncate(gteDate, "seconds");
                return inputCol.gte(ef.cst(gteDateLower));
            }
            case GREATER_DATE: {
                Object gtDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date, condition.time);
                Object gtDateLower = FilterDescUtils.truncate(gtDate, "seconds");
                return inputCol.gt(ef.cst(gtDateLower));
            }
            case LESS_DATE: {
                Object ltDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date, condition.time);
                Object ltDateUpper = FilterDescUtils.truncate(ltDate, "seconds");
                return inputCol.lt(ef.cst(ltDateUpper));
            }
            case LESS_OR_EQUAL_DATE: {
                Object lteDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date, condition.time);
                Object lteDateUpper = FilterDescUtils.truncate(lteDate, "seconds");
                return inputCol.lte(ef.cst(lteDateUpper));
            }
            case BETWEEN_DATE: {
                Object betweenGteDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date, condition.time);
                Object betweenGteDateLower = FilterDescUtils.truncate(betweenGteDate, "seconds");
                Object betweenLtDate = FilterDescUtils.makeTemporalConstant(schemaColumn, condition.date2, condition.time2);
                Object betweenLtDateUpper = FilterDescUtils.truncate(betweenLtDate, "seconds");
                DKULogger.getLogger((String)"dku.filter").info((Object)("between " + String.valueOf(betweenGteDate.getClass()) + " and " + String.valueOf(betweenLtDate.getClass())));
                DKULogger.getLogger((String)"dku.filter").info((Object)("      > " + String.valueOf(betweenGteDateLower.getClass()) + " and " + String.valueOf(betweenLtDateUpper.getClass())));
                DKULogger.getLogger((String)"dku.filter").info((Object)("      = " + betweenGteDateLower.toString() + " and " + betweenLtDateUpper.toString()));
                return inputCol.gte(ef.cst(betweenGteDateLower)).and(inputCol.lt(ef.cst(betweenLtDateUpper)));
            }
            case EQUALS_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.col)) {
                    return inputCol.eq(ef.col(condition.col).castToDouble());
                }
                return inputCol.eq(ef.col(condition.col));
            }
            case NOT_EQUALS_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.col)) {
                    return inputCol.ne(ef.col(condition.col).castToDouble());
                }
                return inputCol.ne(ef.col(condition.col));
            }
            case GREATER_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.col)) {
                    return inputCol.gt(ef.col(condition.col).castToDouble());
                }
                return inputCol.gt(ef.col(condition.col));
            }
            case LESS_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.col)) {
                    return inputCol.lt(ef.col(condition.col).castToDouble());
                }
                return inputCol.lt(ef.col(condition.col));
            }
            case GREATER_OR_EQUAL_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.col)) {
                    return inputCol.gte(ef.col(condition.col).castToDouble());
                }
                return inputCol.gte(ef.col(condition.col));
            }
            case LESS_OR_EQUAL_COL: {
                if (StringUtils.isBlank((String)condition.col)) {
                    throw new Exception("Comparison column is not defined");
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.col)) {
                    return inputCol.lte(ef.col(condition.col).castToDouble());
                }
                return inputCol.lte(ef.col(condition.col));
            }
            case CONTAINS_STRING: {
                return inputCol.contains(ef.cst(condition.string));
            }
            case CONTAINS_CASE_INSENSITIVE_STRING: {
                return inputCol.lower().contains(ef.cst(condition.string).lower());
            }
            case NOT_CONTAINS_STRING: {
                return inputCol.contains(ef.cst(condition.string)).not();
            }
            case NOT_CONTAINS_CASE_INSENSITIVE_STRING: {
                return inputCol.lower().contains(ef.cst(condition.string).lower()).not();
            }
            case REGEX: {
                if (translateFully) {
                    throw new Exception("Cannot translate an expression using \"Matches the regex\" operator to SQL");
                }
                return ef.expr("1 = 1");
            }
            case GEO_WITHIN: {
                return inputCol.stWithin(ef.cst(condition.string));
            }
            case GEO_CONTAINS: {
                return inputCol.stContains(ef.cst(condition.string));
            }
            case IN_ANY_OF_STRING: 
            case IN_ANY_OF_ENUM: {
                return inputCol.inList(condition.items.stream().map(item -> ef.cst(item.string)).collect(Collectors.toList()));
            }
            case IN_NONE_OF_STRING: 
            case IN_NONE_OF_ENUM: {
                return inputCol.inList(condition.items.stream().map(item -> ef.cst(item.string)).collect(Collectors.toList())).not();
            }
            case IN_ANY_OF_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.inList(condition.items.stream().map(item -> FilterDescUtils.getNumCst(item, ef)).collect(Collectors.toList()));
            }
            case IN_NONE_OF_NUMBER: {
                if (FilterDescUtils.columnIsTypeString(currentSchema, condition.input)) {
                    inputCol = inputCol.castToDouble();
                }
                return inputCol.inList(condition.items.stream().map(item -> FilterDescUtils.getNumCst(item, ef)).collect(Collectors.toList())).not();
            }
            case IN_ANY_OF_DATE: {
                return ef.or(FilterDescUtils.getConditionDateValues(schemaColumn, inputCol, condition, ef));
            }
            case IN_NONE_OF_DATE: {
                return ef.or(FilterDescUtils.getConditionDateValues(schemaColumn, inputCol, condition, ef)).not();
            }
        }
        throw new NotImplementedException();
    }

    private static Object makeTemporalConstant(SchemaColumn schemaColumn, String datePart, String timePart) {
        String s = datePart + "T" + timePart + ":00.00Z";
        if (schemaColumn == null || schemaColumn.getType() == Type.DATE) {
            return ISODateTimeFormat.dateTimeParser().parseDateTime(s);
        }
        if (schemaColumn.getType() == Type.DATEONLY) {
            return DKUDateUtils.ymdDashOrSlash().parseLocalDate(datePart);
        }
        if (schemaColumn.getType() == Type.DATETIMENOTZ) {
            return ISODateTimeFormat.dateTimeParser().parseDateTime(s).withZone(DateTimeZone.UTC).toLocalDateTime();
        }
        return s;
    }

    private static ExpressionBuilder[] getConditionDateValues(SchemaColumn schemaColumn, ExpressionBuilder inputCol, FilterDesc.FilterUiCondition condition, ExpressionBuilder.ExpressionBuilderFactory ef) throws Exception {
        ArrayList<ExpressionBuilder> inAnyList = new ArrayList<ExpressionBuilder>();
        for (FilterDesc.FilterUiListConditionValue item : condition.items) {
            Object eqDate = FilterDescUtils.makeTemporalConstant(schemaColumn, item.date, item.time);
            Object eqDateLower = FilterDescUtils.truncate(eqDate, item.unit);
            Object eqDateUpper = FilterDescUtils.increment(eqDateLower, item.unit, 1);
            inAnyList.add(inputCol.gte(ef.cst(eqDateLower)).and(inputCol.lt(ef.cst(eqDateUpper))));
        }
        return inAnyList.toArray(new ExpressionBuilder[0]);
    }

    private static ExpressionBuilder getNumCst(FilterDesc.FilterUiCondition condition, ExpressionBuilder.ExpressionBuilderFactory ef) {
        return FilterDescUtils.getNumCst(condition.num, ef);
    }

    private static ExpressionBuilder getNumCst(FilterDesc.FilterUiListConditionValue value, ExpressionBuilder.ExpressionBuilderFactory ef) {
        return FilterDescUtils.getNumCst(value.num, ef);
    }

    private static ExpressionBuilder getNumCst(double num, ExpressionBuilder.ExpressionBuilderFactory ef) {
        if (!Double.isNaN(num) && !Double.isInfinite(num) && num == (double)((long)num)) {
            return ef.cst((long)num);
        }
        return ef.cst(num);
    }

    private static Object truncate(Object dt, String unit) throws Exception {
        return new DateTrunc().call(new Properties(), new Object[]{dt, unit});
    }

    private static Object increment(Object dt, String unit, int delta) throws Exception {
        return new Inc().call(new Properties(), new Object[]{dt, delta, unit});
    }

    public static String getRawExpression(FilterDesc filter) {
        return filter != null ? filter.expression : "";
    }

    public static String getGrelExpression(FilterDesc filter) throws Exception {
        return FilterDescUtils.getGrelExpression(filter, false);
    }

    public static String getGrelExpression(FilterDesc filter, boolean sortConditionsAlphabetically) throws Exception {
        if (filter == null || !filter.enabled) {
            return null;
        }
        if (filter.uiData == null) {
            return filter.expression;
        }
        switch (filter.uiData.mode) {
            case "CUSTOM": 
            case "ES_QUERY_STRING": {
                return filter.expression;
            }
            case "SQL": {
                throw new IllegalArgumentException("Cannot translate SQL expression to DSS formula");
            }
        }
        return FilterDescUtils.translateAstToGrel(filter, sortConditionsAlphabetically);
    }

    public static GrelExpression getGrelFilterExpression(FilterDesc filter) throws Exception {
        String expr = FilterDescUtils.getGrelExpression(filter);
        if (expr == null) {
            return null;
        }
        return new GrelExpression(expr, filter.expressionVariablesContext);
    }

    public static String getSQLExpression(FilterDesc filter) throws Exception {
        return FilterDescUtils.getSQLExpression(filter, null, null, false);
    }

    public static String getSQLExpression(FilterDesc filter, SQLDialect dialect, Dataset inputDataset, boolean translateFully) throws Exception {
        if (filter == null || !filter.enabled) {
            return null;
        }
        if (filter.uiData == null) {
            if (filter.language == FilterDesc.ExpressionLanguage.SQL) {
                return filter.expression;
            }
            return FilterDescUtils.getTranslatedSQLExpression(filter, dialect, inputDataset == null ? null : inputDataset.getSchema(), translateFully);
        }
        switch (filter.uiData.mode) {
            case "SQL": {
                return filter.expression;
            }
            case "CUSTOM": {
                return FilterDescUtils.getTranslatedSQLExpression(filter, dialect, inputDataset == null ? null : inputDataset.getSchema(), translateFully);
            }
            case "ES_QUERY_STRING": {
                throw new IllegalArgumentException("ElasticSearch query string cannot be converted to SQL");
            }
        }
        return FilterDescUtils.translateAstToSql(filter, inputDataset, translateFully, dialect).toSQL(dialect);
    }

    public static String getElasticSearchQueryString(FilterDesc filter, ElasticSearchDialect dialect) {
        if (filter == null || !filter.enabled || filter.uiData == null) {
            return null;
        }
        if (!"ES_QUERY_STRING".equals(filter.uiData.mode)) {
            throw new IllegalArgumentException("Unsupported filter type: " + filter.uiData.mode);
        }
        if (dialect != ElasticSearchDialect.ES_7) {
            throw new IllegalArgumentException("Only ES7 dialect is supported, found: " + String.valueOf((Object)dialect));
        }
        return filter.expression;
    }

    public static ExpressionBuilder getSQLExpressionBuilder(FilterDesc filter, SQLDialect dialect, Dataset inputDataset, boolean translateFully) {
        if (filter == null || !filter.enabled) {
            return null;
        }
        if (filter.uiData == null) {
            if (filter.language == FilterDesc.ExpressionLanguage.SQL) {
                return new ExpressionBuilder.ExpressionBuilderFactory().expr(filter.expression);
            }
            return FilterDescUtils.getTranslatedSQLExpressionBuilder(filter, dialect, inputDataset, translateFully);
        }
        switch (filter.uiData.mode) {
            case "SQL": {
                return new ExpressionBuilder.ExpressionBuilderFactory().expr(filter.expression);
            }
            case "CUSTOM": {
                return FilterDescUtils.getTranslatedSQLExpressionBuilder(filter, dialect, inputDataset, translateFully);
            }
            case "ES_QUERY_STRING": {
                throw new IllegalArgumentException("ElasticSearch query string cannot be converted to SQL");
            }
        }
        return FilterDescUtils.translateAstToSql(filter, inputDataset, translateFully, dialect);
    }

    private static String getTranslatedSQLExpression(FilterDesc filter, SQLDialect dialect, Schema schema, boolean translateFully) throws Exception {
        Expression expression = new Expression(filter.expression, schema);
        expression.setVariablesContext(filter.expressionVariablesContext);
        GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect), schema);
        try {
            GrelTranslator.TranslationResult<String> res = translator.translateToString(expression, translateFully);
            return (String)res.result;
        }
        catch (GrelTranslator.NonTranslatableOperatorException e) {
            throw new IllegalArgumentException("Operator cannot be translated to SQL: " + e.getMessage());
        }
    }

    private static ExpressionBuilder getTranslatedSQLExpressionBuilder(FilterDesc filter, SQLDialect dialect, Dataset inputDataset, boolean translateFully) {
        Schema schema = inputDataset != null ? inputDataset.getSchema() : null;
        Expression expression = new Expression(filter.expression, schema);
        expression.setVariablesContext(filter.expressionVariablesContext);
        GrelToQueryMapping mapping = new GrelToQueryMapping(dialect);
        if (inputDataset != null) {
            boolean managedDS = inputDataset.isManaged();
            DatasetHandler.DatasetParams params = ExpressionUtils.getTimezoneConfig(inputDataset);
            mapping.adjustCastToDate(schema, managedDS, params);
        }
        GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)mapping, schema);
        try {
            GrelTranslator.TranslationResult<ExpressionBuilder> res = translator.translateToQuery(expression, translateFully);
            return (ExpressionBuilder)res.result;
        }
        catch (GrelTranslator.NonTranslatableOperatorException e) {
            throw new IllegalArgumentException("Operator cannot be translated to SQL: " + e.getMessage());
        }
    }

    public static boolean isNormalized(FilterDesc filter) {
        return filter == null || FilterDescUtils.willFilter(filter) || !filter.enabled && filter.uiData == null && StringUtils.isBlank((String)filter.expression);
    }

    public static void normalize(FilterDesc filter) {
        if (!FilterDescUtils.isNormalized(filter)) {
            filter.enabled = false;
            filter.uiData = null;
            filter.expression = null;
        }
    }
}

