/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.FuzzyJoinBuiltinRecipeExecutor;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.utils.JSON;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class FuzzyJoinRecipeRunner
implements RecipeRunner,
RecipeRunnerWithPayload,
AbortableRecipeRunner,
ContainerizedDSSEngineAble {
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final FuzzyJoinRecipeHelper helper = new FuzzyJoinRecipeHelper();
    private FuzzyJoinRecipePayloadParams payload;
    private InitializableAbortableRecipeRunner executor;
    private String serializedPayload;
    private boolean isRunningInContainer = false;
    private static final Logger logger = Logger.getLogger((String)"dku.recipe.fuzzyjoin.runner");

    public FuzzyJoinRecipeRunner(JobActivity activity) {
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.activity = activity;
        this.recipe = subgraph.getRecipe();
    }

    @Override
    public void setPayload(String serializedPayload) {
        logger.info((Object)("SET PAYLOAD: " + serializedPayload));
        this.serializedPayload = serializedPayload;
        this.payload = this.helper.loadParams(serializedPayload, this.recipe.getModel());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public synchronized void init() throws Exception {
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        JobContext.getCurrentActivitySummary().engineType = "DSS";
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.payload.engineParams.containerSelection, this.recipe.getModel(), this.serializedPayload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            this.executor = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
        } else {
            logger.info((Object)"Run locally");
            FuzzyJoinBuiltinRecipeExecutor builtinExecutor = new FuzzyJoinBuiltinRecipeExecutor(this.activity, this.payload.debugMode);
            builtinExecutor.setPayload(JSON.json((Object)this.payload));
            this.executor = builtinExecutor;
        }
        this.executor.init();
    }

    @Override
    public void run() throws Exception {
        this.executor.run();
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.executor != null) {
            this.executor.notifyBeforeAborting();
        }
    }
}

