/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.CosineMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.EuclideanMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.ExactMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.GeoMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.HammingMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.IdleMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.JaccardMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.LevenshteinMatcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;

public class MatcherFactory {
    private MatcherFactory() {
    }

    public static Matcher getMatcher(FuzzyJoinRecipePayloadParams.DistanceType type, double threshold, Integer relativeTo, boolean debugMode) {
        switch (type) {
            case LEVENSHTEIN: {
                return new LevenshteinMatcher(threshold, relativeTo, debugMode);
            }
            case HAMMING: {
                return new HammingMatcher(threshold, relativeTo, debugMode);
            }
            case COSINE: {
                return new CosineMatcher(threshold, relativeTo, debugMode);
            }
            case JACCARD: {
                return new JaccardMatcher(threshold, relativeTo, debugMode);
            }
            case EUCLIDEAN: {
                return new EuclideanMatcher(threshold, relativeTo, debugMode);
            }
            case GEO: {
                return new GeoMatcher(threshold, relativeTo, debugMode);
            }
            case EXACT_HASH: {
                return new IdleMatcher(threshold, relativeTo, debugMode);
            }
        }
        return new ExactMatcher(threshold, relativeTo, debugMode);
    }
}

