/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.dataflow.exec.geojoin.GeoUtils;
import org.geotools.filter.spatial.BeyondImpl;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Beyond;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeodesicBeyond
extends BeyondImpl {
    private static final GeodeticCalculator calculator = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    GeoUtils.MinMaxDegrees minMaxDegreeBounds;

    public GeodesicBeyond(Expression e1, Expression e2, double meters, String units, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
        super.setDistance(meters);
        super.setUnits(units);
        Geometry geometry = GeoUtils.geometryFromLiteralExpression(e1, e2);
        Envelope envelope = geometry.getEnvelopeInternal();
        this.minMaxDegreeBounds = GeoUtils.minMaxDegrees(envelope, (Double)meters);
    }

    public boolean evaluateInternal(Geometry left, Geometry right) {
        if (left == null) {
            return false;
        }
        DistanceOp op = new DistanceOp(left, right);
        if (op.distance() <= this.minMaxDegreeBounds.min) {
            return false;
        }
        if (op.distance() > this.minMaxDegreeBounds.max) {
            return true;
        }
        Coordinate[] nearestPoints = op.nearestPoints();
        Coordinate p1 = nearestPoints[0];
        Coordinate p2 = nearestPoints[1];
        calculator.setStartingGeographicPoint(p1.x, p1.y);
        calculator.setDestinationGeographicPoint(p2.x, p2.y);
        return calculator.getOrthodromicDistance() > this.getDistance();
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Beyond)this, extraData);
    }
}

