/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.DatabricksSupport;
import com.dataiku.dip.dataflow.exec.sync.DatabricksToCloud;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatabricksToS3
extends DatabricksToCloud<S3DatasetHandler> {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.databrickstos3");

    public static void setCompatible(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        status.isSelectable = true;
        if (inputMeta != BuiltinSQLDatasets.DATABRICKS_META) {
            status.markAsNonSelectable("Input dataset is not in Databricks", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(outputDS, "S3")) {
            status.markAsNonSelectable("Output dataset is not in AWS S3", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (!DatasetInspector.isSQLTable(inputDS)) {
            status.markAsNonSelectable("Input dataset is not a SQL table dataset", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            DatabricksToS3.getCopyMode(outputDS);
        }
        catch (CloudBlobSupport.CloudBlobToSQLImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    String getRoot(S3DatasetHandler blobHandler) throws CodedException, IOException, DKUSecurityException {
        return blobHandler.getInformationalRootPath();
    }

    @Override
    void setUpCredentials(S3DatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData, Statement stmt) throws SQLException, IOException, DKUSecurityException {
        EC2Connection ec2 = blobHandler.getConnection();
        String bucket = blobHandler.getBucket();
        DatabricksSupport.setS3Credentials(this.authCtx, stmt, ec2, bucket);
    }

    @Override
    CloudToDatabricks.DisplayableSQLChunk getCredentials(S3DatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData) throws SQLException, IOException, DKUSecurityException {
        String bucket = blobHandler.getBucket();
        String storageCredential = ((DatabricksConnection)connData.getConnection()).params.getStorageCredentials(bucket);
        logger.info((Object)("Will use storage credentials " + storageCredential));
        if (storageCredential == null) {
            return null;
        }
        if (StringUtils.isBlank((String)storageCredential)) {
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIAL `%s` )", storageCredential));
    }

    @Override
    String getStorageCredentials(S3DatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData) {
        String bucket = blobHandler.getBucket();
        return ((DatabricksConnection)connData.getConnection()).params.getStorageCredentials(bucket);
    }

    @Override
    public void run() throws Exception {
        CloudBlobSupport.CopyMode mode = DatabricksToS3.getCopyMode(this.outputDS);
        try (AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             S3DatasetHandler sdh = (S3DatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.outputDS);){
            SQLUtils.SQLTable inputTable = dsh.getResolvedTable();
            try (SQLConnectionProvider.SQLConnectionWrapper connWrapper = dsh.newConnection();){
                this.executeCopy(connWrapper, sdh, mode, inputTable);
            }
            catch (Exception e) {
                logger.error((Object)"Databricks unload failed", (Throwable)e);
                throw e;
            }
        }
    }
}

