/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.update;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.update.UpdateRecipeParams;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateRecipeSchemaComputer
extends RecipeSchemaComputer {
    @Autowired
    private TransactionService transactionService;
    static DKULogger logger = DKULogger.getLogger((String)"update");

    public UpdateRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    public Schema getSchema() throws Exception {
        AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
        Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
        AnyLoc outputLoc = this.recipe.getSingleOutput("main").getLoc(this.recipe.projectKey);
        Dataset outputDataset = this.datasetAccessService.getMandatory(outputLoc);
        UpdateRecipeParams params = RecipeRegistry.getParamsAs(this.activity, UpdateRecipeParams.class);
        Schema schema = params.deleteMissingCols && params.addMissingCols ? inputDataset.getSchema() : (!params.deleteMissingCols && !params.addMissingCols ? outputDataset.getSchema() : (params.deleteMissingCols && !params.addMissingCols ? SchemaUtils.intersect(inputDataset.getSchema(), outputDataset.getSchema()) : SchemaUtils.union(inputDataset.getSchema(), outputDataset.getSchema())));
        return schema;
    }
}

