/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RecentActivityView
extends AbstractFlowTool.FlowView {
    @Autowired
    private TimelinesInternalDB timelinesDB;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private RecentActivityViewState state;
    private RecentActivityViewOptions options = new RecentActivityViewOptions();
    private static final List<ITaggingService.TaggableType> FLOW_TYPES = Lists.newArrayList((Object[])new ITaggingService.TaggableType[]{ITaggingService.TaggableType.DATASET, ITaggingService.TaggableType.RECIPE, ITaggingService.TaggableType.SAVED_MODEL, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, ITaggingService.TaggableType.MANAGED_FOLDER, ITaggingService.TaggableType.LABELING_TASK});
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.lastModified");

    public RecentActivityView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject jsonOptions) throws Exception {
        RecentActivityViewOptions options = (RecentActivityViewOptions)JSON.parse((JsonElement)jsonOptions, RecentActivityViewOptions.class);
        if (options != null) {
            this.options = options;
        }
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized RecentActivityViewState computeState() throws Exception {
        logger.info((Object)("Compute activity since " + this.options.since));
        this.state = new RecentActivityViewState();
        this.state.options = this.options;
        long since = 0L;
        if (this.options != null && StringUtils.isNotBlank((String)this.options.since)) {
            since = DKUtils.getISODateFormatter().parseMillis(this.options.since);
        }
        Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> timelineItems = this.timelinesDB.getRecentTimelineItems(Lists.newArrayList((Object[])new String[]{this.projectKey}), since);
        try (Transaction tr = this.transactionService.beginRead();){
            for (TaggableObjectsService.TaggableObjectRef ref : timelineItems.keySet()) {
                FutureProgressState.checkInterrupt();
                if (!FLOW_TYPES.contains((Object)ref.type) || this.taggableObjectsReadService.getOrNullUnsafe(ref) == null) continue;
                String nodeId = GraphIds.forRef(ref);
                this.add(nodeId, ref, timelineItems.get(ref));
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, TaggableObjectsService.TaggableObjectRef ref, List<TimelineItem> tis) {
        this.state.valueByNode.put(nodeId, new RecentActivity());
        RecentActivity activity = this.state.valueByNode.get(nodeId);
        activity.numberOfModifications = tis.size();
    }

    public class RecentActivityViewOptions {
        String since;
    }

    public class RecentActivityViewState
    implements AbstractFlowTool.FlowState {
        Map<String, RecentActivity> valueByNode = new HashMap<String, RecentActivity>();
        public RecentActivityViewOptions options;
        public Collection<String> focused = new HashSet<String>();
    }

    public class RecentActivity {
        int numberOfModifications;
        String lastUserLogin;
        String lastUserDisplayName;
        Set<PublicUser> contributors = new HashSet<PublicUser>();
    }
}

