/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.MetricInNumericRangeCheck;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class AbstractColumnsInRangeRule
extends AbstractMultiColumnRule {
    public List<String> columns = new ArrayList<String>();
    public double minimum;
    public boolean minimumEnabled;
    public double maximum;
    public boolean maximumEnabled;
    public double softMinimum;
    public boolean softMinimumEnabled;
    public double softMaximum;
    public boolean softMaximumEnabled;

    public static boolean isRangeViolation(double value, boolean minEnabled, double min, boolean maxEnabled, double max) {
        return minEnabled && value < min || maxEnabled && value > max;
    }

    public boolean isHardRangeViolation(double value) {
        return AbstractColumnsInRangeRule.isRangeViolation(value, this.minimumEnabled, this.minimum, this.maximumEnabled, this.maximum);
    }

    public boolean isSoftRangeViolation(double value) {
        return AbstractColumnsInRangeRule.isRangeViolation(value, this.softMinimumEnabled, this.softMinimum, this.softMaximumEnabled, this.softMaximum);
    }

    public static Optional<ExpressionBuilder> buildViolationCondition(ExpressionBuilder.ExpressionBuilderFactory ebf, String columnName, boolean minEnabled, double min, boolean maxEnabled, double max) {
        Optional minViolation = minEnabled ? Optional.of(ebf.col(columnName).lt(min)) : Optional.empty();
        Optional maxViolation = maxEnabled ? Optional.of(ebf.col(columnName).gt(max)) : Optional.empty();
        return Stream.of(minViolation, maxViolation).filter(Optional::isPresent).map(Optional::get).reduce((rec$, xva$0) -> ((ExpressionBuilder)rec$).or((ExpressionBuilder)xva$0));
    }

    public abstract String getMetricsIdForOneColumn(String var1);

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<Metric> getMetricsForOneColumn(String column) {
        return Collections.singletonList(Metric.deserializeMetric(this.getMetricsIdForOneColumn(column)));
    }

    @Override
    protected AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        return this.getCheck(column).run(authCtx, context, runReport);
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    private MetricInNumericRangeCheck getCheck(String column) {
        MetricInNumericRangeCheck check = new MetricInNumericRangeCheck();
        check.displayName = this.displayName;
        check.metricId = this.getMetricsIdForOneColumn(column);
        check.computeOnBuildMode = this.computeOnBuildMode;
        check.autoRun = this.autoRun;
        check.enabled = this.enabled;
        check.minimum = this.minimum;
        check.maximum = this.maximum;
        check.softMinimum = this.softMinimum;
        check.softMaximum = this.softMaximum;
        check.minimumEnabled = this.minimumEnabled;
        check.maximumEnabled = this.maximumEnabled;
        check.softMinimumEnabled = this.softMinimumEnabled;
        check.softMaximumEnabled = this.softMaximumEnabled;
        return check;
    }
}

